% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realizedMeasures.R
\name{rMedRV}
\alias{rMedRV}
\title{rMedRV}
\usage{
rMedRV(rData, alignBy = NULL, alignPeriod = NULL, makeReturns = FALSE)
}
\arguments{
\item{rData}{an \code{xts} or \code{data.table} object containing returns or prices, possibly for multiple assets over multiple days}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. Possible values are: \code{"secs"}, \code{"seconds"}, \code{"mins"}, \code{"minutes"}, \code{"hours"}.}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. For example, to aggregate
based on a 5-minute frequency, set \code{alignPeriod = 5} and \code{alignBy = "minutes"}.}

\item{makeReturns}{boolean, should be \code{TRUE} when \code{rData} contains prices instead of returns. \code{FALSE} by default.}
}
\value{
\itemize{
\item In case the input is an \code{xts} object with data from one day, a numeric of the same length as the number of assets.
\item If the input data spans multiple days and is in \code{xts} format, an \code{xts} will be returned.
\item If the input data is a \code{data.table} object, the function returns a \code{data.table} with the same column names as the input data, containing the date and the realized measures.
}
}
\description{
Calculate the rMedRV, defined in Andersen et al. (2012). 
Let \eqn{r_{t,i}} be a return (with \eqn{i=1,\ldots,M}) in period \eqn{t}.
Then, the rMedRV is given by
\deqn{
 \mbox{rMedRV}_{t}=\frac{\pi}{6-4\sqrt{3}+\pi}\left(\frac{M}{M-2}\right) \sum_{i=2}^{M-1} \mbox{med}(|r_{t,i-1}|,|r_{t,i}|, |r_{t,i+1}|)^2
}
}
\details{
The rMedRV belongs to the class of realized volatility measures in this package
that use the series of high-frequency returns \eqn{r_{t,i}} of a day \eqn{t}
to produce an ex post estimate of the realized volatility of that day \eqn{t}.
rMedRV is designed to be robust to price jumps.
The difference between RV and rMedRV is an estimate of the realized jump
variability. Disentangling the continuous and jump components in RV
can lead to more precise volatility forecasts,
as shown in Andersen et al. (2012)
}
\examples{
medrv <- rMedRV(rData = sampleTData[, list(DT, PRICE)], alignBy = "minutes",
               alignPeriod = 5, makeReturns = TRUE)
medrv
}
\references{
Andersen, T. G., Dobrev, D., and Schaumburg, E. (2012). Jump-robust volatility estimation using nearest neighbor truncation. \emph{Journal of Econometrics}, 169, 75-93.
}
\author{
Jonathan Cornelissen, Kris Boudt, and Emil Sjoerup.
}
\keyword{volatility}
