% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realized_measures.R
\name{rAVGCov}
\alias{rAVGCov}
\title{Realized Covariance: Average Subsample}
\usage{
rAVGCov(
  rData,
  cor = FALSE,
  alignBy = "minutes",
  alignPeriod = 5,
  k = 1,
  makeReturns = FALSE
)
}
\arguments{
\item{rData}{a \eqn{(M x N)} matrix/zoo/xts object containing the \eqn{N}
return series over period \eqn{t}, with \eqn{M} observations during \eqn{t}.}

\item{cor}{boolean, in case it is TRUE, the correlation is returned. FALSE by default.}

\item{alignBy}{Align the tick data to seconds|minutes|hours. Default is \code{"minutes"}}

\item{alignPeriod}{Align the tick data to this many [seconds|minutes|hours]. This can be a fraction. Default is \code{5}}

\item{k}{numeric denoting which horizon to use for the subsambles. This can be a fraction as long as k is a divisor of alignPeriod default is \code{1}}

\item{makeReturns}{Prices are passed make them into log returns}
}
\value{
Realized covariance using average subsample.
}
\description{
Realized Covariance using average subsample.
}
\examples{
# Average subsampled realized variance/covariance aligned at one minute returns at 
# 5 subgrids (5 minutes).

# Univariate
rvSub <- rAVGCov(rData = sampleTData$PRICE, alignBy = "minutes",
                 alignPeriod = 5, makeReturns = TRUE) 
rvSub

# Multivariate:
rcovSub <- rAVGCov(rData = cbind(lltc, sbux, fill = 0), alignBy = "minutes", 
                   alignPeriod = 5, makeReturns = FALSE)
rcovSub

# Multivariate with a 30 second fast aggregation and a 2.5 minute slow aggregation.
rcovSub <- rAVGCov(rData = cbind(lltc, sbux, fill = 0), 
                   alignBy = "minutes", alignPeriod = 2.5, k = 0.5, makeReturns = FALSE)
rcovSub
}
\references{
L. Zhang, P.A Mykland, and Y. Ait-Sahalia. A tale of two time scales: Determining integrated volatility with noisy high-frequency data. \emph{Journal of the American Statistical Association}, 2005.

Michiel de Pooter, Martin Martens, and Dick van Dijk. Predicting the daily covariance matrix for S\&P100 stocks using intraday data - but which frequency to use? \emph{Econometric Reviews}, 2008.
}
\author{
Scott Payseur
}
\keyword{volatility}
