% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heavy_model.R
\name{heavyModel}
\alias{heavyModel}
\title{HEAVY Model estimation}
\usage{
heavyModel(data, p = matrix(c(0, 0, 1, 1), ncol = 2), q = matrix(c(1,
  0, 0, 1), ncol = 2), startingvalues = NULL, LB = NULL, UB = NULL,
  backcast = NULL, compconst = FALSE)
}
\arguments{
\item{data}{a (T x K) matrix containing the data, with T the number of days. For the traditional HEAVY model: K = 2, the first column contains the squared daily demeaned returns, the second column contains the realized measures.}

\item{p}{a (K x K) matrix containing the lag length for the model innovations. Position (i, j) in the matrix indicates the number of lags in equation i of the model for the innovations in data column j. For the traditional heavy model p is given by matrix(c(0,0,1,1), ncol = 2) (default).}

\item{q}{a (K x K) matrix containing the lag length for the conditional variances. Position (i, j) in the matrix indicates the number of lags in equation i of the model for conditional variances corresponding to series j. For the traditional heavy model introduced above q is given by matrix( c(1,0,0,1),ncol=2 ) (default).}

\item{startingvalues}{a vector containing the starting values to be used in the optimization to find the optimal parameters estimates.}

\item{LB}{a vector of length K indicating the lower bounds to be used in the estimation. If NULL it is set to a vector of zeros by default.}

\item{UB}{a vector of length K indicating the upper bounds to be used in the estimation. If NULL it is set to a vector of Inf by default.}

\item{backcast}{a vector of length K used to initialize the estimation. If NULL the unconditional estimates are taken.}

\item{compconst}{a boolean variable. In case TRUE, the omega values are estimated in the optimization. In case FALSE, volatility targeting is done and omega is just 1 minus the sum of all relevant alpha's and beta's multiplied by the unconditional variance.}
}
\value{
A list with the following values:
(i) loglikelihood: the log likelihood evaluated at the parameter estimates.
(ii) likelihoods: an xts object of length T containing the log likelihoods per day.
(iii) condvar: a (T x K) xts object containing the conditional variances
(iv) estparams: a vector with the parameter estimates. The order in which the
parameters are reported is as follows: First the estimates for omega then the
estimates for the non-zero alpha's with the most recent lags first in case max(p) > 1,
then the estimates for the non-zero beta's with the most recent lag first in case
max(q) > 1.
(v) convergence: an integer code indicating the successfulness of the optimization. See \verb{optim} for more information.
}
\description{
This function calculatest the High frEquency bAsed VolatilitY (HEAVY) model proposed in Shephard and Sheppard (2010). This function is used as a predictive volatility model built to exploit highfrequency data.
}
\details{
Assume there are \eqn{T} daily returns and realized measures in the period \eqn{t}. Let \eqn{r_i} and \eqn{RM_i} be the \eqn{i^{th}} daily return and daily realized measure respectively (with \eqn{i=1, \ldots,T}).

The most basic heavy model is the one with lag matrices p of \eqn{\left( \begin{array}{ccc} 0 & 1 \\ 0 & 1 \end{array} \right)} and q of \eqn{\left( \begin{array}{ccc} 1 & 0 \\ 0 & 1 \end{array} \right)}. This can be reprensented by the following equations:
\deqn{
     \mbox{var}{\left(r_t \right)} = h_t = w + \alpha RM_{t-1} + \beta h_{t-1}; w,\alpha \geq 0, \beta \in [0,1]
}
\deqn{
 \mbox{E}{\left(RM_t \right)} = \mu_t = w_R + \alpha_R RM_{t-1} + \beta_R \mu_{t-1}; w_R,\alpha_R, \beta_R \geq 0, \alpha_R+\beta_R \in [0,1]
}

Equivalently, they can be presented in terms of matrix notation as below:
\deqn{
\left( \begin{array}{ccc} h_t \\ \mu_t \end{array} \right) = \left( \begin{array}{ccc} w \\ w_R \end{array} \right)  + \left( \begin{array}{ccc} 0 & \alpha \\ 0 & \alpha_R \end{array} \right) \left( \begin{array}{ccc} r^2_{t-1} \\ RM_{t-1} \end{array} \right) + \left( \begin{array}{ccc} \beta & 0 \\ 0 & \beta_R \end{array} \right) \left( \begin{array}{ccc} h_{t-1} \\ \mu_{t-1} \end{array} \right)
}

In this version, the parameters vector to be estimated is \eqn{\left( w, w_R,\alpha, \alpha_R, \beta, \beta_R \right) }.

In terms of startingvalues, Shephard and Sheppard recommend for this version of the Heavy model to set  \eqn{\beta} be around 0.6 and sum of \eqn{\alpha}+\eqn{\beta} to be close to but slightly less than one.
In general, the lag length for the model innovation and the conditional covariance can be greater than 1. Consider, for example, matrix p is  \eqn{\left( \begin{array}{ccc} 0 & 2 \\ 0 & 1 \end{array} \right)} and matrix q is the same as above. Matrix notation will be as below:
\deqn{
\left( \begin{array}{ccc} h_t \\ \mu_t \end{array} \right) = \left( \begin{array}{ccc} w \\ w_R \end{array} \right)  + \left( \begin{array}{ccc} 0 & \alpha_1 \\ 0 & \alpha_R \end{array} \right) \left( \begin{array}{ccc} r^2_{t-1} \\ RM_{t-1} \end{array} \right) +\left( \begin{array}{ccc} 0 & \alpha_2 \\ 0 & 0 \end{array} \right) \left( \begin{array}{ccc} r^2_{t-2} \\ RM_{t-2} \end{array} \right) + \left( \begin{array}{ccc} \beta & 0 \\ 0 & \beta_R \end{array} \right) \left( \begin{array}{ccc} h_{t-1} \\ \mu_{t-1} \end{array} \right)}

In this version, the parameters vector to be estimated is \eqn{\left( w, w_R,\alpha_1, \alpha_R, \alpha_2, \beta, \beta_R \right) }.
}
\examples{
# Implementation of the heavy model on DJI:
returns <-  realized_library$open_to_close
bv      <-  realized_library$bv
returns <- returns[!is.na(bv)]
bv <- bv[!is.na(bv)] # Remove NA's
data <- cbind( returns^2, bv) # Make data matrix with returns and realized measures
backcast <- matrix(c(var(returns), mean(bv)), ncol = 1)

#For traditional (default) version:
startvalues <- c(0.004,0.02,0.44,0.41,0.74,0.56) # Initial values
output <- heavyModel(data = as.matrix(data,ncol=2), compconst=FALSE,
                     startingvalues = startvalues, backcast=backcast)
#For general version:
startvalues <- c(0.004, 0.02, 0.44, 0.4, 0.41, 0.74, 0.56) # Initial values;
p <- matrix(c(2, 0, 0, 1), ncol = 2)
q <- matrix(c(1, 0, 0, 1), ncol = 2)

heavy_model <- heavyModel(data = as.matrix(data, ncol = 2), p = p, q = q, compconst = FALSE,
                      startingvalues = startvalues, backcast = backcast)

}
\references{
Shephard, N. and K. Sheppard (2010). Realising the future: forecasting with high frequency based volatility (heavy) models. Journal of Applied Econometrics 25, 197-231.
}
\author{
Giang Nguyen, Jonathan Cornelissen, Kris Boudt and Onno Kleen.
}
