% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharts-api-add.R
\name{hc_add_series_list}
\alias{hc_add_series_list}
\title{Shortcut for data series from a list of data series}
\usage{
hc_add_series_list(hc, x)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{x}{A \code{list} or a \code{data.frame} of series.}
}
\description{
Shortcut for data series from a list of data series
}
\examples{

ds <- lapply(seq(5), function(x) {
  list(data = cumsum(rnorm(100, 2, 5)), name = x)
})

highchart() \%>\%
  hc_plotOptions(series = list(marker = list(enabled = FALSE))) \%>\%
  hc_add_series_list(ds)
}
