% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-tufte.R
\name{hc_theme_tufte}
\alias{hc_theme_tufte}
\alias{hc_theme_tufte2}
\title{Tufte theme for highcharts}
\usage{
hc_theme_tufte(...)

hc_theme_tufte2(...)
}
\arguments{
\item{...}{Named argument to modify the theme}
}
\description{
Design inspired by Edward Tufte style.
}
\examples{

n <- 15
dta <- dplyr::data_frame(
  x = rnorm(n),
  y = 1.5 * x + rnorm(n))
highchart() \%>\%
  hc_chart(type = "scatter") \%>\% 
  hc_add_series(data = list_parse(dta)) \%>\% 
  hc_add_theme(hc_theme_tufte())
  

values <- 1 + abs(rnorm(12))
highchart() \%>\%
  hc_chart(type = "columnn") \%>\%
  hc_add_series(data = values) \%>\%
  hc_xAxis(categories = month.abb) \%>\%
  hc_add_theme(hc_theme_tufte2())

}
