% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-hc.R
\name{hc_tooltip}
\alias{hc_tooltip}
\title{Adding tooltip options to highchart objects}
\usage{
hc_tooltip(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments are defined in \url{http://api.highcharts.com/highcharts#tooltip}.}
}
\description{
Options for the tooltip that appears when the user hovers over a series or point.
}
\examples{


data(citytemp)

highchart() \%>\% 
  hc_xAxis(categories = citytemp$month) \%>\% 
  hc_add_series(name = "Tokyo", data = citytemp$tokyo) \%>\% 
  hc_add_series(name = "London", data = citytemp$london) \%>\% 
  hc_tooltip(crosshairs = TRUE, backgroundColor = "gray",
             headerFormat = "This is a custom header<br>",
             shared = TRUE, borderWidth = 5)
             
}

