% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.hierBase}
\alias{print.hierBase}
\title{Print Object of Class \code{hierBase}}
\usage{
\method{print}{hierBase}(
  x,
  n.terms = 5L,
  digits = max(3, getOption("digits") - 3),
  right = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{hierBase}}

\item{n.terms}{maximum number of column names or variables names to be
printed per cluster or group of variables.}

\item{digits}{number of significant digits to be used.}

\item{right}{logical value indicating whether the values should or should
not be right-aligned.}

\item{...}{additional arguments to \code{\link{print.data.frame}}}
}
\value{
The returned values is a invisible copy of the object \code{x}.
}
\description{
Print significant clusters or groups of variables of an object of class
\code{hierBase}.
}
\details{
The function prints the significant clusters or groups of variables
of an object of class \code{hierBase}. By default, it prints at most the first
\code{n.terms} column or variable names per significant cluster and the
number of omitted column names are printed in square brackets (if any).
}
\examples{
n <- 200
p <- 100
library(MASS)
set.seed(3)
x <- mvrnorm(n, mu = rep(0, p), Sigma = diag(p))
colnames(x) <- paste0("Var", 1:p)
beta <- rep(0, p)
beta[c(5, 20, 46)] <- 1
y <- x \%*\% beta + rnorm(n)

dendr <- cluster_vars(x = x)
sign.clusters <- advance_hierarchy(x = x, y = y, dendr = dendr,
                                   test = "F")

# The argument n.terms is useful if there is one or multiple
# significant groups containing many variables.
print(sign.clusters, n.terms = 4)

print(sign.clusters, right = TRUE)

print(sign.clusters, digits = 6)

}
\seealso{
\code{\link{invisible}}.
}
