% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading-animations.R
\name{progressbar}
\alias{progressbar}
\alias{render}
\alias{render.fraction_progressbar}
\alias{render.iteration_progressbar}
\alias{render.progressbar}
\title{Creates an animated progress bar}
\usage{
progressbar(format = "[[|][|/-\\\\][ ]]", width = 20, refresh = 200,
  n_iterations = NULL)

render(object, ...)

\method{render}{fraction_progressbar}(object, progress,
  show_progress = c("nothing", "percentage"), ...)

\method{render}{iteration_progressbar}(object, progress,
  show_progress = c("nothing", "percentage", "iteration"), ...)

\method{render}{progressbar}(object, show_progress = c("nothing",
  "percentage", "iteration"), ...)
}
\arguments{
\item{format}{character vector containing the format of the animation. See 'details' for more information.}

\item{width}{progress bar width.}

\item{refresh}{refresh rate in milliseconds of the animation.}

\item{n_iterations}{optional parameter, specifies the number of total iterations. When updating the progress bar it
is then sufficient to specify the current iteration number.}

\item{object}{animated progress bar.}

\item{...}{further arguments passed to or from other methods.}

\item{progress}{either the iteration number (if n_iterations is set), or the progress fraction (in [0,1]).}

\item{show_progress}{how to show the progress. Either not to show it (default),
show a percentage or if \code{n_iterations} is set to show the number of iterations.}
}
\description{
Creates an animated progress bar
}
\details{
The format of the progress bar is given by a character vector. It consists of 5 parts:
\enumerate{
  \item the left border of the progress bar consisting of 0 or more characters.
  \item a pair of square brackets containing a single character which represents the loaded area.
  \item a pair of square brackets containing 0 or more characters. These are animated on the border between the loaded and unloaded area.
  \item a pair of square brackets containing a single character which represents the unloaded area.
  \item the right border of the progress bar consisting of 0 or more characters.
}
The format follows the following regular expression: \code{^.*?[.?][.*?][.?].*$}
}
\examples{
\dontrun{
# simple progressbar
bar = progressbar(format = "[[|][|/-\\\\][ ]]")
# fancy progressbar using UTF-8 codes
n_operations = 1000
bar2 = progressbar(format="\\u25ba[\\u2589][\\u2580\\u2584][\\u3000]\\u25c4", n_iterations=n_operations)

for(i in 1:n_operations) {
  cat("\\r", render(bar),sep="")
  Sys.sleep(0.01)
}}
}
