% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/description-utils.R
\name{add_badges}
\alias{add_badges}
\title{Add badges to the README file for use on Github}
\usage{
add_badges(
  github_pkg,
  states = c("active", "abandoned", "concept", "inactive", "moved", "suspended",
    "unsupported", "wip"),
  readme_file = "README.md",
  show_repo_status = TRUE,
  show_cran_version = TRUE,
  show_package_version = TRUE,
  show_min_r = TRUE,
  show_last_update = TRUE,
  show_travis = TRUE,
  show_code_coverage = TRUE
)
}
\arguments{
\item{github_pkg}{The Github repository}

\item{states}{Current software cycle state}

\item{readme_file}{The filename of the readme file}

\item{show_repo_status}{Whether to show the repository status as a badge}

\item{show_cran_version}{Whether to show the CRAN version as a badge}

\item{show_package_version}{Whether to show the package version as a badge}

\item{show_min_r}{Whether to show the minimal R version as a badge}

\item{show_last_update}{Whether to show the last update date as a badge}

\item{show_travis}{Whether to show the Travis test results as a badge (see \url{https://www.travis-ci.com})}

\item{show_code_coverage}{Whether to show the code coverage as a badge (see \url{https://about.codecov.io/})}
}
\description{
Add badges to the README file for use on Github
}
\examples{
\dontrun{
add_badges("hvdboorn/hgutils")
}
}
