% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize_ce}
\alias{summarize_ce}
\title{Summarize costs and effectiveness}
\usage{
summarize_ce(costs, qalys, by_grp = FALSE)
}
\arguments{
\item{costs}{Simulated costs by category (objects of class \code{\link{costs}}).}

\item{qalys}{Simulated QALYs (objects of class \code{\link{qalys}}).}

\item{by_grp}{If \code{TRUE}, then costs and QALYs are computed by subgroup. If
\code{FALSE}, then costs and QALYs are aggregated across all patients (and subgroups).}
}
\value{
An object of class \code{\link{ce}}.
}
\description{
Summarize costs and quality-adjusted life-years (QALYs) given output simulated
from an economic model. The summary output is used to perform
cost-effectiveness analysis with \code{\link[=cea]{cea()}} and \code{\link[=cea_pw]{cea_pw()}}.
}
\details{
If mean costs and/or QALYs have already been computed
(i.e., an average within a population), then there
must be one observation for each discount rate (\code{dr}),
PSA sample (\code{sample}), treatment strategy (\code{strategy_id}),
and health state (\code{state_id}). Alternatively, there can be a column
denoting a patient (\code{patient_id}), in which case outcomes will first be
averaged across patients. A \code{grp_id} column can also be used so that
outcomes are computed for each subgroup (if \code{by_grp = TRUE}); otherwise it is assumed that
there is only one subgroup.
}
