% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctstm.R
\name{IndivCtstmTrans}
\alias{IndivCtstmTrans}
\title{Transitions for an individual-level continuous time state transition model}
\format{
An \link[R6:R6Class]{R6::R6Class} object.
}
\description{
Simulate health state transitions in an individual-level continuous time state
transition model with parameters that were estimated using a multi-state model.
}
\examples{
library("flexsurv")

# Simulation data
strategies <- data.frame(strategy_id = c(1, 2, 3))
patients <- data.frame(patient_id = seq(1, 3),
                       age = c(45, 50, 60),
                       female = c(0, 0, 1))

# Multi-state model with transition specific models
tmat <- rbind(c(NA, 1, 2),
              c(NA, NA, 3),
              c(NA, NA, NA))
fits <- vector(length = max(tmat, na.rm = TRUE), mode = "list")
for (i in 1:length(fits)){
  fits[[i]] <- flexsurvreg(Surv(years, status) ~ 1, 
                           data = bosms3[bosms3$trans == i, ],
                           dist = "exp")
}
fits <- flexsurvreg_list(fits)

# Simulation model
hesim_dat <- hesim_data(strategies = strategies,
                        patients = patients)
fits_data <- expand(hesim_dat)
transmod <- create_IndivCtstmTrans(fits, input_data = fits_data, 
                                   trans_mat = tmat,
                                   n = 2,
                                   point_estimate = FALSE)       
head(transmod$hazard(c(1, 2, 3)))
head(transmod$cumhazard(c(1, 2, 3)))
transmod$sim_stateprobs(t = c(0, 5, 10))[t == 5]
}
\seealso{
\code{\link[=create_IndivCtstmTrans]{create_IndivCtstmTrans()}}, \link{IndivCtstm}
}
\section{Super class}{
\code{\link[hesim:CtstmTrans]{hesim::CtstmTrans}} -> \code{IndivCtstmTrans}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{params}}{An object of class \link{params_surv} or \link{params_surv_list}.}

\item{\code{input_data}}{Input data used to simulate health state transitions
by sample from the probabilistic sensitivity analysis (PSA), treatment strategy and patient.
Must be an object of class \link{input_mats}. If \code{params} contains parameters from
a list of models (i.e., of class \link{params_surv_list}), then \code{input_data}
must contain a unique row for each treatment strategy
and patient; if \code{params} contains parameters from a joint model
(i.e., of class \link{params_surv}), then \code{input_data} must contain a unique
row for each treatment strategy, patient, and transition.}

\item{\code{trans_mat}}{A transition matrix describing the states and transitions
in a multi-state model in the format from the \link[mstate:mstate]{mstate} package.
See the documentation for the argument \code{"trans"} in \link[mstate:msprep]{mstate::msprep}.}

\item{\code{start_state}}{A scalar or vector denoting the starting health state.
Default is the first health state. If a vector, must be equal to the number of simulated patients.}

\item{\code{start_age}}{A scalar or vector denoting the starting age of each patient
in the simulation. Default is 38. If a vector, must be equal to the number of simulated patients.}

\item{\code{death_state}}{The death state in \code{trans_mat}. Used with \code{max_age}
in \code{sim_disease} as patients transition to this state upon reaching maximum age.
By default, it is set to the final absorbing state (i.e., a row in \code{trans_mat} with all NAs).}

\item{\code{clock}}{"reset" for a clock-reset model, "forward" for a clock-forward model,
and "mix" for a mixture of clock-reset and clock-forward models. A clock-reset model
is a semi-Markov model in which transition rates depend on time since entering a state.
A clock-forward model is a Markov model in which transition rates depend on time
since entering the initial state. If \code{"mix"} is used, then
\code{reset_states} must be specified.}

\item{\code{reset_states}}{A vector denoting the states in which time resets.
Hazard functions are always a function of elapsed time since either the
start of the model or from when time was previously reset. Only used if
\code{clock = "mix"}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{IndivCtstmTrans$new()}}
\item \href{#method-sim_stateprobs}{\code{IndivCtstmTrans$sim_stateprobs()}}
\item \href{#method-check}{\code{IndivCtstmTrans$check()}}
\item \href{#method-clone}{\code{IndivCtstmTrans$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="hesim" data-topic="CtstmTrans" data-id="cumhazard">}\href{../../hesim/html/CtstmTrans.html#method-cumhazard}{\code{hesim::CtstmTrans$cumhazard()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="hesim" data-topic="CtstmTrans" data-id="hazard">}\href{../../hesim/html/CtstmTrans.html#method-hazard}{\code{hesim::CtstmTrans$hazard()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{IndivCtstmTrans} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IndivCtstmTrans$new(
  params,
  input_data,
  trans_mat,
  start_state = 1,
  start_age = 38,
  death_state = NULL,
  clock = c("reset", "forward", "mix"),
  reset_states = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{The \code{params} field.}

\item{\code{input_data}}{The \code{input_data} field.}

\item{\code{trans_mat}}{The \code{trans_mat} field.}

\item{\code{start_state}}{The \code{start_state} field.}

\item{\code{start_age}}{The \code{start_age} field.}

\item{\code{death_state}}{The \code{death_state} field.}

\item{\code{clock}}{The \code{clock} field.}

\item{\code{reset_states}}{The \code{reset_states} field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{IndivCtstmTrans} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sim_stateprobs"></a>}}
\if{latex}{\out{\hypertarget{method-sim_stateprobs}{}}}
\subsection{Method \code{sim_stateprobs()}}{
Simulate health state probabilities at distinct times by first
simulating trajectories through a multi-state model with
\code{IndivCtstm$sim_disease()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IndivCtstmTrans$sim_stateprobs(t, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{A numeric vector of times.}

\item{\code{...}}{Additional arguments to pass to \code{IndivCtstm$sim_disease()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{stateprobs}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check"></a>}}
\if{latex}{\out{\hypertarget{method-check}{}}}
\subsection{Method \code{check()}}{
Input validation for class. Checks that fields are the correct type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IndivCtstmTrans$check()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{IndivCtstmTrans$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
