% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator_bivar.R
\name{spearmans.hermite_estimator_bivar}
\alias{spearmans.hermite_estimator_bivar}
\title{Estimates the Spearman's rank correlation coefficient}
\usage{
\method{spearmans}{hermite_estimator_bivar}(h_est_obj, clipped = FALSE)
}
\arguments{
\item{h_est_obj}{A hermite_estimator_bivar object.}

\item{clipped}{A boolean value. Indicates whether to clip Spearman's rank 
correlation estimates to lie between -1 and 1.}
}
\value{
A numeric value.
}
\description{
This method calculates the Spearman's rank correlation coefficient value
using the hermite_estimator_bivar object (h_est_obj).
}
\details{
The method utilizes the estimator defined in the paper Stephanou, Michael 
and Varughese, Melvin. "Sequential Estimation of Nonparametric Correlation 
using Hermite Series Estimators." arXiv Preprint (2020), 
https://arxiv.org/abs/2012.06287

The object must be updated with observations prior to the use of this method.
}
