\name{mcmc.diagnostics}

\alias{mcmc.diagnostics}

\alias{hergm.mcmc.diagnostics}

\alias{mcmc.diagnostics.hergm}

\title{MCMC diagnostics}

\description{

The function \code{mcmc.diagnostics} helps assess the convergence of the Markov chain generated by function \code{hergm}.

}

\usage{

\method{mcmc.diagnostics}{hergm}(sample = NULL,
          \dots)

}

\arguments{

\item{sample}{MCMC sample generated by function \code{hergm}.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\value{

\item{alpha}{MCMC diagnostics for the concentration parameter of truncated Dirichlet process prior of parameters of \code{hergm-terms}.}

\item{eta_mean}{MCMC diagnostics for the mean parameters of Gaussian base distribution of parameters of \code{hergm-terms}.}

\item{eta_precision}{MCMC diagnostics for the precision parameters of Gaussian base distribution of parameters of \code{hergm-terms}.}

\item{hergm_theta}{MCMC diagnostics for the parameters of \code{hergm-terms}.}

}

\seealso{hergm}

\examples{
\dontrun{
data(example)

sample <- hergm(d ~ edges_ij + triangle_ijk)

mcmc.diagnostics.hergm(sample)
}
}

