
\name{hergm.gof}

\alias{hergm.gof}

\alias{gof}

\title{Goodness-of-fit}

\description{

The function \code{hergm.gof} assesses the goodness-of-fit of the model by generating posterior predictions based on a MCMC sample generated by function \code{hergm} and postprocessed by function \code{hergm.postprocess}.

}

\usage{

hergm.gof(sample = NULL,
          verbose = 1,
          \dots)

}

\arguments{

\item{sample}{MCMC sample generated by function \code{hergm} and postprocessed by function \code{hergm.postprocess}.}

\item{verbose}{if \code{verbose == -1}, no console output; if \code{verbose == 0}, short console output; if \code{verbose == +1}, long console output.}

\item{\dots}{additional arguments, to be passed to lower-level functions in the future.}

}

\value{

Functions of the network.

}

\seealso{network, hergm, hergm.postprocess}

\examples{
\dontrun{
data(example)

sample <- hergm(d ~ edges_ij + triangle_ijk)

processed.sample <- hergm.postprocess(sample)

hergm.gof(processed.sample)
}
}

