#' Table of geographic location names, and associated coordinates
#'
#' A cached copy of the output of \code{\link{listLocations}}.
#'
#' @format
#'  \describe{
#'    \item{Location}{Name of geographic location}
#'    \item{Latitude}{Latitude of location centroid}
#'    \item{Longitude}{Longitude of location centroid}
#'  }
#'
#' @references Gibson, D. I., Bray, R. A., & Harris, E. A. (Compilers) (2005).
#' Host-Parasite Database of the Natural History Museum, London.
#' @name locations
#' @docType data
#' @keywords data
#' @usage data(locations)

if(getRversion() >= "2.15.1"){
  utils::globalVariables('locations')
}

