% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_diet.R
\name{get_diet}
\alias{get_diet}
\title{NHANES dietary data retrieval.}
\usage{
get_diet(year, day)
}
\arguments{
\item{year}{year combination of data set to retrieve ... must be one of the following:
\itemize{
\item "2005/2006"
\item "2007/2008"
\item "2009/2010"
\item "2011/2012"
\item "2013/2014"
}}

\item{day}{identifier for survey day to retrieve ... must be one of the following:
\itemize{
\item "first" (data for study participants from first day)
\item "second" (study participant data from second day)
\item "both" (data for study participants present in both days, with values averaged across the two days)
}}
}
\value{
Object of class \code{data.frame} containing a modified NHANES dietary data set for a specified year and day. The complete NHANES dietary data set contains several more variables than are necessary for computing HEI scores. The data set returned by this function has been trimmed down to contain (in addition to an NHANES unique sequence identifier for each participant) only the columns of data needed for HEI score calculation, specifically:
\itemize{
\item TKCAL: Energy (kcal)
\item TSFAT: Total saturated fatty acids (gm)
\item TMFAT: Total monounsaturated fatty acids (gm)
\item TPFAT: Total polyunsaturated fatty acids (gm)
\item TSODI: Sodium (mg)
\item TALCO: Alcohol (gm)
}
}
\description{
\code{get_diet} returns an abridged National Health and Nutrition Examination Survey (NHANES) dietary data set for a given year.
}
\examples{
\dontrun{
get_diet("2009/2010", "both")
get_diet("2009/2010", "first")
}
}
\references{
\url{https://www.cdc.gov/nchs/nhanes/nhanes_questionnaires.htm}
}
