% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hedgedrf.R
\name{hedgedrf}
\alias{hedgedrf}
\title{hedgedrf}
\usage{
hedgedrf(
  formula = NULL,
  data = NULL,
  x = NULL,
  y = NULL,
  num_iter = NULL,
  kappa = 2,
  ...
)
}
\arguments{
\item{formula}{Object of class \code{formula} or \code{character}
describing the model to fit. Interaction terms supported only for
numerical variables.}

\item{data}{Training data of class \code{data.frame}, \code{matrix},
\code{dgCMatrix} (Matrix) or \code{gwaa.data} (GenABEL).}

\item{x}{Predictor data (independent variables), alternative interface
to data with formula or dependent.variable.name.}

\item{y}{Response vector (dependent variable), alternative interface to
data with formula or dependent.variable.name. For survival use a Surv()
object or a matrix with time and status.}

\item{num_iter}{Number of iterations for the optimization algorithm.}

\item{kappa}{Amount of regularization to apply to the tree weights. 1 implies
no shorting, 2 implies no more than 50\% shorting, etc.}

\item{...}{Additional arguments to pass to the \code{ranger} function.}
}
\value{
An object of class \code{hedgedrf} containing the tree weights and
a ranger object. The tree weights can be used to construct a hedged random
forest with the \code{predict.hedgedrf} function. For more details about the
ranger object, see the ranger documentation.
}
\description{
hedgedrf
}
\examples{
rf <- hedgedrf(mpg ~ ., mtcars[1:26, ])
pred <- predict(rf, mtcars[27:32, ])
pred

}
