% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_draft.R
\name{import_draft}
\alias{import_draft}
\title{Import multiple patterns into a single draft object}
\usage{
import_draft(...)
}
\arguments{
\item{...}{A named vector of filenames which will be imported as
patterns stored in the returned draft, with the names used as indices.
Files should be plain text.}
}
\value{
Returns a list (the same length as ...)
containing the imported patterns.
}
\description{
When working with multiple patterns that will be woven into a template,
it makes sense to have all patterns stored in a central object. This
function creates that object from a named vector of filenames to be used
in further generation, importing the files via
\code{\link[heddlr]{import_pattern}}.
}
\examples{
pattern_file <- tempfile("out", tempdir(), ".Rmd")
export_template("my sample pattern", pattern_file)
import_draft("sample_pattern" = pattern_file)
}
\seealso{
Other import functions: 
\code{\link{extract_draft}()},
\code{\link{extract_pattern}()},
\code{\link{import_pattern}()}
}
\concept{import functions}
