% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_functions.R
\name{event_line}
\alias{event_line}
\title{Create a line plot of heatwaves or cold-spells.}
\usage{
event_line(data, x = t, y = temp, min_duration = 5, spread = 150,
  metric = "intensity_cumulative", start_date = NULL,
  end_date = NULL, category = FALSE)
}
\arguments{
\item{data}{The function receives the full (list) output from the
\code{\link{detect_event}} function.}

\item{x}{This column is expected to contain a vector of dates as per the
specification of \code{make_whole}. If a column headed \code{t} is present in
the dataframe, this argument may be ommitted; otherwise, specify the name of
the column with dates here.}

\item{y}{This is a column containing the measurement variable. If the column
name differs from the default (i.e. \code{temp}), specify the name here.}

\item{min_duration}{The minimum duration (days) the event must be for it to
qualify as a heatwave or cold-spell.}

\item{spread}{The number of days leading and trailing the largest event
(as per \code{metric}) detected within the time period specified by
\code{start_date} and \code{end_date}. The default is 150 days.}

\item{metric}{This tells the function how to choose the event that should be
highlighted as the 'greatest' of the events in the chosen period. One may
choose from the following options: \code{intensity_mean}, \code{intensity_max},
\code{intensity_var},\code{intensity_cumulative}, \code{intensity_mean_relThresh},
\code{intensity_max_relThresh}, \code{intensity_var_relThresh},
\code{intensity_cumulative_relThresh}, \code{intensity_mean_abs},
\code{intensity_max_abs}, \code{intensity_var_abs}, \code{intensity_cumulative_abs},
\code{rate_onset}, \code{rate_decline}. Partial name matching is currently not
supported so please specify the metric name precisely. The default is
\code{intensity_cumulative}.}

\item{start_date}{The start date of a period of time within which the largest
event (as per \code{metric}) is retrieved and plotted. This may not necessarily
correspond to the biggest event of the specified metric within the entire
time series. To plot the largest event within the whole time series, make sure
\code{start_date} and \code{end_date} straddle this event, or simply leave them both
as NULL (default) and \code{event_line} will use the entire time series date range.}

\item{end_date}{The end date of a period of time within which the largest
event (as per \code{metric}) is retrieved and plotted. See \code{start_date}
for additional information.}

\item{category}{A boolean choice of TRUE or FALSE. If set to FALSE (default) event_line() will
produce a figure as per the second row of Figure 3 in Hobday et al. (2016). If set to TRUE a
figure showing the different categories of the MHWs in the chosen period, highlighted as
seen in Figure 3 of Hobday et al. (in review), will be produced. If \code{category} = TRUE,
\code{metric} will be ignored as a different colouring scheme is used.}
}
\value{
The function will return a line plot indicating the climatology,
threshold and temperature, with the hot or cold events that meet the
specifications of Hobday et al. (2016) shaded in as appropriate. The plotting
of hot or cold events depends on which option is specified in \code{\link{detect_event}}.
The top event detect during the selected time period will be visible in a
brighter colour. This function differs in use from \code{\link{geom_flame}}
in that it creates a stand alone figure. The benefit of this being
that one must not have any prior knowledge of ggplot2 to create the figure.
}
\description{
Creates a graph of warm or cold events as per the second row of Figure 3 in
Hobday et al. (2016).
}
\examples{
ts <- ts2clm(sst_WA, climatologyPeriod = c("1983-01-01", "2012-12-31"))
res <- detect_event(ts)

event_line(res, spread = 100, metric = "intensity_cumulative",
start_date = "2010-12-01", end_date = "2011-06-30")

event_line(res, spread = 100, start_date = "2010-12-01",
end_date = "2011-06-30", category = TRUE)

}
\references{
Hobday, A.J. et al. (2016), A hierarchical approach to defining
marine heatwaves, Progress in Oceanography, 141, pp. 227-238,
doi: 10.1016/j.pocean.2015.12.014
}
\author{
Robert W. Schlegel
}
