% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/category.R
\name{category}
\alias{category}
\title{Calculate the categories of events.}
\usage{
category(data, y = temp, S = TRUE, name = "Event")
}
\arguments{
\item{data}{The function receives the full (list) output from the
\code{\link{detect_event}} function.}

\item{y}{This is a column containing the measurement variable. If the column
name differs from the default (i.e. \code{temp}), specify the name here.}

\item{S}{This argument informs the function if the data were collected in the
southern hemisphere (TRUE, default) or the northern hemisphere (FALSE) so that it may correctly
output the \code{season} column (see below).}

\item{name}{If a character string (e.g. "Bohai Sea") is provide here it will be used
to name the events in the \code{event_name} column (see below) of the output.
If no value is provided the default output is "Event".}
}
\value{
The function will return a tibble with results similar to those seen in
Table 2 of Hobday et al. (in review). This provides the information necessary to
appraise the extent of the events in the output of \code{\link{detect_event}} based on the
category ranking scale. The category thresholds are calculated based on the difference
between the seasonal climatology and threshold climatology produced by
\code{\link{detect_event}}. The four category levels are then the difference
multiplied by the category level.

The definitions for the output columns are as follows:
  \item{event_no}{The number of the event as determined by \code{\link{detect_event}}
  for reference between the outputs.}
  \item{event_name}{The name of the event. Generated from the \code{\link{name}}
  value provided and the year of the \code{peak_date} (see following) of
  the event. If no \code{\link{name}} value is provided the default "Event" is used.
  As proposed in Hobday et al. (in review), \code{Moderate} events are not given a name
  so as to prevent multiple repeat names within the same year. If two or more events
  ranked greater than Moderate are reported withiin the same year, they will be
  differentiated with the addition of a trailing letter
  (e.g. Event 2001 a, Event 2001 b). (still in development)}
  \item{peak_date}{The date (day) on which the maximum intensity of the event
  was recorded.}
  \item{category}{The maximum category threshold reached/exceeded by the event.}
  \item{i_max}{The maximum intensity of the event above the threshold value.}
  \item{duration}{The total duration (days) of the event. Note that this includes
  any possible days when the measurement value \code{\link{y}}) may have dropped below the
  threshold value. Therefore, the proportion of the event duration (days) spent above
  certain thresholds may not add up to 100\% (see following four items).}
  \item{p_moderate}{The proportion of the total duration (days) spent above at or
  the first threshold, but below any further thresholds.}
  \item{p_strong}{The proportion of the total duration (days) spent at or above
  the second threshold, but below any further thresholds.}
  \item{p_severe}{The proportion of the total duration (days) spent at or above
  the third threshold, but below the fourth threshold.}
  \item{p_extreme}{The proportion of the total duration (days) spent at or above
  the fourth and final threshold. There is currently no recorded event that has
  exceeded a hypothetical fifth threshold so none is calculated... yet..}
  \item{season}{The season(S) during which the event occurred. If the event
  occurred across two seasons this will be displayed as "Winter/Spring".
  Across three seasons as "Winter-Summer". Events lasting across four or more
  seasons are listed as "Year-round". December (June) is used here as the start of
  Austral (Boreal) summer.}
}
\description{
Calculates the categories of a series of events as produced by \code{\link{detect_event}} in
accordance with the naming scheme proposed in Hobday et al. (in review).
}
\details{
An explanation for the categories is as follows:
\enumerate{
  \item{Moderate}{Events that have been detected, but with a maximum intensity that does not
  double the distance between the seasonal climatology and the threshold value.}
  \item{Strong}{Events with a maximum intensity that doubles the distance from the seasonal
  climatology and the threshold, but do not triple it.}
  \item{Severe}{Events that triple the aforementioned distance, but do not quadruple it.}
  \item{Extreme}{Events with a maximum intensity that is four times or greater the
  aforementioned distance. Scary stuff...}
  }
}
\examples{
res_WA <- detect_event(ts2clm(sst_WA,
                       climatologyPeriod = c("1983-01-01", "2012-12-31")))
# Note that the name argument expects a character vector
cat_WA <- category(res_WA, name = "WA")
tail(cat_WA)

# If the data were collected in the northern hemisphere
# we must let the funciton know this as seen below
res_Med <- detect_event(ts2clm(sst_Med,
                        climatologyPeriod = c("1983-01-01", "2012-12-31")))
cat_Med <- category(res_Med, S = FALSE, name = "Med")
tail(cat_Med)

}
\references{
Hobday et al. (in review). Categorizing and Naming
Marine Heatwaves. Oceanography.
}
\author{
Robert W. Schlegel
}
