% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate-plot-list.R
\name{calibrate_and_plot}
\alias{calibrate_and_plot}
\title{Helper function - Calibrate and Plot}
\usage{
calibrate_and_plot(
  ...,
  .type = "testing",
  .splits_obj,
  .data,
  .print_info = TRUE,
  .interactive = FALSE
)
}
\arguments{
\item{...}{The workflow(s) you want to add to the function.}

\item{.type}{Either the training(splits) or testing(splits) data.}

\item{.splits_obj}{The splits object.}

\item{.data}{The full data set.}

\item{.print_info}{The default is TRUE and will print out the calibration
accuracy tibble and the resulting plotly plot.}

\item{.interactive}{The defaults is FALSE. This controls if a forecast plot
is interactive or not via plotly.}
}
\value{
The original time series, the simulated values and a some plots
}
\description{
This function is a helper function. It will take in a set of workflows and then
perform the \code{\link[modeltime:modeltime_calibrate]{modeltime::modeltime_calibrate()}} and \code{\link[modeltime:plot_modeltime_forecast]{modeltime::plot_modeltime_forecast()}}.
}
\details{
This function expects to take in workflows fitted with training data.
}
\examples{
\dontrun{
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(recipes))
suppressPackageStartupMessages(library(rsample))
suppressPackageStartupMessages(library(parsnip))
suppressPackageStartupMessages(library(workflows))

data <- ts_to_tbl(AirPassengers) \%>\%
  select(-index)

splits <- timetk::time_series_split(
   data
  , date_col
  , assess = 12
  , skip = 3
  , cumulative = TRUE
)

rec_obj <- recipe(value ~ ., data = training(splits))

model_spec <- linear_reg(
   mode = "regression"
   , penalty = 0.1
   , mixture = 0.5
) \%>\%
   set_engine("lm")

wflw <- workflow() \%>\%
   add_recipe(rec_obj) \%>\%
   add_model(model_spec) \%>\%
   fit(training(splits))

output <- calibrate_and_plot(
  wflw
  , .type = "training"
  , .splits_obj = splits
  , .data = data
  , .print_info = FALSE
  , .interactive = FALSE
 )
}

}
\seealso{
Other Utility: 
\code{\link{model_extraction_helper}()},
\code{\link{ts_info_tbl}()},
\code{\link{ts_model_compare}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()},
\code{\link{ts_to_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
