% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-skedactiy-plot.R
\name{ts_scedacity_scatter_plot}
\alias{ts_scedacity_scatter_plot}
\title{Time Series Model Scedacity Plot}
\usage{
ts_scedacity_scatter_plot(
  .calibration_tbl,
  .model_id = NULL,
  .interactive = FALSE
)
}
\arguments{
\item{.calibration_tbl}{A calibrated modeltime table.}

\item{.model_id}{The id of a particular model from a calibration tibble. If
there are multiple models in the tibble and this remains \strong{NULL} then the
plot will be returned using \code{ggplot2::facet_grid(~ .model_id)}}

\item{.interactive}{A boolean with a default value of FALSE. TRUE will produce
an interactive \code{plotly} plot.}
}
\value{
A QQ plot.
}
\description{
This takes in a calibration tibble and will produce a scedacity plot.
}
\details{
This takes in a calibration tibble and will create a scedacity plot. You can also
pass in a \code{model_id} and a boolean for \code{interactive} which will return a
\code{plotly::ggplotly} interactive plot.
}
\examples{
# NOT RUN
\dontrun{
suppressPackageStartupMessages(library(dplyr))
suppressPackageStartupMessages(library(timetk))
suppressPackageStartupMessages(library(modeltime))
suppressPackageStartupMessages(library(rsample))
suppressPackageStartupMessages(library(workflows))
suppressPackageStartupMessages(library(parsnip))
suppressPackageStartupMessages(library(recipes))

data_tbl <- ts_to_tbl(AirPassengers) \%>\%
  select(-index)

splits <- time_series_split(
  data_tbl,
  date_var = date_col,
  assess = "12 months",
  cumulative = TRUE
)

rec_obj <- recipe(value ~ ., training(splits))

model_spec_arima <- arima_reg() \%>\%
  set_engine(engine = "auto_arima")

model_spec_mars <- mars(mode = "regression") \%>\%
  set_engine("earth")

wflw_fit_arima <- workflow() \%>\%
  add_recipe(rec_obj) \%>\%
  add_model(model_spec_arima) \%>\%
  fit(training(splits))

wflw_fit_mars <- workflow() \%>\%
  add_recipe(rec_obj) \%>\%
  add_model(model_spec_mars) \%>\%
  fit(training(splits))

model_tbl <- modeltime_table(wflw_fit_arima, wflw_fit_mars)

calibration_tbl <- model_tbl \%>\%
  modeltime_calibrate(new_data = testing(splits))

ts_scedacity_scatter_plot(calibration_tbl)

}

}
\seealso{
\url{https://en.wikipedia.org/wiki/Homoscedasticity}

Other Plot: 
\code{\link{ts_qq_plot}()}

Other Utility: 
\code{\link{calibrate_and_plot}()},
\code{\link{model_extraction_helper}()},
\code{\link{ts_info_tbl}()},
\code{\link{ts_model_compare}()},
\code{\link{ts_model_rank_tbl}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_to_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Plot}
\concept{Utility}
