% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_data}
\alias{get_data}
\title{Fetch data from the UNDP Human Development Report}
\usage{
get_data(indicator = NULL, country = NULL, year = NULL)
}
\arguments{
\item{indicator}{Numerical or character vector with the indicator id (see details)}

\item{country}{Character vector}

\item{year}{Numerical vector (see details for which years are available)

The function fetches data from the \href{http://hdr.undp.org}{United Nations
Development Programme Human Development Report} API.

A dimension can be left as NULL (the default) to get all data for that
dimension. The package includes a data frame (\code{hdr_indicators}) with the
IDs and human-readable names of the indicators.

If the year parameter is not left as NULL, it must be on of the following:
1980, 1985, 1990, 1995, 2000, 2005, 2010, 2011, 2012, 2013.}
}
\value{
A data frame`F
}
\description{
Fetch data from the UNDP Human Development Report
}
\examples{
# Get the Human Development Index for Germany in 2013
df <- get_data(indicator = 137506, country = "DEU", year = 2013)
head(df)

# Leave a dimension as NULL (default) to get all values for that dimension
# e.g. all countries and all year for a specific indicator:
df <- get_data(103606)
head(df)

# A data frame with id and indicator names
head(hdr_indicators)
}

