% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_hdpGLM_simulate.R
\name{hdpGLM_simParameters}
\alias{hdpGLM_simParameters}
\title{Simulate the parameters that can be used to simulate data sets from the dpGLM or hdpGLM}
\usage{
hdpGLM_simParameters(
  K,
  nCov = 2,
  nCovj = 0,
  J = 1,
  pi = NULL,
  same.K = FALSE,
  seed = NULL,
  context.effect = NULL,
  same.clusters.across.contexts = NULL,
  context.dependent.cluster = NULL
)
}
\arguments{
\item{K}{integer, the number of clusters. If there are multiple contexts, K is the average number of clusters across contexts, and each context gets a number of clusters sampled from a Poisson distribution, except if \code{same.K} is \code{TRUE}.}

\item{nCov}{integer, the number of covariates of the
GLM components}

\item{nCovj}{an integer indicating the number of covariates determining the average parameter of the base measure of the Dirichlet process prior}

\item{J}{an integer representing the number of contexts  @param parameters either NULL or a list with the parameters  to generate the model. If not NULL, it must  contain a sublist name beta, a vector named tau,  and a vector named pi. The sublist beta must be  a list of vectors, each one with size nCov+1  to be the coefficients of the GLM mixtures  components that will generate the data.  For the vector tau, if nCovj=0 (single-context case)  then it must be a 1x1 matrix containing 1.  If ncovj>0, it must be a (nCov+1)x(nCovj+1) matrix.  The vector pi must add up to 1 and have length K.}

\item{pi}{either NULL or a vector with length K that add up to 1. If not NULL, it determines the mixture probabilities}

\item{same.K}{boolean, used when data is sampled from more than one context. If \code{TRUE} all contexts get the same number of clusters. If \code{FALSE}, each context gets a number of clusters sampled from a Poisson distribution with expectation equals to \code{K} (current not implemented)}

\item{seed}{a seed for \code{set.seed}}

\item{context.effect}{either \code{NULL} or a two dimensional integer vector. If it is \code{NULL}, all the coefficients (\code{beta}) of the individual level covariates are functions of context-level features (\code{tau}). If it is not \code{NULL}, the first component of the vector indicates the index of the lower level covariate (\code{X}) whose linear effect \code{beta} depends on context (\code{tau}) (0 is the intercept). The second component indicates the index context-level covariate (\code{W}) whose linear coefficient (\code{tau}) is non-zero.}

\item{same.clusters.across.contexts}{boolean, if \code{TRUE} all the contexts will have the same number of clusters AND each cluster will have the same coefficient \code{beta}.}

\item{context.dependent.cluster}{integer, indicates which cluster will be context-dependent. If \code{zero}, all clusters will be context-dependent}
}
\value{
The function returns a list with the parameters used to generate data sets from the hdpGLM model. This list can be used in the function \code{hdpGLM_simulateData}
}
\description{
This function generates parameters that can be used to simulate data sets from the Hierarchical Dirichlet Process of Generalized Linear Model (hdpGLM) or dpGLM
}
\examples{
pars = hdpGLM_simParameters(nCov=2, K=2, nCovj=3, J=20,
          same.clusters.across.contexts=FALSE, context.dependent.cluster=0) 

}
