% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hdnom.models.R
\name{hdcox.alasso}
\alias{hdcox.alasso}
\title{Adaptive lasso model selection for high-dimensional Cox models}
\usage{
hdcox.alasso(x, y, nfolds = 5L, rule = c("lambda.min", "lambda.1se"),
  seeds = c(1001, 1002))
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response matrix made by \code{\link[survival]{Surv}}.}

\item{nfolds}{Fold numbers of cross-validation.}

\item{rule}{Model selection criterion, \code{"lambda.min"} or
\code{"lambda.1se"}. See \code{\link[glmnet]{cv.glmnet}}
for details.}

\item{seeds}{Two random seeds for cross-validation fold division
in two estimation steps.}
}
\description{
Automatic adaptive lasso model selection for high-dimensional
Cox models, evaluated by penalized partial-likelihood.
}
\examples{
library("glmnet")
library("survival")
library("rms")

# Load imputed SMART data
data("smart")
x = as.matrix(smart[, -c(1, 2)])
time = smart$TEVENT
event = smart$EVENT
y = Surv(time, event)

# Fit Cox model by adaptive lasso penalization
alassofit = hdcox.alasso(x, y, nfolds = 3, rule = "lambda.1se", seeds = c(7, 11))

# Prepare data for hdnom.nomogram
x.df = as.data.frame(x)
dd = datadist(x.df)
options(datadist = "dd")

# Generate hdnom.nomogram objects and plot nomogram
nom = hdnom.nomogram(alassofit$alasso_model, x, time, event, x.df,
                     lambda = alassofit$alasso_best_lambda, pred.at = 365 * 2,
                     funlabel = "2-Year Overall Survival Probability")

plot(nom)
}

