% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{h5ReadDataset}
\alias{h5ReadDataset}
\alias{h5ReadDataset.H5D}
\alias{h5ReadDataset.H5Group}
\alias{h5ReadDataset.H5File}
\alias{h5ReadDataset.character}
\title{Read data from an existing H5 dataset}
\usage{
h5ReadDataset(x, ...)

\method{h5ReadDataset}{H5D}(x, idx_list = NULL, transpose = FALSE, ...)

\method{h5ReadDataset}{H5Group}(x, name, idx_list = NULL, transpose = FALSE, ...)

\method{h5ReadDataset}{H5File}(x, name, idx_list = NULL, transpose = FALSE, ...)

\method{h5ReadDataset}{character}(x, name, transpose = FALSE, idx_list = NULL, ...)
}
\arguments{
\item{x}{An \code{\link[hdf5r]{H5File}}, \code{\link[hdf5r]{H5Group}}, 
\code{\link[hdf5r]{H5D}} or a path name of HDF5 file.}

\item{...}{Arguments passed to \code{H5D$read()}.}

\item{idx_list}{The indices for each dimension of \code{name} to subset given 
as a list. If \code{NULL}, the entire dataset will be read. Passed to 
\code{\link[hdf5r:H5D-class]{H5D}}\code{$read(args)}.}

\item{transpose}{Whether or not to transpose the read matrix. Only works for 
a 2-dimension array-like data.}

\item{name}{Name of the HDF5 link to be read. Must be an H5 dataset.}
}
\value{
An array-like object with the data read.
}
\description{
Low-level helper function to read atomic R data from an existing H5 dataset.
}
\examples{
file <- system.file("extdata", "pbmc_small.h5ad", package = "hdf5r.Extra")

x <- h5ReadDataset(file, name = "X")
x <- h5ReadDataset(file, name = "X", transpose = TRUE)
x <- h5ReadDataset(file, name = "X", idx_list = list(1:10, 1:20))
x <- h5ReadDataset(
  file, 
  name = "X", 
  idx_list = list(1:10, 1:20), 
  transpose = TRUE
)

}
