/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5FAmodule.h" 

#include "H5private.h"   
#include "H5Eprivate.h"  
#include "H5FApkg.h"     
#include "H5MMprivate.h" 

herr_t
H5FA_get_stats(const H5FA_t *fa, H5FA_stat_t *stats)
{
    FUNC_ENTER_NOAPI_NOERR

#ifdef H5FA_DEBUG
    Rfprintf(Rstderr, "%s: Called\n", __func__);
#endif 

    
    assert(fa);
    assert(stats);

    
    H5MM_memcpy(stats, &fa->hdr->stats, sizeof(fa->hdr->stats));

    FUNC_LEAVE_NOAPI(SUCCEED)
} 
