/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#ifndef H5LDprivate_H
#define H5LDprivate_H

#include "H5HLprivate2.h"
#include "H5LDpublic.h"

typedef struct H5LD_memb_t {
    size_t tot_offset;
    size_t last_tsize;
    hid_t  last_tid;
    char **names;
} H5LD_memb_t;

#ifdef __cplusplus
extern "C" {
#endif

H5HL_DLL void H5LD_clean_vector(H5LD_memb_t *listv[]);
H5HL_DLL int  H5LD_construct_vector(char *fields, H5LD_memb_t *listv[], hid_t par_tid);

#ifdef __cplusplus
}
#endif

#endif 
