/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5ACprivate_H
#define H5ACprivate_H
#include "H5ACpublic.h"
#include "H5private.h"
#include "H5Cprivate.h"
#include "H5Fprivate.h"
#include "H5Pprivate.h"
#include "H5SLprivate.h"
#define H5AC__INVALID_TAG    (haddr_t)0
#define H5AC__IGNORE_TAG     (haddr_t)1
#define H5AC__COPIED_TAG     (haddr_t)2
#define H5AC__SUPERBLOCK_TAG (haddr_t)3
#define H5AC__FREESPACE_TAG  (haddr_t)4
#define H5AC__SOHM_TAG       (haddr_t)5
#define H5AC__GLOBALHEAP_TAG (haddr_t)6
typedef enum {
    H5AC_BT_ID = 0,
    H5AC_SNODE_ID,
    H5AC_LHEAP_PRFX_ID,
    H5AC_LHEAP_DBLK_ID,
    H5AC_GHEAP_ID,
    H5AC_OHDR_ID,
    H5AC_OHDR_CHK_ID,
    H5AC_BT2_HDR_ID,
    H5AC_BT2_INT_ID,
    H5AC_BT2_LEAF_ID,
    H5AC_FHEAP_HDR_ID,
    H5AC_FHEAP_DBLOCK_ID,
    H5AC_FHEAP_IBLOCK_ID,
    H5AC_FSPACE_HDR_ID,
    H5AC_FSPACE_SINFO_ID,
    H5AC_SOHM_TABLE_ID,
    H5AC_SOHM_LIST_ID,
    H5AC_EARRAY_HDR_ID,
    H5AC_EARRAY_IBLOCK_ID,
    H5AC_EARRAY_SBLOCK_ID,
    H5AC_EARRAY_DBLOCK_ID,
    H5AC_EARRAY_DBLK_PAGE_ID,
    H5AC_FARRAY_HDR_ID,
    H5AC_FARRAY_DBLOCK_ID,
    H5AC_FARRAY_DBLK_PAGE_ID,
    H5AC_SUPERBLOCK_ID,
    H5AC_DRVRINFO_ID,
    H5AC_EPOCH_MARKER_ID,
    H5AC_PROXY_ENTRY_ID,
    H5AC_PREFETCHED_ENTRY_ID,
    H5AC_NTYPES
} H5AC_type_t;
#if H5C_COLLECT_CACHE_STATS
#define H5AC_DUMP_STATS_ON_CLOSE       0
#define H5AC_DUMP_IMAGE_STATS_ON_CLOSE 0
#else
#define H5AC_DUMP_STATS_ON_CLOSE       0
#define H5AC_DUMP_IMAGE_STATS_ON_CLOSE 0
#endif
#define H5AC__DEFAULT_MAX_CACHE_SIZE H5C__DEFAULT_MAX_CACHE_SIZE
#define H5AC__DEFAULT_MIN_CLEAN_SIZE H5C__DEFAULT_MIN_CLEAN_SIZE
#ifdef H5C_DO_TAGGING_SANITY_CHECKS
#define H5AC_DO_TAGGING_SANITY_CHECKS 1
#else
#define H5AC_DO_TAGGING_SANITY_CHECKS 0
#endif
#define H5AC__SERIALIZE_RESIZED_FLAG H5C__SERIALIZE_RESIZED_FLAG
#define H5AC__SERIALIZE_MOVED_FLAG   H5C__SERIALIZE_MOVED_FLAG
#define H5AC__SET_CORK   H5C__SET_CORK
#define H5AC__UNCORK     H5C__UNCORK
#define H5AC__GET_CORKED H5C__GET_CORKED
typedef H5C_ring_t H5AC_ring_t;
#define H5AC_RING_INV    H5C_RING_UNDEFINED
#define H5AC_RING_USER   H5C_RING_USER
#define H5AC_RING_RDFSM  H5C_RING_RDFSM
#define H5AC_RING_MDFSM  H5C_RING_MDFSM
#define H5AC_RING_SBE    H5C_RING_SBE
#define H5AC_RING_SB     H5C_RING_SB
#define H5AC_RING_NTYPES H5C_RING_NTYPES
typedef H5C_notify_action_t H5AC_notify_action_t;
#define H5AC_NOTIFY_ACTION_AFTER_INSERT       H5C_NOTIFY_ACTION_AFTER_INSERT
#define H5AC_NOTIFY_ACTION_AFTER_LOAD         H5C_NOTIFY_ACTION_AFTER_LOAD
#define H5AC_NOTIFY_ACTION_AFTER_FLUSH        H5C_NOTIFY_ACTION_AFTER_FLUSH
#define H5AC_NOTIFY_ACTION_BEFORE_EVICT       H5C_NOTIFY_ACTION_BEFORE_EVICT
#define H5AC_NOTIFY_ACTION_ENTRY_DIRTIED      H5C_NOTIFY_ACTION_ENTRY_DIRTIED
#define H5AC_NOTIFY_ACTION_ENTRY_CLEANED      H5C_NOTIFY_ACTION_ENTRY_CLEANED
#define H5AC_NOTIFY_ACTION_CHILD_DIRTIED      H5C_NOTIFY_ACTION_CHILD_DIRTIED
#define H5AC_NOTIFY_ACTION_CHILD_CLEANED      H5C_NOTIFY_ACTION_CHILD_CLEANED
#define H5AC_NOTIFY_ACTION_CHILD_UNSERIALIZED H5C_NOTIFY_ACTION_CHILD_UNSERIALIZED
#define H5AC_NOTIFY_ACTION_CHILD_SERIALIZED   H5C_NOTIFY_ACTION_CHILD_SERIALIZED
#define H5AC__CLASS_NO_FLAGS_SET          H5C__CLASS_NO_FLAGS_SET
#define H5AC__CLASS_SPECULATIVE_LOAD_FLAG H5C__CLASS_SPECULATIVE_LOAD_FLAG
#define H5AC__CLASS_SKIP_READS  H5C__CLASS_SKIP_READS
#define H5AC__CLASS_SKIP_WRITES H5C__CLASS_SKIP_WRITES
typedef H5C_get_initial_load_size_func_t H5AC_get_initial_load_size_func_t;
typedef H5C_get_final_load_size_func_t   H5AC_get_final_load_size_func_t;
typedef H5C_verify_chksum_func_t         H5AC_verify_chksum_func_t;
typedef H5C_deserialize_func_t           H5AC_deserialize_func_t;
typedef H5C_image_len_func_t             H5AC_image_len_func_t;
#define H5AC__SERIALIZE_NO_FLAGS_SET H5C__SERIALIZE_NO_FLAGS_SET
#define H5AC__SERIALIZE_RESIZED_FLAG H5C__SERIALIZE_RESIZED_FLAG
#define H5AC__SERIALIZE_MOVED_FLAG   H5C__SERIALIZE_MOVED_FLAG
typedef H5C_pre_serialize_func_t H5AC_pre_serialize_func_t;
typedef H5C_serialize_func_t     H5AC_serialize_func_t;
typedef H5C_notify_func_t        H5AC_notify_func_t;
typedef H5C_free_icr_func_t      H5AC_free_icr_func_t;
typedef H5C_get_fsf_size_t       H5AC_get_fsf_size_t;
typedef H5C_class_t H5AC_class_t;
typedef H5C_cache_entry_t H5AC_info_t;
typedef H5C_t H5AC_t;
typedef struct H5AC_proxy_entry_t {
    H5AC_info_t cache_info;
    haddr_t addr;
    H5SL_t *parents;
    size_t nchildren;
    size_t ndirty_children;
    size_t nunser_children;
} H5AC_proxy_entry_t;
#define H5AC__DEFAULT_METADATA_WRITE_STRATEGY H5AC_METADATA_WRITE_STRATEGY__DISTRIBUTED
#ifdef H5_HAVE_PARALLEL
#define H5AC__DEFAULT_CACHE_CONFIG                                            \
{                                                                             \
 H5AC__CURR_CACHE_CONFIG_VERSION, \
 false,                           \
 false,                           \
 false,                           \
 "",                              \
 true,                            \
 true,                            \
 ( 2 * 1024 * 1024),              \
 0.3,                            \
 (32 * 1024 * 1024),              \
 (1 * 1024 * 1024),               \
 50000,                           \
 H5C_incr__threshold,             \
 0.9,                            \
 2.0,                            \
 true,                            \
 (4 * 1024 * 1024),               \
                                  \
 H5C_flash_incr__add_space,       \
 1.0,                            \
 0.25,                           \
 H5C_decr__age_out_with_threshold, \
 0.999,                          \
 0.9,                           \
 true,                            \
 (1 * 1024 * 1024),               \
 3,                               \
 true,                            \
 0.1,                            \
 (256 * 1024),                    \
                                  \
                    H5AC__DEFAULT_METADATA_WRITE_STRATEGY  \
}
#else
#define H5AC__DEFAULT_CACHE_CONFIG                                            \
{                                                                             \
 H5C__CURR_AUTO_SIZE_CTL_VER,     \
 false,                           \
 false,                           \
 false,                           \
 "",                              \
 true,                            \
 true,                            \
 ( 2 * 1024 * 1024),              \
 0.01,                           \
 (32 * 1024 * 1024),              \
 ( 1 * 1024 * 1024),              \
 50000,                           \
 H5C_incr__threshold,             \
 0.9,                             \
 2.0,                             \
 true,                            \
 (4 * 1024 * 1024),               \
                                  \
 H5C_flash_incr__add_space,       \
 1.4,                             \
 0.25,                            \
 H5C_decr__age_out_with_threshold,\
 0.999,                           \
 0.9,                             \
 true,                            \
 (1 * 1024 * 1024),               \
 3,                               \
 true,                            \
 0.1,                             \
 (256 * 1024),                    \
                                 \
                    H5AC__DEFAULT_METADATA_WRITE_STRATEGY  \
}
#endif
#define H5AC__DEFAULT_CACHE_IMAGE_CONFIG                                     \
{                                                                            \
 H5AC__CURR_CACHE_IMAGE_CONFIG_VERSION, \
 false,                                 \
 false,                                 \
 H5AC__CACHE_IMAGE__ENTRY_AGEOUT__NONE  \
}
#define H5AC__NO_FLAGS_SET                H5C__NO_FLAGS_SET
#define H5AC__DELETED_FLAG                H5C__DELETED_FLAG
#define H5AC__DIRTIED_FLAG                H5C__DIRTIED_FLAG
#define H5AC__PIN_ENTRY_FLAG              H5C__PIN_ENTRY_FLAG
#define H5AC__UNPIN_ENTRY_FLAG            H5C__UNPIN_ENTRY_FLAG
#define H5AC__FLUSH_INVALIDATE_FLAG       H5C__FLUSH_INVALIDATE_FLAG
#define H5AC__FLUSH_CLEAR_ONLY_FLAG       H5C__FLUSH_CLEAR_ONLY_FLAG
#define H5AC__FLUSH_IGNORE_PROTECTED_FLAG H5C__FLUSH_IGNORE_PROTECTED_FLAG
#define H5AC__READ_ONLY_FLAG              H5C__READ_ONLY_FLAG
#define H5AC__FREE_FILE_SPACE_FLAG        H5C__FREE_FILE_SPACE_FLAG
#define H5AC__TAKE_OWNERSHIP_FLAG         H5C__TAKE_OWNERSHIP_FLAG
#define H5AC__FLUSH_LAST_FLAG             H5C__FLUSH_LAST_FLAG
#define H5AC__FLUSH_COLLECTIVELY_FLAG     H5C__FLUSH_COLLECTIVELY_FLAG
#define H5AC_ES__IN_CACHE            0x0001
#define H5AC_ES__IS_DIRTY            0x0002
#define H5AC_ES__IS_PROTECTED        0x0004
#define H5AC_ES__IS_PINNED           0x0008
#define H5AC_ES__IS_FLUSH_DEP_PARENT 0x0010
#define H5AC_ES__IS_FLUSH_DEP_CHILD  0x0020
#define H5AC_ES__IS_CORKED           0x0040
#define H5AC_ES__IMAGE_IS_UP_TO_DATE 0x0080
H5_DLLVAR const H5AC_class_t H5AC_BT[1];
H5_DLLVAR const H5AC_class_t H5AC_SNODE[1];
H5_DLLVAR const H5AC_class_t H5AC_LHEAP_PRFX[1];
H5_DLLVAR const H5AC_class_t H5AC_LHEAP_DBLK[1];
H5_DLLVAR const H5AC_class_t H5AC_GHEAP[1];
H5_DLLVAR const H5AC_class_t H5AC_OHDR[1];
H5_DLLVAR const H5AC_class_t H5AC_OHDR_CHK[1];
H5_DLLVAR const H5AC_class_t H5AC_BT2_HDR[1];
H5_DLLVAR const H5AC_class_t H5AC_BT2_INT[1];
H5_DLLVAR const H5AC_class_t H5AC_BT2_LEAF[1];
H5_DLLVAR const H5AC_class_t H5AC_FHEAP_HDR[1];
H5_DLLVAR const H5AC_class_t H5AC_FHEAP_DBLOCK[1];
H5_DLLVAR const H5AC_class_t H5AC_FHEAP_IBLOCK[1];
H5_DLLVAR const H5AC_class_t H5AC_FSPACE_HDR[1];
H5_DLLVAR const H5AC_class_t H5AC_FSPACE_SINFO[1];
H5_DLLVAR const H5AC_class_t H5AC_SOHM_TABLE[1];
H5_DLLVAR const H5AC_class_t H5AC_SOHM_LIST[1];
H5_DLLVAR const H5AC_class_t H5AC_EARRAY_HDR[1];
H5_DLLVAR const H5AC_class_t H5AC_EARRAY_IBLOCK[1];
H5_DLLVAR const H5AC_class_t H5AC_EARRAY_SBLOCK[1];
H5_DLLVAR const H5AC_class_t H5AC_EARRAY_DBLOCK[1];
H5_DLLVAR const H5AC_class_t H5AC_EARRAY_DBLK_PAGE[1];
H5_DLLVAR const H5AC_class_t H5AC_FARRAY_HDR[1];
H5_DLLVAR const H5AC_class_t H5AC_FARRAY_DBLOCK[1];
H5_DLLVAR const H5AC_class_t H5AC_FARRAY_DBLK_PAGE[1];
H5_DLLVAR const H5AC_class_t H5AC_SUPERBLOCK[1];
H5_DLLVAR const H5AC_class_t H5AC_DRVRINFO[1];
H5_DLLVAR const H5AC_class_t H5AC_EPOCH_MARKER[1];
H5_DLLVAR const H5AC_class_t H5AC_PROXY_ENTRY[1];
H5_DLLVAR const H5AC_class_t H5AC_PREFETCHED_ENTRY[1];
H5_DLL herr_t H5AC_init(void);
H5_DLL herr_t H5AC_create(const H5F_t *f, H5AC_cache_config_t *config_ptr,
                          H5AC_cache_image_config_t *image_config_ptr);
H5_DLL herr_t H5AC_get_entry_status(const H5F_t *f, haddr_t addr, unsigned *status_ptr);
H5_DLL herr_t H5AC_insert_entry(H5F_t *f, const H5AC_class_t *type, haddr_t addr, void *thing,
                                unsigned int flags);
H5_DLL herr_t H5AC_pin_protected_entry(void *thing);
H5_DLL herr_t H5AC_prep_for_file_close(H5F_t *f);
H5_DLL herr_t H5AC_prep_for_file_flush(H5F_t *f);
H5_DLL herr_t H5AC_secure_from_file_flush(H5F_t *f);
H5_DLL herr_t H5AC_create_flush_dependency(void *parent_thing, void *child_thing);
H5_DLL void  *H5AC_protect(H5F_t *f, const H5AC_class_t *type, haddr_t addr, void *udata, unsigned flags);
H5_DLL herr_t H5AC_resize_entry(void *thing, size_t new_size);
H5_DLL herr_t H5AC_unpin_entry(void *thing);
H5_DLL herr_t H5AC_destroy_flush_dependency(void *parent_thing, void *child_thing);
H5_DLL herr_t H5AC_unprotect(H5F_t *f, const H5AC_class_t *type, haddr_t addr, void *thing, unsigned flags);
H5_DLL herr_t H5AC_flush(H5F_t *f);
H5_DLL herr_t H5AC_mark_entry_dirty(void *thing);
H5_DLL herr_t H5AC_mark_entry_clean(void *thing);
H5_DLL herr_t H5AC_mark_entry_unserialized(void *thing);
H5_DLL herr_t H5AC_mark_entry_serialized(void *thing);
H5_DLL herr_t H5AC_move_entry(H5F_t *f, const H5AC_class_t *type, haddr_t old_addr, haddr_t new_addr);
H5_DLL herr_t H5AC_dest(H5F_t *f);
H5_DLL herr_t H5AC_evict(H5F_t *f);
H5_DLL herr_t H5AC_expunge_entry(H5F_t *f, const H5AC_class_t *type, haddr_t addr, unsigned flags);
H5_DLL herr_t H5AC_remove_entry(void *entry);
H5_DLL herr_t H5AC_get_cache_auto_resize_config(const H5AC_t *cache_ptr, H5AC_cache_config_t *config_ptr);
H5_DLL herr_t H5AC_get_cache_size(const H5AC_t *cache_ptr, size_t *max_size_ptr, size_t *min_clean_size_ptr,
                                  size_t *cur_size_ptr, uint32_t *cur_num_entries_ptr);
H5_DLL herr_t H5AC_get_cache_flush_in_progress(H5AC_t *cache_ptr, bool *flush_in_progress_ptr);
H5_DLL herr_t H5AC_get_cache_hit_rate(const H5AC_t *cache_ptr, double *hit_rate_ptr);
H5_DLL herr_t H5AC_reset_cache_hit_rate_stats(H5AC_t *cache_ptr);
H5_DLL herr_t H5AC_set_cache_auto_resize_config(H5AC_t *cache_ptr, const H5AC_cache_config_t *config_ptr);
H5_DLL herr_t H5AC_validate_config(const H5AC_cache_config_t *config_ptr);
H5_DLL herr_t H5AC_load_cache_image_on_next_protect(H5F_t *f, haddr_t addr, hsize_t len, bool rw);
H5_DLL herr_t H5AC_validate_cache_image_config(H5AC_cache_image_config_t *config_ptr);
H5_DLL bool   H5AC_cache_image_pending(const H5F_t *f);
H5_DLL herr_t H5AC_force_cache_image_load(H5F_t *f);
H5_DLL herr_t H5AC_get_mdc_image_info(const H5AC_t *cache_ptr, haddr_t *image_addr, hsize_t *image_len);
H5_DLL void   H5AC_tag(haddr_t metadata_tag, haddr_t *prev_tag);
H5_DLL herr_t H5AC_flush_tagged_metadata(H5F_t *f, haddr_t metadata_tag);
H5_DLL herr_t H5AC_evict_tagged_metadata(H5F_t *f, haddr_t metadata_tag, bool match_global);
H5_DLL herr_t H5AC_retag_copied_metadata(const H5F_t *f, haddr_t metadata_tag);
H5_DLL herr_t H5AC_ignore_tags(const H5F_t *f);
H5_DLL herr_t H5AC_cork(H5F_t *f, haddr_t obj_addr, unsigned action, bool *corked);
H5_DLL herr_t H5AC_get_entry_ring(const H5F_t *f, haddr_t addr, H5AC_ring_t *ring);
H5_DLL void   H5AC_set_ring(H5AC_ring_t ring, H5AC_ring_t *orig_ring);
H5_DLL herr_t H5AC_unsettle_entry_ring(void *entry);
H5_DLL herr_t H5AC_unsettle_ring(H5F_t *f, H5AC_ring_t ring);
H5_DLL herr_t H5AC_expunge_tag_type_metadata(H5F_t *f, haddr_t tag, int type_id, unsigned flags);
H5_DLL herr_t H5AC_get_tag(const void *thing, haddr_t *tag);
H5_DLL H5AC_proxy_entry_t *H5AC_proxy_entry_create(void);
H5_DLL herr_t              H5AC_proxy_entry_add_parent(H5AC_proxy_entry_t *pentry, void *parent);
H5_DLL herr_t              H5AC_proxy_entry_remove_parent(H5AC_proxy_entry_t *pentry, void *parent);
H5_DLL herr_t              H5AC_proxy_entry_add_child(H5AC_proxy_entry_t *pentry, H5F_t *f, void *child);
H5_DLL herr_t              H5AC_proxy_entry_remove_child(H5AC_proxy_entry_t *pentry, void *child);
H5_DLL herr_t              H5AC_proxy_entry_dest(H5AC_proxy_entry_t *pentry);
#ifdef H5_HAVE_PARALLEL
H5_DLL herr_t H5AC_add_candidate(H5AC_t *cache_ptr, haddr_t addr);
#endif
H5_DLL herr_t H5AC_stats(const H5F_t *f);
#ifndef NDEBUG
H5_DLL herr_t H5AC_dump_cache(const H5F_t *f);
H5_DLL herr_t H5AC_get_entry_ptr_from_addr(const H5F_t *f, haddr_t addr, void **entry_ptr_ptr);
H5_DLL herr_t H5AC_flush_dependency_exists(H5F_t *f, haddr_t parent_addr, haddr_t child_addr,
                                           bool *fd_exists_ptr);
H5_DLL herr_t H5AC_verify_entry_type(const H5F_t *f, haddr_t addr, const H5AC_class_t *expected_type,
                                     bool *in_cache_ptr, bool *type_ok_ptr);
H5_DLL bool   H5AC_get_serialization_in_progress(H5F_t *f);
H5_DLL bool   H5AC_cache_is_clean(const H5F_t *f, H5AC_ring_t inner_ring);
#endif
#endif
