// (c) The HDF Group
#if !(defined H5I_FRIEND || defined H5I_MODULE)
#error "Do not include this file outside the H5I package!"
#endif
#ifndef H5Ipkg_H
#define H5Ipkg_H
#include "H5Iprivate.h"
#define TYPE_BITS 7
#define TYPE_MASK (((hid_t)1 << TYPE_BITS) - 1)
#define H5I_MAX_NUM_TYPES TYPE_MASK
#define ID_BITS ((sizeof(hid_t) * 8) - (TYPE_BITS + 1))
#define ID_MASK (((hid_t)1 << ID_BITS) - 1)
#define H5I_TYPE(a) ((H5I_type_t)(((hid_t)(a) >> ID_BITS) & TYPE_MASK))
typedef struct H5I_id_info_t {
    hid_t    id;
    unsigned count;
    unsigned app_count;
    union {
        const void *c_object;
        void       *object;
    } u;
    bool                      is_future;
    H5I_future_realize_func_t realize_cb;
    H5I_future_discard_func_t discard_cb;
    bool           marked;
    UT_hash_handle hh;
} H5I_id_info_t;
typedef struct H5I_type_info_t {
    const H5I_class_t *cls;
    unsigned           init_count;
    uint64_t           id_count;
    uint64_t           nextid;
    H5I_id_info_t     *last_id_info;
    H5I_id_info_t     *hash_table;
} H5I_type_info_t;
H5_DLLVAR H5I_type_info_t *H5I_type_info_array_g[H5I_MAX_NUM_TYPES];
H5_DLLVAR int H5I_next_type_g;
H5_DLL hid_t          H5I__register(H5I_type_t type, const void *object, bool app_ref,
                                    H5I_future_realize_func_t realize_cb, H5I_future_discard_func_t discard_cb);
H5_DLL int            H5I__destroy_type(H5I_type_t type);
H5_DLL void          *H5I__remove_verify(hid_t id, H5I_type_t type);
H5_DLL int            H5I__inc_type_ref(H5I_type_t type);
H5_DLL int            H5I__get_type_ref(H5I_type_t type);
H5_DLL H5I_id_info_t *H5I__find_id(hid_t id);
#ifdef H5I_TESTING
H5_DLL ssize_t H5I__get_name_test(hid_t id, char *name, size_t size, bool *cached);
#endif
#endif
