% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratWO_data_frame.R
\name{stratWO.data.frame}
\alias{stratWO.data.frame}
\title{Stratified win odds with adjustment}
\usage{
\method{stratWO}{data.frame}(
  x,
  AVAL,
  TRTP,
  STRATA,
  ref,
  COVAR = NULL,
  alpha = 0.05,
  WOnull = 1,
  ...
)
}
\arguments{
\item{x}{a data frame containing subject-level data.}

\item{AVAL}{variable in the data with ordinal analysis values.}

\item{TRTP}{the treatment variable in the data.}

\item{STRATA}{a character variable for stratification.}

\item{ref}{the reference treatment group.}

\item{COVAR}{a numeric covariate.}

\item{alpha}{the reference treatment group.}

\item{WOnull}{the null hypothesis. The default is 1.}

\item{...}{additional parameters.}
}
\value{
a data frame containing the following columns:
\itemize{
\item WO stratified (or adjusted/stratified) win odds.
\item LCL lower confidence limit for adjusted (or adjusted/stratified) WO.
\item UCL upper confidence limit for adjusted (or adjusted/stratified) WO.
\item SE standard error of the adjusted (or adjusted/stratified) win odds.
\item WOnull win odds of the null hypothesis (specified in the \code{WOnull} argument).
\item alpha two-sided significance level for calculating the confidence interval (specified in the \code{alpha} argument).
\item Pvalue p-value associated with testing the null hypothesis.
\item WP adjusted (or adjusted/stratified) win probability.
\item SE_WP standard error for the adjusted (or adjusted/stratified) win probability.
\item SD_WP standard deviation of the adjusted (or adjusted/stratified) win probability.
\item N total number of patients in the analysis.
\item Type "STRATIFIED" or "STRATIFIED/ADJUSTED" depending on whether \code{COVAR} is specified.
}
}
\description{
Stratified win odds with adjustment
}
\examples{
# Stratified win odds
res <- stratWO(x = KHCE, AVAL = "AVAL", TRTP = "TRTP", 
STRATA = "STRATAN", ref = "P")
res
## Compare with the win odds in each stratum separately
lapply(split(KHCE, KHCE$STRATAN), calcWO, AVAL = "AVAL", TRTP = "TRTP", ref = "P")
# Stratified and adjusted win odds
res <- stratWO(x = KHCE, AVAL = "AVAL", COVAR = "EGFRBL", 
TRTP = "TRTP", STRATA = "STRATAN", ref = "P")
res
}
\references{
Gasparyan SB et al. (2021) "Adjusted win ratio with stratification: calculation methods and interpretation." Statistical Methods in Medical Research 30.2: 580-611. \url{doi:10.1177/0962280220942558}
}
\seealso{
\code{\link[=stratWO]{stratWO()}}.
}
