% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hawkes.R
\name{residuals}
\alias{residuals}
\title{Residuals of a Hawkes process}
\usage{
residuals(x, fun = NULL, repr = NULL, family = NULL, M = NULL, ...)
}
\arguments{
\item{x}{A non-negative numeric vector, sorted in ascending order; or an object of class "hawkes" output by function \code{hawkes}.}

\item{fun}{(default = TRUE) A non-negative numeric function or value - intensity (function) of the immigrant process.}

\item{repr}{(default = NULL) A non-negative numeric value - mean number of offsprings.}

\item{family}{(default = NULL) A character string "name" naming a distribution with corresponding distribution function \code{dname}, or directly the distribution function.}

\item{M}{(default = NULL) A non-negative numeric value - upper bound on \code{fun}(ignored if \code{fun} is a numeric value).}

\item{...}{Additional arguments passed on to the random generation function \code{dname}.}
}
\value{
The residuals of the process.
}
\description{
Outputs the residuals (values of the compensator at the times of arrival) of a Hawkes process.
Useful function for diagnosis through the random time change theorem: the residuals should follow
a unit rate Poisson process.
}
\examples{
# Simulate an exponential Hawkes process with baseline intensity 1,
# reproduction mean 0.5 and exponential fertility distribution with rate 2.
x <- hawkes(10, fun=1, repr=0.5, family="exp", rate=2)
resid = residuals(x)
resid
plot(resid)
abline(0, 1, col="red", lty="dashed")
# Residuals with a different set of parameters
residuals(x, repr=0.8, rate=3)
# Residuals with a different distribution function
residuals(x, family="chisq", df=2)
# Simulate a Hawkes process with baseline intensity function 1 + sin(x),
# reproduction mean 0.5 and custom [0,1]-triangular fertility function.
x <- hawkes(10, fun=function(y) {1+sin(y)}, M=2, repr=0.5,
            family=function(n) {1 - sqrt(1 - runif(n))})
resid = residuals(x, family=function(y) ifelse(y>0 & y<1, 2-2*y, 0))
plot(resid)
abline(0, 1, col="red", lty="dashed")
}
