% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_phenology.R
\name{plot_phenology}
\alias{plot_phenology}
\title{Visualize fish phenology}
\usage{
plot_phenology(plot, style = "all", labels = TRUE)
}
\arguments{
\item{plot}{A list containing the output from \code{predict_phenology()}}

\item{style}{The style of the plot. A vector with possible values "all",
"ef_cumsum", "ef_daily". The default is "all".}

\item{labels}{Logical. If TRUE (default), labels are added to the plot.}
}
\value{
A object of class "gg" and "ggplot".
}
\description{
The function takes the output from \code{predict_phenology()} and creates a
basic ggplot2 plot object to visualize the predicted phenology.
}
\examples{
library(hatchR)
# get model parameterization
sockeye_hatch_mod <- model_select(
  author = "Beacham and Murray 1990",
  species = "sockeye",
  model = 2,
  development_type = "hatch"
)
# predict phenology
sockeye_hatch <- predict_phenology(
  data = woody_island,
  dates = date,
  temperature = temp_c,
  spawn.date = "1990-08-18",
  model = sockeye_hatch_mod
)
plot_phenology(sockeye_hatch)
plot_phenology(sockeye_hatch, style = "ef_cumsum")
plot_phenology(sockeye_hatch, style = "ef_daily")
plot_phenology(sockeye_hatch, labels = FALSE)
}
