% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_select.R
\name{model_select}
\alias{model_select}
\title{Select a development model structure}
\usage{
model_select(author, species, model_id, development_type = "hatch")
}
\arguments{
\item{author}{Character string of author name.}

\item{species}{Character string of species name.}

\item{model_id}{Either model number from Beacham and Murray (1990) or specific to other paper (e.g., Sparks et al. 2017 = AK).}

\item{development_type}{The phenology type. A vector with possible values
"hatch" or "emerge". The default is "hatch".}
}
\value{
A data.frame giving model specifications to be passed to
\code{predict_phenology()}.
}
\description{
The function calls a model table with the parameterizations for
different species from different studies built in. Refer to the
table (\code{model_table}) before using function to find inputs for
the different function arguments. It pulls the model format as a
string and parses it to be usable in \strong{hatchR} model.
}
\examples{
library(hatchR)
# access the parameterization for sockeye hatching using
# model #2 from Beacham and Murray (1990)
sockeye_hatch_mod <- model_select(
  author = "Beacham and Murray 1990",
  species = "sockeye",
  model_id = 2,
  development_type = "hatch"
)
# print
sockeye_hatch_mod
}
