% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{merge}
\alias{merge}
\alias{merge.Rcpp_Hashmap}
\title{Merge two Hashmaps}
\usage{
\method{merge}{Rcpp_Hashmap}(x, y, type = c("inner", "left", "right", "full"),
  ...)
}
\arguments{
\item{x}{an object created by a call to \code{hashmap}.}

\item{y}{an object created by a call to \code{hashmap}.}

\item{type}{a character string specifying the type of join, with
partial argument matching (abbreviation) supported.}

\item{\dots}{not used.}
}
\value{
a \code{data.frame}.
}
\description{
merge method for Hashmap class
}
\details{
Valid arguments for type are:
\itemize{
 \item \code{"inner"}: similar to \code{all = FALSE} in \code{base::merge}
 \item \code{"left"}: similar to \code{all.x = TRUE} in \code{base::merge}
 \item \code{"right"}: similar to \code{all.y = TRUE} in \code{base::merge}
 \item \code{"full"}: similar to \code{all = TRUE} in \code{base::merge}
}

The default value for \code{type} is \code{"inner"}.
}
\examples{
hx <- hashmap(LETTERS[1:5], 1:5)
hy <- hashmap(LETTERS[4:8], 4:8)

## inner join
merge(hx, hy)

merge(
    hx$data.frame(),
    hy$data.frame(),
    by = "Keys",
    sort = FALSE
)

## left join
merge(hx, hy, "left")

merge(
    hx$data.frame(),
    hy$data.frame(),
    by = "Keys",
    all.x = TRUE,
    sort = FALSE
)

## right join
merge(hx, hy, "right")

merge(
    hx$data.frame(),
    hy$data.frame(),
    by = "Keys",
    all.y = TRUE,
    sort = FALSE
)

## full outer join
merge(hx, hy, "full")

merge(
    hx$data.frame(),
    hy$data.frame(),
    by = "Keys",
    all = TRUE,
    sort = FALSE
)
}
