% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hp_palette.R
\name{hpMap}
\alias{hpMap}
\alias{hp}
\alias{hp_pal}
\alias{harrypotter}
\title{Harry Potter Colour Map.}
\usage{
hpMap(n = 256, alpha = 1, begin = 0, end = 1, direction = 1,
  house = "hufflepuff")

hp(n, alpha = 1, begin = 0, end = 1, direction = 1,
  house = "hufflepuff")

hp_pal(alpha = 1, begin = 0, end = 1, direction = 1,
  house = "hufflepuff")

harrypotter(n, alpha = 1, begin = 0, end = 1, direction = 1,
  house = "hufflepuff")
}
\arguments{
\item{n}{The number of colors (\eqn{\ge 1}) to be in the palette.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin}{The (corrected) hue in [0,1] at which the hp colormap begins.}

\item{end}{The (corrected) hue in [0,1] at which the hp colormap ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are ordered from darkest to lightest. If -1, the order of colors is reversed.}

\item{house}{A character string indicating the colourmap from a house to use.
Four houses are available: "Gryffindor", "Slytherin", "Ravenclaw" and "Hufflepuff".}
}
\value{
\code{hp} returns a character vector, \code{cv}, of color hex
codes. This can be used either to create a user-defined color palette for
subsequent graphics by \code{palette(cv)}, a \code{col =} specification in
graphics functions or in \code{par}.

\code{hpMap} returns a \code{n} lines data frame containing the
red (\code{R}), green (\code{G}), blue (\code{B}) and alpha (\code{alpha})
channels of \code{n} equally spaced colors along the 'Harry Potter' colour map.
\code{n = 256} by default.
}
\description{
This function creates a vector of \code{n} equally spaced colors along the
'HP colour map' created by an average calculated for all the colours present in every frame of the pictures.
}
\details{
\if{html}{Here are the color scales:

  \out{<div style="text-align: center">}\figure{hogwarts-scales.png}{houses: style="width:750px;max-width:90\%;"}\out{</div>}

  }
\if{latex}{Here are the color scales:

  \out{\begin{center}}\figure{hogwarts-scales.png}\out{\end{center}}
  }


Semi-transparent colors (\eqn{0 < alpha < 1}) are supported only on some
devices: see \code{\link[grDevices]{rgb}}.
}
\examples{
library(ggplot2)
library(hexbin)

dat <- data.frame(x = rnorm(10000), y = rnorm(10000))

ggplot(dat, aes(x = x, y = y)) +
  geom_hex() + coord_fixed() +
  scale_fill_gradientn(colours = hp(256, house = "Hufflepuff"))

# using code from RColorBrewer to demo the palette
n = 200
image(
  1:n, 1, as.matrix(1:n),
  col = hp(n, house = "Slytherin"),
  xlab = "hp n", ylab = "", xaxt = "n", yaxt = "n", bty = "n"
)

}
\author{
Alejandro Jiménez Rico \email{aljrico@gmail.com}, \href{https://aljrico.github.io}{Personal Blog}
}
