% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_garch.R
\name{hcp_garch}
\alias{hcp_garch}
\title{Change Finder using GARCH}
\usage{
hcp_garch(sw_size = 5)
}
\arguments{
\item{sw_size}{Sliding window size}
}
\value{
\code{hcp_garch} object
}
\description{
Change-point detection is related to event/trend change detection. Change Finder GARCH detects change points based on deviations relative to linear regression model \url{doi:10.1109/TKDE.2006.1599387}.
It wraps the GARCH model presented in the rugarch library.
}
\examples{
library(daltoolbox)

#loading the example database
data(har_examples)

#Using example 14
dataset <- har_examples$example14
head(dataset)

# setting up change point method
model <- hcp_garch()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
