% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmo_base36.R
\name{hmo_base36}
\alias{hmo_base36}
\title{Motif discovery using base36}
\usage{
hmo_base36(a, w, qtd)
}
\arguments{
\item{a}{alphabet size}

\item{w}{word size}

\item{qtd}{number of occurrences to be classified as motifs}
}
\value{
\code{hmo_base36} object
}
\description{
Motif discovery using base36 \url{doi:10.1007/s10618-007-0064-z}
}
\examples{
library(daltoolbox)

#loading the example database
data(har_examples)

#Using example 15
dataset <- har_examples$example15
head(dataset)

# setting up motif discovery method
model <- hmo_base36(37, 3, 3)

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
