structure(list(method = "GET", url = "https://data.geopf.fr/wfs/ows?service=wfs&version=2.0.0&request=GetCapabilities&sections=FeatureTypeList", 
    status_code = 200L, headers = structure(list(date = "Sun, 05 May 2024 13:21:26 GMT", 
        `content-type` = "application/xml", `www-authenticate` = "Key realm=\"kong\"", 
        `x-frame-options` = "SAMEORIGIN", `cache-control` = "max-age=0, must-revalidate", 
        `content-disposition` = "inline; filename=geoserver-GetCapabilities.application", 
        `content-encoding` = "gzip", `strict-transport-security` = "max-age=15724800; includeSubDomains", 
        `access-control-allow-origin` = "*", `access-control-allow-credentials` = "true", 
        `access-control-allow-methods` = "GET, PUT, POST, DELETE, PATCH, OPTIONS", 
        `access-control-allow-headers` = "DNT,Keep-Alive,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type,Range,Authorization", 
        `access-control-max-age` = "1728000", `set-cookie` = "REDACTED", 
        `transfer-encoding` = "chunked", `set-cookie` = "REDACTED"), class = "httr2_headers"), 
    body = charToRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?><wfs:WFS_Capabilities version=\"2.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://www.opengis.net/wfs/2.0\" xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:gml=\"http://www.opengis.net/gml/3.2\" xmlns:fes=\"http://www.opengis.net/fes/2.0\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xsi:schemaLocation=\"http://www.opengis.net/wfs/2.0 https://data.geopf.fr/wfs/schemas/wfs/2.0/wfs.xsd\" xmlns:xml=\"http://www.w3.org/XML/1998/namespace\" xmlns:LANDCOVER.CHA12_FR=\"http://LANDCOVER.CHA12_FR\" xmlns:cartes=\"http://cartes\" xmlns:test_mig_rlt=\"http://test_mig_rlt\" xmlns:OCS-GERS_BDD_LAMB93_2016=\"http://OCS-GERS_BDD_LAMB93_2016\" xmlns:PRSF_BDD_GLP_2023=\"http://PRSF_BDD_GLP_2023\" xmlns:LANDCOVER.CHA06_FR=\"http://LANDCOVER.CHA06_FR\" xmlns:TRANSPORTS.DRONES.RESTRICTIONS=\"http://TRANSPORTS.DRONES.RESTRICTIONS\" xmlns:DEBROUSSAILLEMENT=\"http://DEBROUSSAILLEMENT\" xmlns:REPARTITION.POTENTIEL.METHANISATION.2050=\"http://REPARTITION.POTENTIEL.METHANISATION.2050\" xmlns:PROTECTEDAREAS.PNR=\"http://PROTECTEDAREAS.PNR\" xmlns:PROTECTEDAREAS.ZPR=\"http://PROTECTEDAREAS.ZPR\" xmlns:CADASTRALPARCELS.GRAPHE=\"http://CADASTRALPARCELS.GRAPHE\" xmlns:LANDCOVER.CLC12R_DOM=\"http://LANDCOVER.CLC12R_DOM\" xmlns:BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G=\"http://BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G\" xmlns:LANDCOVER.CLC18_DOM=\"http://LANDCOVER.CLC18_DOM\" xmlns:TRANSPORTS.AIRNOISE.DOCS=\"http://TRANSPORTS.AIRNOISE.DOCS\" xmlns:PROTECTEDAREAS.MNHN.CONSERVATOIRES=\"http://PROTECTEDAREAS.MNHN.CONSERVATOIRES\" xmlns:PROTECTEDAREAS.UNESCO=\"http://PROTECTEDAREAS.UNESCO\" xmlns:AREAMANAGEMENT.QP.VECTOR=\"http://AREAMANAGEMENT.QP.VECTOR\" xmlns:RPG.2015=\"http://RPG.2015\" xmlns:pays_ecoregions=\"http://pays_ecoregions\" xmlns:test_nl_meae_representation_diplo_fr_wld=\"http://test_nl_meae_representation_diplo_fr_wld\" xmlns:RPG.2020=\"http://RPG.2020\" xmlns:communes_972=\"http://communes_972\" xmlns:PROTECTEDAREAS.PRSF=\"http://PROTECTEDAREAS.PRSF\" xmlns:PROTECTEDAREAS.GP=\"http://PROTECTEDAREAS.GP\" xmlns:PROTECTEDAREAS.BIOS=\"http://PROTECTEDAREAS.BIOS\" xmlns:PROTECTEDAREAS.APHN=\"http://PROTECTEDAREAS.APHN\" xmlns:POTENTIEL.SOLAIRE.SOL=\"http://POTENTIEL.SOLAIRE.SOL\" xmlns:CGET_QP_BDD_WLD_WM_20160412=\"http://CGET_QP_BDD_WLD_WM_20160412\" xmlns:LANDCOVER.CHA12_DOM=\"http://LANDCOVER.CHA12_DOM\" xmlns:RPG.2021=\"http://RPG.2021\" xmlns:espace_revendeurs=\"http://espace_revendeurs\" xmlns:PRAIRIES.SENSIBLES.BCAE=\"http://PRAIRIES.SENSIBLES.BCAE\" xmlns:VIGICRUES_TRONCONS_BDD_WLD_WM_2023-v1=\"http://VIGICRUES_TRONCONS_BDD_WLD_WM_2023-v1\" xmlns:ORTHOIMAGERY.ORTHO-SAT.SPOT.2017.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHO-SAT.SPOT.2017.GRAPHE-MOSAIQUAGE\" xmlns:ORTHOIMAGERY.ORTHOPHOTOS.1950-1965.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHOPHOTOS.1950-1965.GRAPHE-MOSAIQUAGE\" xmlns:DREAL.ZONAGE_PINEL=\"http://DREAL.ZONAGE_PINEL\" xmlns:MESURES_COMPENSATOIRES=\"http://MESURES_COMPENSATOIRES\" xmlns:HAIES.BOCAGES=\"http://HAIES.BOCAGES\" xmlns:LANDCOVER.CLC06R_DOM=\"http://LANDCOVER.CLC06R_DOM\" xmlns:fr_qa_stations=\"http://fr_qa_stations\" xmlns:DGAC-PGS_BDD_FXX_WM=\"http://DGAC-PGS_BDD_FXX_WM\" xmlns:VIGICRUES-INT=\"http://VIGICRUES-INT\" xmlns:LANDCOVER.CLC06_DOM=\"http://LANDCOVER.CLC06_DOM\" xmlns:ORTHOIMAGERY.ORTHOPHOS.RESTRICTEDAREAS=\"http://ORTHOIMAGERY.ORTHOPHOS.RESTRICTEDAREAS\" xmlns:VIGICRUES=\"http://VIGICRUES\" xmlns:ELEVATIONGRIDCOVERAGE.HIGHRES.QUALITY=\"http://ELEVATIONGRIDCOVERAGE.HIGHRES.QUALITY\" xmlns:LANDCOVER.CLC12_FR=\"http://LANDCOVER.CLC12_FR\" xmlns:LANDCOVER.CHA00_FR=\"http://LANDCOVER.CHA00_FR\" xmlns:espace_revendeurs_beta=\"http://espace_revendeurs_beta\" xmlns:PROTECTEDAREAS.ZPS=\"http://PROTECTEDAREAS.ZPS\" xmlns:VIGICRUES_STATIONS_BDD_WLD_WM_2023-v1=\"http://VIGICRUES_STATIONS_BDD_WLD_WM_2023-v1\" xmlns:AOC-VITICOLES=\"http://AOC-VITICOLES\" xmlns:ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2016-2020=\"http://ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2016-2020\" xmlns:wfs_du=\"http://wfs_du\" xmlns:ELEVATION.CONTOUR.LINE=\"http://ELEVATION.CONTOUR.LINE\" xmlns:PRSF_BDD_REU_2023=\"http://PRSF_BDD_REU_2023\" xmlns:RPG.2014=\"http://RPG.2014\" xmlns:RPG.2019=\"http://RPG.2019\" xmlns:LANDCOVER.CLC06_FR=\"http://LANDCOVER.CLC06_FR\" xmlns:LOT.CHASSE=\"http://LOT.CHASSE\" xmlns:PROTECTEDAREAS.MNHN.CDL.PARCELS=\"http://PROTECTEDAREAS.MNHN.CDL.PARCELS\" xmlns:CADASTRALPARCELS.HEATMAP=\"http://CADASTRALPARCELS.HEATMAP\" xmlns:PROTECTEDAREAS.PNM=\"http://PROTECTEDAREAS.PNM\" xmlns:cosia_032_aubiet=\"http://cosia_032_aubiet\" xmlns:LANDCOVER.CHA18_FR=\"http://LANDCOVER.CHA18_FR\" xmlns:DGAC-PEB-POI_BDD_WLD_WM=\"http://DGAC-PEB-POI_BDD_WLD_WM\" xmlns:CADASTRALPARCELS.QUALREFBDP=\"http://CADASTRALPARCELS.QUALREFBDP\" xmlns:PROTECTEDAREAS.MNHN.CDL.PERIMETER=\"http://PROTECTEDAREAS.MNHN.CDL.PERIMETER\" xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\" xmlns:PROTECTEDAREAS.RB=\"http://PROTECTEDAREAS.RB\" xmlns:LABELS.TOURISTIQUES=\"http://LABELS.TOURISTIQUES\" xmlns:HYDROGRAPHY.BCAE.LATEST=\"http://HYDROGRAPHY.BCAE.LATEST\" xmlns:ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2006-2010=\"http://ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2006-2010\" xmlns:PROTECTEDSITES.MNHN.RESERVES-REGIONALES=\"http://PROTECTEDSITES.MNHN.RESERVES-REGIONALES\" xmlns:DGAC-PGS-POI_BDD_FXX_WM=\"http://DGAC-PGS-POI_BDD_FXX_WM\" xmlns:ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE-MOSAIQUAGE\" xmlns:UTILIYANDGOVERNMENTALSERVICES.IGN.POI.GARES=\"http://UTILIYANDGOVERNMENTALSERVICES.IGN.POI.GARES\" xmlns:PROTECTEDAREAS.MNHN.RN.PERIMETER=\"http://PROTECTEDAREAS.MNHN.RN.PERIMETER\" xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\" xmlns:test_nl_bdtopo_la_ciotat=\"http://test_nl_bdtopo_la_ciotat\" xmlns:GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN25.GRAPHE-MOSAIQUAGE=\"http://GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN25.GRAPHE-MOSAIQUAGE\" xmlns:PROTECTEDAREAS.APB=\"http://PROTECTEDAREAS.APB\" xmlns:SANTE_BDD_SYMBO_FXX_WM_20171227=\"http://SANTE_BDD_SYMBO_FXX_WM_20171227\" xmlns:ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2011-2015=\"http://ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2011-2015\" xmlns:LANDCOVER.CLC0OR_FR=\"http://LANDCOVER.CLC0OR_FR\" xmlns:LANDCOVER.CHA18_DOM=\"http://LANDCOVER.CHA18_DOM\" xmlns:PROTECTEDAREAS.RAMSAR=\"http://PROTECTEDAREAS.RAMSAR\" xmlns:LANDCOVER.CLC18_FR=\"http://LANDCOVER.CLC18_FR\" xmlns:COMMUNES.EPCISANSFISCALITEPROPRE=\"http://COMMUNES.EPCISANSFISCALITEPROPRE\" xmlns:UTILIYANDGOVERNMENTALSERVICES.IGN.POI.SANTE=\"http://UTILIYANDGOVERNMENTALSERVICES.IGN.POI.SANTE\" xmlns:RPG.2012=\"http://RPG.2012\" xmlns:GARES_BDD_FXX_WM_20171227=\"http://GARES_BDD_FXX_WM_20171227\" xmlns:STOCK_CARBONE_REG_2015=\"http://STOCK_CARBONE_REG_2015\" xmlns:RPG.LATEST=\"http://RPG.LATEST\" xmlns:RPG.2013=\"http://RPG.2013\" xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\" xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\" xmlns:LANDCOVER.CLC06R_FR=\"http://LANDCOVER.CLC06R_FR\" xmlns:BDFORETV1_BDD_FXX_LAMB93_20140403=\"http://BDFORETV1_BDD_FXX_LAMB93_20140403\" xmlns:RPG.2011=\"http://RPG.2011\" xmlns:AREAMANAGEMENT.ZUS.VECTOR=\"http://AREAMANAGEMENT.ZUS.VECTOR\" xmlns:ORTHOIMAGERY.ORTHO-SAT.SPOT.2015.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHO-SAT.SPOT.2015.GRAPHE-MOSAIQUAGE\" xmlns:LANDCOVER.CLC12_DOM=\"http://LANDCOVER.CLC12_DOM\" xmlns:jpe_test_open_io=\"http://jpe_test_open_io\" xmlns:INSEE.FILOSOFI.INDICATORS=\"http://INSEE.FILOSOFI.INDICATORS\" xmlns:OCS-BFC_2017_BDD_WLD_WM_WFS_23-07-2021=\"http://OCS-BFC_2017_BDD_WLD_WM_WFS_23-07-2021\" xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\" xmlns:BDTOPO.EXTENSION.NOM_USUEL=\"http://BDTOPO.EXTENSION.NOM_USUEL\" xmlns:STATISTICALUNITS.IRIS=\"http://STATISTICALUNITS.IRIS\" xmlns:SECUROUT.TE=\"http://SECUROUT.TE\" xmlns:test_zae=\"http://test_zae\" xmlns:POI.CULTURE_LOISIRS=\"http://POI.CULTURE_LOISIRS\" xmlns:RPG.2010=\"http://RPG.2010\" xmlns:LANDCOVER.CLC12R_FR=\"http://LANDCOVER.CLC12R_FR\" xmlns:BDCARTO_V5=\"http://BDCARTO_V5\" xmlns:LANDCOVER.CLC90_FR=\"http://LANDCOVER.CLC90_FR\" xmlns:PROTECTEDAREAS.INPG=\"http://PROTECTEDAREAS.INPG\" xmlns:ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2000-2005=\"http://ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2000-2005\" xmlns:wfs_scot=\"http://wfs_scot\" xmlns:PROTECTEDAREAS.ZNIEFF2.SEA=\"http://PROTECTEDAREAS.ZNIEFF2.SEA\" xmlns:LANDCOVER.CLC00_FR=\"http://LANDCOVER.CLC00_FR\" xmlns:LANDCOVER.CLC00_DOM=\"http://LANDCOVER.CLC00_DOM\" xmlns:PROTECTEDAREAS.APLG=\"http://PROTECTEDAREAS.APLG\" xmlns:RPG.2017=\"http://RPG.2017\" xmlns:INPE=\"http://INPE\" xmlns:PROTECTEDAREAS.ZNIEFF2=\"http://PROTECTEDAREAS.ZNIEFF2\" xmlns:PROTECTEDAREAS.PN=\"http://PROTECTEDAREAS.PN\" xmlns:LANDCOVER.FORESTINVENTORY.V2=\"http://LANDCOVER.FORESTINVENTORY.V2\" xmlns:CADASTRALPARCELS.PARCELLAIRE_EXPRESS=\"http://CADASTRALPARCELS.PARCELLAIRE_EXPRESS\" xmlns:TRACES.RANDO.HIVERNALE=\"http://TRACES.RANDO.HIVERNALE\" xmlns:POTENTIEL.SOLAIRE.BATIMENT=\"http://POTENTIEL.SOLAIRE.BATIMENT\" xmlns:DELMAR_BDD_WFS=\"http://DELMAR_BDD_WFS\" xmlns:GEOGRAPHICALGRIDSYSTEM.DFCI=\"http://GEOGRAPHICALGRIDSYSTEM.DFCI\" xmlns:ORTHOIMAGERY.ORTHO-SAT.SPOT.2016.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHO-SAT.SPOT.2016.GRAPHE-MOSAIQUAGE\" xmlns:RPG.2018=\"http://RPG.2018\" xmlns:DGAC-PEB_BDD_FXX_WM=\"http://DGAC-PEB_BDD_FXX_WM\" xmlns:ADMINEXPRESS_COG_2018_CARTO=\"http://ADMINEXPRESS_COG_2018_CARTO\" xmlns:AREAMANAGEMENT.ZFU.VECTOR=\"http://AREAMANAGEMENT.ZFU.VECTOR\" xmlns:RPG.2022=\"http://RPG.2022\" xmlns:GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN50.1950.GRAPHE=\"http://GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN50.1950.GRAPHE\" xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\" xmlns:PROTECTEDAREAS.RNCF=\"http://PROTECTEDAREAS.RNCF\" xmlns:VIGICRUES-QUA=\"http://VIGICRUES-QUA\" xmlns:PROTECTEDAREAS.ZNIEFF1.SEA=\"http://PROTECTEDAREAS.ZNIEFF1.SEA\" xmlns:ORTHOIMAGERY.ORTHO-SAT.SPOT.2014.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHO-SAT.SPOT.2014.GRAPHE-MOSAIQUAGE\" xmlns:PROTECTEDAREAS.SIC=\"http://PROTECTEDAREAS.SIC\" xmlns:VIGICRUES_TERRITOIRES_BDD_WLD_WM_2023-v1=\"http://VIGICRUES_TERRITOIRES_BDD_WLD_WM_2023-v1\" xmlns:OCS-GERS_BDD_LAMB93_2019=\"http://OCS-GERS_BDD_LAMB93_2019\" xmlns:PROTECTEDAREAS.RIPN=\"http://PROTECTEDAREAS.RIPN\" xmlns:PROTECTEDAREAS.RNN=\"http://PROTECTEDAREAS.RNN\" xmlns:PROTECTEDAREAS.ZNIEFF1=\"http://PROTECTEDAREAS.ZNIEFF1\" xmlns:BDGEODESIQUE=\"http://BDGEODESIQUE\" xmlns:RPG.2016=\"http://RPG.2016\" xmlns:jm_pays_ecoregions=\"http://jm_pays_ecoregions\" xmlns:wfs_sup=\"http://wfs_sup\" xmlns:pva=\"http://pva\" xmlns:PRSF_BDD_GUF_2023=\"http://PRSF_BDD_GUF_2023\" xmlns:STATISTICALUNITS.IRISGE=\"http://STATISTICALUNITS.IRISGE\" xmlns:LANDCOVER.FORESTINVENTORY.V1=\"http://LANDCOVER.FORESTINVENTORY.V1\" xmlns:LANDCOVER.CHA06_DOM=\"http://LANDCOVER.CHA06_DOM\" xmlns:PROTECTEDAREAS.APG=\"http://PROTECTEDAREAS.APG\" xmlns:BDTOPO_V3=\"http://BDTOPO_V3\" xmlns:PROTECTEDAREAS.RNC=\"http://PROTECTEDAREAS.RNC\" xmlns:Carhab_habitat=\"http://Carhab_habitat\" xmlns:BAN-PLUS=\"http://BAN-PLUS\" xmlns:BAN.DATA.GOUV=\"http://BAN.DATA.GOUV\" xmlns:GEODESIE=\"http://GEODESIE\" updateSequence=\"3398\"><FeatureTypeList><FeatureType xmlns:OCS-GERS_BDD_LAMB93_2016=\"http://OCS-GERS_BDD_LAMB93_2016\"><Name>OCS-GERS_BDD_LAMB93_2016:oscge_gers_32_2016</Name><Title> OCSGE Gers 2016</Title><Abstract> OCSGE Gers 2016</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-0.306429 43.28809591</ows:LowerCorner><ows:UpperCorner>1.21178144 44.0914897</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:OCS-GERS_BDD_LAMB93_2019=\"http://OCS-GERS_BDD_LAMB93_2019\"><Name>OCS-GERS_BDD_LAMB93_2019:oscge_gers_32_2019</Name><Title> OCSGE Gers 2019 </Title><Abstract> OCSGE Gers 2019 </Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-0.306429 43.28809591</ows:LowerCorner><ows:UpperCorner>1.21178144 44.0914897</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:arrondissement</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:arrondissement_municipal</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:canton</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:chflieu_arrondissement_municipal</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:chflieu_commune</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:chflieu_commune_associee_ou_deleguee</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:collectivite_territoriale</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:commune</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:commune_associee_ou_deleguee</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:departement</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:epci</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG.LATEST=\"http://ADMINEXPRESS-COG.LATEST\"><Name>ADMINEXPRESS-COG.LATEST:region</Name><Title>ADMINEXPRESS COG 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:arrondissement</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:arrondissement_municipal</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:canton</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:chflieu_arrondissement_municipal</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:chflieu_commune</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:chflieu_commune_associee_ou_deleguee</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:collectivite_territoriale</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:commune</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:commune_associee_ou_deleguee</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:departement</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:epci</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS-COG-CARTO.LATEST=\"http://ADMINEXPRESS-COG-CARTO.LATEST\"><Name>ADMINEXPRESS-COG-CARTO.LATEST:region</Name><Title>ADMINEXPRESS COG CARTO 2023</Title><Abstract>édition 2023</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.0847418 -21.38963076</ows:LowerCorner><ows:UpperCorner>55.83662923 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_sup=\"http://wfs_sup\"><Name>wfs_sup:acte_sup</Name><Title>Acte de servitude d'utilité publique</Title><Abstract>Liste des actes instituant une servitude d'utilité publique</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -49.86640625</ows:LowerCorner><ows:UpperCorner>78.046875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:arrondissement</Name><Title>Arrondissement</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:arrondissement_municipal</Name><Title>Arrondissement municipal</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\"><Name>ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST:arrondissement</Name><Title>Arrondissements</Title><Abstract>Arrondissements</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80983861776941 -21.389630761010356</ows:LowerCorner><ows:UpperCorner>55.83665387473344 51.088989440786094</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\"><Name>ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST:arrondissement_municipal</Name><Title>Arrondissements municipaux</Title><Abstract>Arrondissements municipaux</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80983861776941 -21.389630761010356</ows:LowerCorner><ows:UpperCorner>55.83665387473344 51.088989440786094</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.APG=\"http://PROTECTEDAREAS.APG\"><Name>PROTECTEDAREAS.APG:apg</Name><Title>Arrêtés de protection de géotope</Title><Abstract>Sites d'intérêt géologique faisant l'objet d’une interdiction de destruction, d'altération ou de dégradation du site, ainsi que de prélèvement, de destruction ou de dégradation de fossiles, minéraux et concrétions présents sur ces sites appelés « aires de protection de géotope».</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>1.84634829 43.91802301</ows:LowerCorner><ows:UpperCorner>4.61007198 48.85525383</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.APHN=\"http://PROTECTEDAREAS.APHN\"><Name>PROTECTEDAREAS.APHN:aphn</Name><Title>Arrêtés de protection d’habitats naturels</Title><Abstract>Dispositif visant à protéger un habitat naturel (récif corallien, tourbière, prairie, etc.) en tant que tel, sans qu'il soit besoin d'établir qu'il constitue par ailleurs un habitat d'espèces protégées. Mise à jour 05-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-0.966796875 44.180944824</ows:LowerCorner><ows:UpperCorner>6.899414062 50.255175781</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.APLG=\"http://PROTECTEDAREAS.APLG\"><Name>PROTECTEDAREAS.APLG:aplg</Name><Title>Arrêtés listes de sites d'intérêt géologique</Title><Abstract>L'arrêté préfectoral fixant la liste départementale de sites d'intérêt géologique est un outil règlementaire qui vise à protéger, par des mesures générales, les sites géologiques qui sont mentionnés en son sein. Il s'agit d'un des deux outils mis en place par le décret du 28 décembre 2015 codifié aux articles R.411-17-1 et 17-2 du code de l'environnement et précisé par la Note du 1er décembre 2016 relative à la protection des sites d'intérêt géologique</Abstract><ows:Keywords><ows:Keyword>geologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.13927604 47.32788872</ows:LowerCorner><ows:UpperCorner>-1.13186347 48.88517694</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_sup=\"http://wfs_sup\"><Name>wfs_sup:assiette_sup_l</Name><Title>Assiette de servitude d'utilité publique</Title><Abstract>Assiettes linéaires liées aux servitudes</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -49.86640625</ows:LowerCorner><ows:UpperCorner>78.046875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_sup=\"http://wfs_sup\"><Name>wfs_sup:assiette_sup_p</Name><Title>Assiette de servitude d'utilité publique</Title><Abstract>Assiettes ponctuelles liées aux servitudes</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -49.86640625</ows:LowerCorner><ows:UpperCorner>78.046875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_sup=\"http://wfs_sup\"><Name>wfs_sup:assiette_sup_s</Name><Title>Assiette de servitude d'utilité publique</Title><Abstract>Assiettes surfaciques liées aux servitudes</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -49.86640625</ows:LowerCorner><ows:UpperCorner>78.046875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:cosia_032_aubiet=\"http://cosia_032_aubiet\"><Name>cosia_032_aubiet:data_aubiet_25_05</Name><Title>Aubiet (32)</Title><Abstract>Données CoSIA du Gers</Abstract><ows:Keywords><ows:Keyword>CoSIA</ows:Keyword><ows:Keyword>Gers</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>0.78121805 43.63242184</ows:LowerCorner><ows:UpperCorner>0.81940944 43.66015696</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BAN-PLUS=\"http://BAN-PLUS\"><Name>BAN-PLUS:adresse</Name><Title>BAN PLUS adresse</Title><Abstract>Base Nationale Adresse PLUS : adresse</Abstract><ows:Keywords><ows:Keyword>BAN PLUS</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80792925 -21.38749008</ows:LowerCorner><ows:UpperCorner>55.83211236 51.0823567</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BAN-PLUS=\"http://BAN-PLUS\"><Name>BAN-PLUS:lien_adresse_bati</Name><Title>BAN PLUS lien adresse bâti</Title><Abstract>Base Nationale Adresse PLUS : lien adresse bâti</Abstract><ows:Keywords><ows:Keyword>BAN PLUS</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80792925 -21.38749008</ows:LowerCorner><ows:UpperCorner>55.83211236 51.0823567</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BAN-PLUS=\"http://BAN-PLUS\"><Name>BAN-PLUS:lien_adresse_parcelle</Name><Title>BAN PLUS lien adresse parcelle</Title><Abstract>Base Nationale Adresse PLUS : lien adresse parcelle</Abstract><ows:Keywords><ows:Keyword>BAN PLUS</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80792925 -21.38749008</ows:LowerCorner><ows:UpperCorner>55.83211236 51.0823567</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BAN-PLUS=\"http://BAN-PLUS\"><Name>BAN-PLUS:lien_adresse_support</Name><Title>BAN PLUS lien adresse support</Title><Abstract>Base Nationale Adresse PLUS : lien adresse support</Abstract><ows:Keywords><ows:Keyword>BAN PLUS</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80792925 -21.38749008</ows:LowerCorner><ows:UpperCorner>55.83211236 51.0823567</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BAN-PLUS=\"http://BAN-PLUS\"><Name>BAN-PLUS:lien_bati_parcelle</Name><Title>BAN PLUS lien bâti parcelle</Title><Abstract>Base Nationale Adresse PLUS : lien bâti parcelle</Abstract><ows:Keywords><ows:Keyword>BAN PLUS</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80792925 -21.38749008</ows:LowerCorner><ows:UpperCorner>55.83211236 51.0823567</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU3:a_1_limite_administrative</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Seul le niveau 3 de géoréférencement de niveau 3 est visible sur le site Géoportail. Il existe un géoréférencement de niveau 4 de meilleure qualité disponible. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52303725 43.09602342</ows:LowerCorner><ows:UpperCorner>7.35518119 51.08427873</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU3:a_2_surface_administrative</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Seul le niveau 3 de géoréférencement de niveau 3 est visible sur le site Géoportail. Il existe un géoréférencement de niveau 4 de meilleure qualité disponible. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52303725 43.09602342</ows:LowerCorner><ows:UpperCorner>7.35518119 51.08427873</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU3:b_1_troncon_de_route</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Seul le niveau 3 de géoréférencement de niveau 3 est visible sur le site Géoportail. Il existe un géoréférencement de niveau 4 de meilleure qualité disponible. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52303725 43.09602342</ows:LowerCorner><ows:UpperCorner>7.35518119 51.08427873</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU3:b_2_troncon_de_voie_ferree</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Seul le niveau 3 de géoréférencement de niveau 3 est visible sur le site Géoportail. Il existe un géoréférencement de niveau 4 de meilleure qualité disponible. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52303725 43.09602342</ows:LowerCorner><ows:UpperCorner>7.35518119 51.08427873</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU3:b_3_troncon_de_cours_d_eau</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Seul le niveau 3 de géoréférencement de niveau 3 est visible sur le site Géoportail. Il existe un géoréférencement de niveau 4 de meilleure qualité disponible. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52303725 43.09602342</ows:LowerCorner><ows:UpperCorner>7.35518119 51.08427873</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU3:c_1_1_ocs_ancien</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Seul le niveau 3 de géoréférencement de niveau 3 est visible sur le site Géoportail. Il existe un géoréférencement de niveau 4 de meilleure qualité disponible. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52303725 43.09602342</ows:LowerCorner><ows:UpperCorner>7.35518119 51.08427873</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU3:c_1_2_ocs_ancien_sans_bati</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Seul le niveau 3 de géoréférencement de niveau 3 est visible sur le site Géoportail. Il existe un géoréférencement de niveau 4 de meilleure qualité disponible. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52303725 43.09602342</ows:LowerCorner><ows:UpperCorner>7.35518119 51.08427873</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU3:c_2_1_batiment</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Seul le niveau 3 de géoréférencement de niveau 3 est visible sur le site Géoportail. Il existe un géoréférencement de niveau 4 de meilleure qualité disponible. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52303725 43.09602342</ows:LowerCorner><ows:UpperCorner>7.35518119 51.08427873</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU3:c_2_2_batiment_hors_zone_urbaine</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Seul le niveau 3 de géoréférencement de niveau 3 est visible sur le site Géoportail. Il existe un géoréférencement de niveau 4 de meilleure qualité disponible. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52303725 43.09602342</ows:LowerCorner><ows:UpperCorner>7.35518119 51.08427873</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU3:c_3_zone_urbaine</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Seul le niveau 3 de géoréférencement de niveau 3 est visible sur le site Géoportail. Il existe un géoréférencement de niveau 4 de meilleure qualité disponible. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52303725 43.09602342</ows:LowerCorner><ows:UpperCorner>7.35518119 51.08427873</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU3=\"http://BDCARTO_ETAT-MAJOR.NIVEAU3\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU3:z_1_chantier</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Seul le niveau 3 de géoréférencement de niveau 3 est visible sur le site Géoportail. Il existe un géoréférencement de niveau 4 de meilleure qualité disponible. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52303725 43.09602342</ows:LowerCorner><ows:UpperCorner>7.35518119 51.08427873</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU4:a_1_limite_administrative</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.27143298 44.00271216</ows:LowerCorner><ows:UpperCorner>7.33718287 46.80272707</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU4:a_2_surface_administrative</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.27143298 44.00271216</ows:LowerCorner><ows:UpperCorner>7.33718287 46.80272707</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU4:b_1_troncon_de_route</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.27143298 44.00271216</ows:LowerCorner><ows:UpperCorner>7.33718287 46.80272707</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU4:b_2_troncon_de_voie_ferree</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.27143298 44.00271216</ows:LowerCorner><ows:UpperCorner>7.33718287 46.80272707</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU4:b_3_troncon_de_cours_d_eau</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.27143298 44.00271216</ows:LowerCorner><ows:UpperCorner>7.33718287 46.80272707</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU4:c_1_1_ocs_ancien</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.27143298 44.00271216</ows:LowerCorner><ows:UpperCorner>7.33718287 46.80272707</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU4:c_1_2_ocs_ancien_sans_bati</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.27143298 44.00271216</ows:LowerCorner><ows:UpperCorner>7.33718287 46.80272707</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU4:c_2_1_batiment</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.27143298 44.00271216</ows:LowerCorner><ows:UpperCorner>7.33718287 46.80272707</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU4:c_2_2_batiment_hors_zone_urbaine</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.27143298 44.00271216</ows:LowerCorner><ows:UpperCorner>7.33718287 46.80272707</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU4:c_3_zone_urbaine</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.27143298 44.00271216</ows:LowerCorner><ows:UpperCorner>7.33718287 46.80272707</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_ETAT-MAJOR.NIVEAU4=\"http://BDCARTO_ETAT-MAJOR.NIVEAU4\"><Name>BDCARTO_ETAT-MAJOR.NIVEAU4:z_1_chantier</Name><Title>BD CARTO Etat-major</Title><Abstract>Représentation de l'occupation du sol de la France métropolitaine au 19e siècle. La production des données est réalisée à partir des cartes d'Etat-major, élaborées entre 1825 et 1866. Elle est complétée par des mises à jour partielles (ajout des voies de chemin de fer notamment) jusqu'en 1889. Source : IGN</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.27143298 44.00271216</ows:LowerCorner><ows:UpperCorner>7.33718287 46.80272707</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDFORETV1_BDD_FXX_LAMB93_20140403=\"http://BDFORETV1_BDD_FXX_LAMB93_20140403\"><Name>BDFORETV1_BDD_FXX_LAMB93_20140403:resu_bdv1_shape</Name><Title>BDForêt V1</Title><Abstract>BDForêt V1</Abstract><ows:Keywords><ows:Keyword>Occupation des terres</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52302711 41.3210097</ows:LowerCorner><ows:UpperCorner>9.73594151 51.02854951</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.FORESTINVENTORY.V1=\"http://LANDCOVER.FORESTINVENTORY.V1\"><Name>LANDCOVER.FORESTINVENTORY.V1:resu_bdv1_shape</Name><Title>BDForêt V1</Title><Abstract>BDForêt V1</Abstract><ows:Keywords><ows:Keyword>Occupation des terres</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52302711 41.3210097</ows:LowerCorner><ows:UpperCorner>9.73594151 51.02854951</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDGEODESIQUE=\"http://BDGEODESIQUE\"><Name>BDGEODESIQUE:rgp</Name><Title>BDGéodésique rgp</Title><Abstract>Fiches signalétiques des repères de nivellement (points matérialisés dont l'altitude est déterminée avec précision) et des sites géodésiques (ensembles de points matérialisés dont les coordonnées, bidimensionnelles ou tridimensionnelles suivant le type de point, sont connues avec précision). </Abstract><ows:Keywords><ows:Keyword>BDGéodésique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-178.180792 -66.68794411</ows:LowerCorner><ows:UpperCorner>140.009732 51.81018838</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDGEODESIQUE=\"http://BDGEODESIQUE\"><Name>BDGEODESIQUE:rn</Name><Title>BDGéodésique rl</Title><Abstract>Fiches signalétiques des repères de nivellement (points matérialisés dont l'altitude est déterminée avec précision) et des sites géodésiques (ensembles de points matérialisés dont les coordonnées, bidimensionnelles ou tridimensionnelles suivant le type de point, sont connues avec précision). </Abstract><ows:Keywords><ows:Keyword>BDGéodésique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-178.180792 -66.68794411</ows:LowerCorner><ows:UpperCorner>140.009732 51.81018838</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDGEODESIQUE=\"http://BDGEODESIQUE\"><Name>BDGEODESIQUE:site</Name><Title>BDGéodésique site</Title><Abstract>Fiches signalétiques des repères de nivellement (points matérialisés dont l'altitude est déterminée avec précision) et des sites géodésiques (ensembles de points matérialisés dont les coordonnées, bidimensionnelles ou tridimensionnelles suivant le type de point, sont connues avec précision). </Abstract><ows:Keywords><ows:Keyword>BDGéodésique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-178.180792 -66.68794411</ows:LowerCorner><ows:UpperCorner>140.009732 51.81018838</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDGEODESIQUE=\"http://BDGEODESIQUE\"><Name>BDGEODESIQUE:triplet</Name><Title>BDGéodésique triplet</Title><Abstract>Fiches signalétiques des repères de nivellement (points matérialisés dont l'altitude est déterminée avec précision) et des sites géodésiques (ensembles de points matérialisés dont les coordonnées, bidimensionnelles ou tridimensionnelles suivant le type de point, sont connues avec précision). </Abstract><ows:Keywords><ows:Keyword>BDGéodésique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-178.180792 -66.68794411</ows:LowerCorner><ows:UpperCorner>140.009732 51.81018838</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G=\"http://BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G\"><Name>BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G:arrondissement</Name><Title>BDParcellaire vecteur  (WFS)</Title><Abstract>BDParcellaire vecteur.</Abstract><ows:Keywords><ows:Keyword>BDParcellaire</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15313141 -21.38974728</ows:LowerCorner><ows:UpperCorner>55.83668585 51.0888974</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G=\"http://BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G\"><Name>BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G:batiment</Name><Title>BDParcellaire vecteur  (WFS)</Title><Abstract>BDParcellaire vecteur.</Abstract><ows:Keywords><ows:Keyword>BDParcellaire</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15313141 -21.38974728</ows:LowerCorner><ows:UpperCorner>55.83668585 51.0888974</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G=\"http://BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G\"><Name>BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G:commune</Name><Title>BDParcellaire vecteur  (WFS)</Title><Abstract>BDParcellaire vecteur.</Abstract><ows:Keywords><ows:Keyword>BDParcellaire</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15313141 -21.38974728</ows:LowerCorner><ows:UpperCorner>55.83668585 51.0888974</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G=\"http://BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G\"><Name>BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G:divcad</Name><Title>BDParcellaire vecteur  (WFS)</Title><Abstract>BDParcellaire vecteur.</Abstract><ows:Keywords><ows:Keyword>BDParcellaire</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15313141 -21.38974728</ows:LowerCorner><ows:UpperCorner>55.83668585 51.0888974</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G=\"http://BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G\"><Name>BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G:localisant</Name><Title>BDParcellaire vecteur  (WFS)</Title><Abstract>BDParcellaire vecteur.</Abstract><ows:Keywords><ows:Keyword>BDParcellaire</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15313141 -21.38974728</ows:LowerCorner><ows:UpperCorner>55.83668585 51.0888974</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G=\"http://BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G\"><Name>BDPARCELLAIRE-VECTEUR_WLD_BDD_WGS84G:parcelle</Name><Title>BDParcellaire vecteur  (WFS)</Title><Abstract>BDParcellaire vecteur.</Abstract><ows:Keywords><ows:Keyword>BDParcellaire</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15313141 -21.38974728</ows:LowerCorner><ows:UpperCorner>55.83668585 51.0888974</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:arrondissement</Name><Title>BDTOPO : Arrondissements</Title><Abstract>Arrondissements − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>arrondissement</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:arrondissement_municipal</Name><Title>BDTOPO : Arrondissements municipaux</Title><Abstract>Arrondissements municipaux − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>arrondissement_municipal</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:itineraire_autre</Name><Title>BDTOPO : Autres itinéraires</Title><Abstract>Autres itinéraires − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>itineraire_autre</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:aerodrome</Name><Title>BDTOPO : Aérodromes</Title><Abstract>Aérodromes − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>aerodrome</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:bassin_versant_topographique</Name><Title>BDTOPO : Bassins versants topographiques</Title><Abstract>Bassins versants topographiques − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>bassin_versant_topographique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:batiment</Name><Title>BDTOPO : Bâtiments</Title><Abstract>Bâtiments − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>batiment</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:canalisation</Name><Title>BDTOPO : Canalisations</Title><Abstract>Canalisations − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>canalisation</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:cimetiere</Name><Title>BDTOPO : Cimetières</Title><Abstract>Cimetières − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>cimetiere</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:collectivite_territoriale</Name><Title>BDTOPO : Collectivités territoriales</Title><Abstract>Collectivités territoriales − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>collectivite_territoriale</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:commune</Name><Title>BDTOPO : Communes</Title><Abstract>Communes − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>commune</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:commune_associee_ou_deleguee</Name><Title>BDTOPO : Communes associées ou déléguées</Title><Abstract>Communes associées ou déléguées − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>commune_associee_ou_deleguee</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:condominium</Name><Title>BDTOPO : Condominiums</Title><Abstract>Condominiums − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>condominium</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:construction_lineaire</Name><Title>BDTOPO : Constructions linéaires</Title><Abstract>Constructions linéaires − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>construction_lineaire</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:construction_ponctuelle</Name><Title>BDTOPO : Constructions ponctuelles</Title><Abstract>Constructions ponctuelles − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>construction_ponctuelle</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:construction_surfacique</Name><Title>BDTOPO : Constructions surfaciques</Title><Abstract>Constructions surfaciques − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>construction_surfacique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:cours_d_eau</Name><Title>BDTOPO : Cours d'eau</Title><Abstract>Cours d'eau − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>cours_d_eau</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:departement</Name><Title>BDTOPO : Départements</Title><Abstract>Départements − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>departement</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:detail_hydrographique</Name><Title>BDTOPO : Détails hydrographiques</Title><Abstract>Détails hydrographiques − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>detail_hydrographique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:detail_orographique</Name><Title>BDTOPO : Détails orographiques</Title><Abstract>Détails orographiques − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>detail_orographique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:epci</Name><Title>BDTOPO : EPCI</Title><Abstract>EPCI − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>epci</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:erp</Name><Title>BDTOPO : ERP</Title><Abstract>ERP − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>erp</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:foret_publique</Name><Title>BDTOPO : Forêts publiques</Title><Abstract>Forêts publiques − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>foret_publique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:haie</Name><Title>BDTOPO : Haies</Title><Abstract>Haies − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>haie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:lieu_dit_non_habite</Name><Title>BDTOPO : Lieux-dits non habités</Title><Abstract>Lieux-dits non habités − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>lieu_dit_non_habite</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:ligne_orographique</Name><Title>BDTOPO : Lignes orographiques</Title><Abstract>Lignes orographiques − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>ligne_orographique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:ligne_electrique</Name><Title>BDTOPO : Lignes électriques</Title><Abstract>Lignes électriques − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>ligne_electrique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:limite_terre_mer</Name><Title>BDTOPO : Limites terre-mer</Title><Abstract>Limites terre-mer − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>limite_terre_mer</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:non_communication</Name><Title>BDTOPO : Non-communications</Title><Abstract>Non-communications − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>non_communication</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:noeud_hydrographique</Name><Title>BDTOPO : Nœuds hydrographiques</Title><Abstract>Nœuds hydrographiques − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>noeud_hydrographique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:parc_ou_reserve</Name><Title>BDTOPO : Parcs et réserves</Title><Abstract>Parcs et réserves − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>parc_ou_reserve</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:piste_d_aerodrome</Name><Title>BDTOPO : Pistes d'aérodrome</Title><Abstract>Pistes d'aérodrome − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>piste_d_aerodrome</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:plan_d_eau</Name><Title>BDTOPO : Plans d'eau</Title><Abstract>Plans d'eau − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>plan_d_eau</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:point_d_acces</Name><Title>BDTOPO : Points d'accès</Title><Abstract>Points d'accès − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>point_d_acces</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:point_de_repere</Name><Title>BDTOPO : Points de repère</Title><Abstract>Points de repère − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>point_de_repere</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:point_du_reseau</Name><Title>BDTOPO : Points de réseau</Title><Abstract>Points de réseau − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>point_du_reseau</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:poste_de_transformation</Name><Title>BDTOPO : Postes de transformation</Title><Abstract>Postes de transformation − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>poste_de_transformation</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:pylone</Name><Title>BDTOPO : Pylônes</Title><Abstract>Pylônes − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>pylone</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:route_numerotee_ou_nommee</Name><Title>BDTOPO : Routes numérotées et routes nommées</Title><Abstract>Routes numérotées et routes nommées − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>route_numerotee_ou_nommee</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:region</Name><Title>BDTOPO : Régions</Title><Abstract>Régions − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>region</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:reservoir</Name><Title>BDTOPO : Réservoirs</Title><Abstract>Réservoirs − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>reservoir</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:section_de_points_de_repere</Name><Title>BDTOPO : Sections de points de repère</Title><Abstract>Sections de points de repère − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>section_de_points_de_repere</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:surface_hydrographique</Name><Title>BDTOPO : Surfaces hydrographiques</Title><Abstract>Surfaces hydrographiques − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>surface_hydrographique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:terrain_de_sport</Name><Title>BDTOPO : Terrains de sport</Title><Abstract>Terrains de sport − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>terrain_de_sport</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:toponymie_hydrographie</Name><Title>BDTOPO : Toponymies d'hydrographie</Title><Abstract>Toponymies d'hydrographie − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>toponymie_hydrographie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:toponymie_bati</Name><Title>BDTOPO : Toponymies de bâti</Title><Abstract>Toponymies de bâti − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>toponymie_bati</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:toponymie_lieux_nommes</Name><Title>BDTOPO : Toponymies de lieux nommés</Title><Abstract>Toponymies de lieux nommés − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>toponymie_lieux_nommes</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:toponymie_services_et_activites</Name><Title>BDTOPO : Toponymies des services et activités</Title><Abstract>Toponymies des services et activités − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>toponymie_services_et_activites</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:toponymie_transport</Name><Title>BDTOPO : Toponymies des transports</Title><Abstract>Toponymies des transports − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>toponymie_transport</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:toponymie_zones_reglementees</Name><Title>BDTOPO : Toponymies des zones réglementées</Title><Abstract>Toponymies des zones réglementées − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>toponymie_zones_reglementees</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:transport_par_cable</Name><Title>BDTOPO : Transports par câble</Title><Abstract>Transports par câble − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>transport_par_cable</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:troncon_de_route</Name><Title>BDTOPO : Tronçons de route</Title><Abstract>Tronçons de route − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>troncon_de_route</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:troncon_de_voie_ferree</Name><Title>BDTOPO : Tronçons de voie ferrée</Title><Abstract>Tronçons de voie ferrée − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>troncon_de_voie_ferree</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:troncon_hydrographique</Name><Title>BDTOPO : Tronçons hydrographiques</Title><Abstract>Tronçons hydrographiques − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>troncon_hydrographique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:voie_ferree_nommee</Name><Title>BDTOPO : Voies ferrées nommées</Title><Abstract>Voies ferrées nommées − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>voie_ferree_nommee</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:voie_nommee</Name><Title>BDTOPO : Voies nommées</Title><Abstract>Voies nommées − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>voie_nommee</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:zone_d_activite_ou_d_interet</Name><Title>BDTOPO : Zones d'activité et zones d'intérêt</Title><Abstract>Zones d'activité et zones d'intérêt − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>zone_d_activite_ou_d_interet</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:zone_d_estran</Name><Title>BDTOPO : Zones d'estran</Title><Abstract>Zones d'estran − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>zone_d_estran</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:zone_d_habitation</Name><Title>BDTOPO : Zones d'habitation</Title><Abstract>Zones d'habitation − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>zone_d_habitation</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:zone_de_vegetation</Name><Title>BDTOPO : Zones de végétation</Title><Abstract>Zones de végétation − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>zone_de_vegetation</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO_V3=\"http://BDTOPO_V3\"><Name>BDTOPO_V3:equipement_de_transport</Name><Title>BDTOPO : Équipements de transport</Title><Abstract>Équipements de transport − BDTOPO</Abstract><ows:Keywords><ows:Keyword>features</ows:Keyword><ows:Keyword>equipement_de_transport</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.77265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.9734375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDTOPO.EXTENSION.NOM_USUEL=\"http://BDTOPO.EXTENSION.NOM_USUEL\"><Name>BDTOPO.EXTENSION.NOM_USUEL:extension_nom_usuel</Name><Title>BDTOPO Extension : Noms Usuels</Title><Abstract>BDTOPO Extension : Noms Usuels</Abstract><ows:Keywords><ows:Keyword>Noms usuels</ows:Keyword><ows:Keyword>BDTOPO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -80.0</ows:LowerCorner><ows:UpperCorner>180.0 80.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.APB=\"http://PROTECTEDAREAS.APB\"><Name>PROTECTEDAREAS.APB:apb</Name><Title>Biotopes d'espèces protégées</Title><Abstract>Conservation de l'habitat d'espèces protégées. Outil réglementaires de niveau départemental. Mise à jour 09-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-109.43767837 -21.37814188</ows:LowerCorner><ows:UpperCorner>55.68722025 50.98414979</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:test_nl_bdtopo_la_ciotat=\"http://test_nl_bdtopo_la_ciotat\"><Name>test_nl_bdtopo_la_ciotat:batiment</Name><Title>Bâtiments</Title><Abstract>Bâtiments (sélection sur La Ciotat - Bouches-du-Rhône) issus de la BD Topo V3</Abstract><ows:Keywords><ows:Keyword>DATA NON OFFICIELLE</ows:Keyword><ows:Keyword>DEMO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>5.053164062 43.152705078</ows:LowerCorner><ows:UpperCorner>5.680722656 43.340776367</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:STATISTICALUNITS.IRIS=\"http://STATISTICALUNITS.IRIS\"><Name>STATISTICALUNITS.IRIS:contours_iris</Name><Title>CONTOURS IRIS 2021</Title><Abstract>Contours géométriques des IRIS de l'INSEE édition 2022</Abstract><ows:Keywords><ows:Keyword>Statistiques</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.8098218 -21.38929713</ows:LowerCorner><ows:UpperCorner>55.83665387 51.08898944</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC00_DOM=\"http://LANDCOVER.CLC00_DOM\"><Name>LANDCOVER.CLC00_DOM:clc00_dom</Name><Title>CORINE Land Cover - DOM - 2000</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2000 en 50 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et de l'aménagement de l'espace. La base de données CORINE Land Cover DOM 2000 a été réalisée à partir de CORINE Land Cover DOM 2006 et de la base des changements 2000-2006.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.90315964 -21.48017901</ows:LowerCorner><ows:UpperCorner>55.93309174 16.60478396</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC06_DOM=\"http://LANDCOVER.CLC06_DOM\"><Name>LANDCOVER.CLC06_DOM:clc06_dom</Name><Title>CORINE Land Cover - DOM - 2006</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2006 en 50 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et de l'aménagement de l'espace. La base de données CORINE Land Cover DOM 2006 a été réalisée à partir d'images satellitaires prises entre 2005 et 2008 et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.90315964 -21.48017901</ows:LowerCorner><ows:UpperCorner>55.93309174 16.60478396</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC06R_DOM=\"http://LANDCOVER.CLC06R_DOM\"><Name>LANDCOVER.CLC06R_DOM:clc06r_dom</Name><Title>CORINE Land Cover - DOM - 2006 révisée</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2006 en 50 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et de l'aménagement de l'espace. La base de données CORINE Land Cover 2006 révisée, dite CLC 2006 révisée, est une correction de CLC 2006 réalisée à partir d'images satellitaires prises entre 2005 et 2008 et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.90315964 -21.48017901</ows:LowerCorner><ows:UpperCorner>55.93309174 16.60478396</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC12_DOM=\"http://LANDCOVER.CLC12_DOM\"><Name>LANDCOVER.CLC12_DOM:clc12_dom</Name><Title>CORINE Land Cover - DOM - 2012</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2012 en 50 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et de l'aménagement de l'espace. La base de données CORINE Land Cover DOM 2012 a été réalisée à partir de CORINE Land Cover DOM 2006 révisée et de la base des changements 2006-2012.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.90315964 -21.48017901</ows:LowerCorner><ows:UpperCorner>55.93309174 16.60478396</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC12R_DOM=\"http://LANDCOVER.CLC12R_DOM\"><Name>LANDCOVER.CLC12R_DOM:clc12r_dom</Name><Title>CORINE Land Cover - DOM - 2012 révisée</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2012 en 50 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le  Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et de l'aménagement de l'espace. La base de données CORINE Land Cover 2012 révisée, dite CLC 2012 révisée, est une correction de CLC 2012 réalisée à partir d'images satellitaires prises entre 2011 et 2012 et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.90315964 -21.48017901</ows:LowerCorner><ows:UpperCorner>55.93309174 16.60478396</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC18_DOM=\"http://LANDCOVER.CLC18_DOM\"><Name>LANDCOVER.CLC18_DOM:clc18_dom</Name><Title>CORINE Land Cover - DOM - 2018</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2018 en 50 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le  Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et de l'aménagement de l'espace. La base de données CORINE Land Cover DOM 2018 a été réalisée à partir de CORINE Land Cover DOM 2012 révisée et de la base des changements 2012-2018.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.90315964 -21.48017901</ows:LowerCorner><ows:UpperCorner>55.93309174 16.60478396</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CHA06_DOM=\"http://LANDCOVER.CHA06_DOM\"><Name>LANDCOVER.CHA06_DOM:cha06_dom</Name><Title>CORINE Land Cover - DOM - Changements 2000-2006</Title><Abstract>Inventaire biophysique du changement d'occupation des sols entre 2000 et 2006 suivant la nomenclature CORINE Land Cover en 50 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et de l'aménagement de l'espace. La base des changements CORINE Land Cover DOM 2000-2006 a été réalisée à partir d'images satellitaires des périodes 1998-2003 et 2005-2008, et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.90315964 -21.48017901</ows:LowerCorner><ows:UpperCorner>55.93309174 16.60478396</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CHA12_DOM=\"http://LANDCOVER.CHA12_DOM\"><Name>LANDCOVER.CHA12_DOM:cha12_dom</Name><Title>CORINE Land Cover - DOM - Changements 2006-2012</Title><Abstract>Inventaire biophysique du changement d'occupation des sols entre 2006 et 212 suivant la nomenclature CORINE Land Cover en 50 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et de l'aménagement de l'espace. La base des changements CORINE Land Cover DOM 2006-2012 a été réalisée à partir d'images satellitaires des périodes 2005-2008 et 2011-2012, et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.90315964 -21.48017901</ows:LowerCorner><ows:UpperCorner>55.93309174 16.60478396</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CHA18_DOM=\"http://LANDCOVER.CHA18_DOM\"><Name>LANDCOVER.CHA18_DOM:cha18_dom</Name><Title>CORINE Land Cover - DOM - Changements 2012-2018</Title><Abstract>Inventaire biophysique du changement d'occupation des sols entre 2012 et 2018 suivant la nomenclature CORINE Land Cover en 50 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le  Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et de l'aménagement de l'espace. La base des changements CORINE Land Cover DOM 2012-2018 a été réalisée à partir d'images satellitaires des périodes 2011-2012 et 2016-2017, et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.90315964 -21.48017901</ows:LowerCorner><ows:UpperCorner>55.93309174 16.60478396</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC90_FR=\"http://LANDCOVER.CLC90_FR\"><Name>LANDCOVER.CLC90_FR:clc90_fr</Name><Title>CORINE Land Cover - France métropolitaine - 1990</Title><Abstract>Inventaire biophysique de l'occupation des sols en 1990 en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base de données CORINE Land Cover 1990, dite CLC 1990, a été réalisée à partir d'images satellitaires de l'année 1990 et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.91658725 41.07509675</ows:LowerCorner><ows:UpperCorner>9.99021512 51.17668018</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC00_FR=\"http://LANDCOVER.CLC00_FR\"><Name>LANDCOVER.CLC00_FR:clc00_fr</Name><Title>CORINE Land Cover - France métropolitaine - 2000</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2000 en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base de données CORINE Land Cover 2000, dite CLC 2000, a été réalisée à partir d'images satellitaires de l'année 2000 et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.91658725 41.07509675</ows:LowerCorner><ows:UpperCorner>9.99021512 51.17668018</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC0OR_FR=\"http://LANDCOVER.CLC0OR_FR\"><Name>LANDCOVER.CLC0OR_FR:clc00r_fr</Name><Title>CORINE Land Cover - France métropolitaine - 2000 révisée</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2000 en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base de données CORINE Land Cover 2000 révisée, dite CLC 2000 révisée, est une correction de CLC 2000 réalisée à partir d'images satellitaires de l'année 2000 et de données d'appui</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.91658725 41.07509675</ows:LowerCorner><ows:UpperCorner>9.99021512 51.17668018</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC06_FR=\"http://LANDCOVER.CLC06_FR\"><Name>LANDCOVER.CLC06_FR:clc06_fr</Name><Title>CORINE Land Cover - France métropolitaine - 2006</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2006 en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base de données CORINE Land Cover 2006, dite CLC 2006, a été réalisée à partir de CLC 2000 révisée et de la base des changements 2000-2006.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.91658725 41.07509675</ows:LowerCorner><ows:UpperCorner>9.99021512 51.17668018</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC06R_FR=\"http://LANDCOVER.CLC06R_FR\"><Name>LANDCOVER.CLC06R_FR:clc06r_fr</Name><Title>CORINE Land Cover - France métropolitaine - 2006 révisée</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2006 en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base de données CORINE Land Cover 2006 révisée, dite CLC 2006 révisée, est une correction de CLC 2006 réalisée à partir d'images satellitaires de l'année 2006 et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.91658725 41.07509675</ows:LowerCorner><ows:UpperCorner>9.99021512 51.17668018</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC12_FR=\"http://LANDCOVER.CLC12_FR\"><Name>LANDCOVER.CLC12_FR:clc12_fr</Name><Title>CORINE Land Cover - France métropolitaine - 2012</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2012 en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base de données CORINE Land Cover 2012, dite CLC 2012, a été réalisée à partir de CLC 2006 révisée et de la base des changements 2006-2012.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.91658725 41.07509675</ows:LowerCorner><ows:UpperCorner>9.99021512 51.17668018</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC12R_FR=\"http://LANDCOVER.CLC12R_FR\"><Name>LANDCOVER.CLC12R_FR:clc12r_fr</Name><Title>CORINE Land Cover - France métropolitaine - 2012 révisée</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2012 en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base de données CORINE Land Cover 2012 révisée, dite CLC 2012 révisée, est une correction de CLC 2012 réalisée à partir d'images satellitaires de l'année 2012 et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.92004256 41.02799728</ows:LowerCorner><ows:UpperCorner>11.09092433 51.07771878</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CLC18_FR=\"http://LANDCOVER.CLC18_FR\"><Name>LANDCOVER.CLC18_FR:clc18_fr</Name><Title>CORINE Land Cover - France métropolitaine - 2018</Title><Abstract>Inventaire biophysique de l'occupation des sols en 2018 en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base de données CORINE Land Cover 2018, dite CLC 2018, a été réalisée à partir de CLC 2012 révisée et de la base des changements 2012-2018.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.92004256 41.02799728</ows:LowerCorner><ows:UpperCorner>11.09092433 51.07771878</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CHA00_FR=\"http://LANDCOVER.CHA00_FR\"><Name>LANDCOVER.CHA00_FR:cha00_fr</Name><Title>CORINE Land Cover - France métropolitaine - Changements 1990-2000</Title><Abstract>Inventaire biophysique du changement d'occupation des sols entre 1990 et 2000 suivant la nomenclature CORINE Land Cover en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base des changements CORINE Land Cover 1990-2000, a été réalisée à partir de CLC 1990 et de CLC 2000.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.91658725 41.07509675</ows:LowerCorner><ows:UpperCorner>9.99021512 51.17668018</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CHA06_FR=\"http://LANDCOVER.CHA06_FR\"><Name>LANDCOVER.CHA06_FR:cha06_fr</Name><Title>CORINE Land Cover - France métropolitaine - Changements 2000-2006</Title><Abstract>Inventaire biophysique du changement d'occupation des sols entre 2000 et 2006 suivant la nomenclature CORINE Land Cover en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base des changements CORINE Land Cover 2000-2006, a été réalisée à partir d'images satellitaires des années 2000 et 2006 et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.91658725 41.07509675</ows:LowerCorner><ows:UpperCorner>9.99021512 51.17668018</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CHA12_FR=\"http://LANDCOVER.CHA12_FR\"><Name>LANDCOVER.CHA12_FR:cha12_fr</Name><Title>CORINE Land Cover - France métropolitaine - Changements 2006-2012</Title><Abstract>Inventaire biophysique du changement d'occupation des sols entre 2006 et 2012 suivant la nomenclature CORINE Land Cover en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base des changements CORINE Land Cover 2006-2012, a été réalisée à partir d'images satellitaires des années 2006 et 2012 et de données d'appui</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.91658725 41.07509675</ows:LowerCorner><ows:UpperCorner>9.99021512 51.17668018</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.CHA18_FR=\"http://LANDCOVER.CHA18_FR\"><Name>LANDCOVER.CHA18_FR:cha18_fr</Name><Title>CORINE Land Cover - France métropolitaine - Changements 2012-2018</Title><Abstract>Inventaire biophysique du changement d'occupation des sols entre 2012 et 2018 suivant la nomenclature CORINE Land Cover en 44 postes. CORINE Land Cover est une base de données d’occupation des sols produite dans le cadre du programme européen d’observation de la Terre Copernicus. Cet inventaire biophysique de l’occupation des terres fournit une information géographique de référence pour 39 États européens. La continuité du programme et la diffusion des données CORINE Land Cover sont pilotées par l'Agence européenne pour l'environnement. Le producteur pour la France est le Service de la donnée et des études statistiques du ministère chargé de l’écologie. L'utilisation de cette base de données permet des applications variées adaptées aux problématiques de l'environnement et à celles de l'aménagement du territoire : production cartographique, exploitation à des fins statistiques ou bien encore analyses géographiques en combinaison avec d'autres bases de données. Outil de connaissance et d'analyse, CORINE Land Cover apporte également une aide à la décision comme instrument de suivi, de surveillance et de gestion de l'environnement, des milieux naturels et plus généralement de l'aménagement de l'espace. La base des changements CORINE Land Cover 2012-2018, a été réalisée à partir d'images satellitaires des années 2012 et 2018 et de données d'appui.</Abstract><ows:Keywords><ows:Keyword>Occupation du sol</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.92004256 41.02799728</ows:LowerCorner><ows:UpperCorner>11.09092433 51.07771878</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:canton</Name><Title>Canton</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\"><Name>ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST:canton</Name><Title>Cantons</Title><Abstract>Cantons</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80983861776941 -21.389630761010356</ows:LowerCorner><ows:UpperCorner>55.83665387473344 51.088989440786094</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:Carhab_habitat=\"http://Carhab_habitat\"><Name>Carhab_habitat:habitat_carhab</Name><Title>Carhab_habitat</Title><Abstract>Habitats Carhab</Abstract><ows:Keywords><ows:Keyword>Carhab</ows:Keyword><ows:Keyword>Habitats</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-11.0 40.0</ows:LowerCorner><ows:UpperCorner>11.0 52.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:GEOGRAPHICALGRIDSYSTEM.DFCI=\"http://GEOGRAPHICALGRIDSYSTEM.DFCI\"><Name>GEOGRAPHICALGRIDSYSTEM.DFCI:carro_dfci_1x1_l93</Name><Title>Carroyages DFCI 1x1</Title><Abstract>Carroyages DFCI 1x1</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-6.065 41.15</ows:LowerCorner><ows:UpperCorner>10.38 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:GEOGRAPHICALGRIDSYSTEM.DFCI=\"http://GEOGRAPHICALGRIDSYSTEM.DFCI\"><Name>GEOGRAPHICALGRIDSYSTEM.DFCI:carro_dfci_2x2_l93</Name><Title>Carroyages DFCI 2x2</Title><Abstract>Carroyages DFCI 2x2</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-6.065 41.15</ows:LowerCorner><ows:UpperCorner>10.38 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:INSEE.FILOSOFI.INDICATORS=\"http://INSEE.FILOSOFI.INDICATORS\"><Name>INSEE.FILOSOFI.INDICATORS:carreaux_1km</Name><Title>Carroyages INSEE</Title><Abstract>Carroyages INSEE à 200 m, à 1 km et à la plus grande échelle diffusable </Abstract><ows:Keywords><ows:Keyword>Statistiques</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.23455255 -21.39086462</ows:LowerCorner><ows:UpperCorner>55.83464666 51.08790768</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:INSEE.FILOSOFI.INDICATORS=\"http://INSEE.FILOSOFI.INDICATORS\"><Name>INSEE.FILOSOFI.INDICATORS:carreaux_200m</Name><Title>Carroyages INSEE</Title><Abstract>Carroyages INSEE à 200 m, à 1 km et à la plus grande échelle diffusable </Abstract><ows:Keywords><ows:Keyword>Statistiques</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.23455255 -21.39086462</ows:LowerCorner><ows:UpperCorner>55.83464666 51.08790768</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LANDCOVER.FORESTINVENTORY.V2=\"http://LANDCOVER.FORESTINVENTORY.V2\"><Name>LANDCOVER.FORESTINVENTORY.V2:formation_vegetale</Name><Title>Carte forestière (v2 : 2006-)</Title><Abstract>Localisation de 32 types de formations végétales sur le territoire. </Abstract><ows:Keywords><ows:Keyword>BDFORET</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.52320944 41.32147402</ows:LowerCorner><ows:UpperCorner>9.65507376 50.9718316</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:chflieu_arrondissement_municipal</Name><Title>Chef-lieu d'arrondissement municipal</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:chflieu_commune</Name><Title>Chef-lieu de commune</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:chflieu_commune_associee_ou_deleguee</Name><Title>Chef-lieu de commune associée ou déléguée</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\"><Name>ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST:chflieu_arrondissement_municipal</Name><Title>Chefs-lieux d'arrondissement municipal</Title><Abstract>Chefs-lieux d'arrondissement municipal</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80983861776941 -21.389630761010356</ows:LowerCorner><ows:UpperCorner>55.83665387473344 51.088989440786094</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\"><Name>ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST:chflieu_commune</Name><Title>Chefs-lieux de commune</Title><Abstract>Chefs-lieux de commune</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80983861776941 -21.389630761010356</ows:LowerCorner><ows:UpperCorner>55.83665387473344 51.088989440786094</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LABELS.TOURISTIQUES=\"http://LABELS.TOURISTIQUES\"><Name>LABELS.TOURISTIQUES:clef_verte</Name><Title>Clef verte</Title><Abstract>Clef verte</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-151.875 -22.475</ows:LowerCorner><ows:UpperCorner>166.640625 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:collectivite_territoriale</Name><Title>Collectivité territoriale</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\"><Name>ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST:collectivite_territoriale</Name><Title>Collectivités territoriales</Title><Abstract>Collectivités territoriales</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80983861776941 -21.389630761010356</ows:LowerCorner><ows:UpperCorner>55.83665387473344 51.088989440786094</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:communes_972=\"http://communes_972\"><Name>communes_972:commune972</Name><Title>Com</Title><Abstract>Martinique</Abstract><ows:Keywords><ows:Keyword>Martinique</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::5490</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-150.0 0.0</ows:LowerCorner><ows:UpperCorner>0.0 55.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:commune</Name><Title>Commune</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:commune_associee_ou_deleguee</Name><Title>Commune associée ou déléguée</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:municipality</Name><Title>Communes</Title><Abstract>Emprise communale</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\"><Name>ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST:commune</Name><Title>Communes</Title><Abstract>Communes</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80983861776941 -21.389630761010356</ows:LowerCorner><ows:UpperCorner>55.83665387473344 51.088989440786094</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\"><Name>ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST:commune_associee_ou_deleguee</Name><Title>Communes associées ou déléguées</Title><Abstract>Communes associées ou déléguées</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80983861776941 -21.389630761010356</ows:LowerCorner><ows:UpperCorner>55.83665387473344 51.088989440786094</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LABELS.TOURISTIQUES=\"http://LABELS.TOURISTIQUES\"><Name>LABELS.TOURISTIQUES:communes_touristiques</Name><Title>Communes touristiques</Title><Abstract>Communes touristiques</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-151.875 -22.475</ows:LowerCorner><ows:UpperCorner>166.640625 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.MNHN.CDL.PARCELS=\"http://PROTECTEDAREAS.MNHN.CDL.PARCELS\"><Name>PROTECTEDAREAS.MNHN.CDL.PARCELS:cdl</Name><Title>Conservatoire du littoral - sites sous responsabilité du conservatoire</Title><Abstract>Les sites du conservatoire du littoral ont pour vocation la sauvegarde des espaces côtiers et lacustres. Leur accès au public est encouragé mais reste défini dans des limites compatibles avec la vulnérabilité de chaque site. Pour plus d'information : &lt;a href&gt;https://inpn.mnhn.fr/docs/map_pdf/cdl_f.pdf&lt;/a&gt;</Abstract><ows:Keywords><ows:Keyword>Littoral</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.14490145 -21.38398375</ows:LowerCorner><ows:UpperCorner>55.83443328 51.08708741</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.MNHN.CDL.PERIMETER=\"http://PROTECTEDAREAS.MNHN.CDL.PERIMETER\"><Name>PROTECTEDAREAS.MNHN.CDL.PERIMETER:perimetre_autorise</Name><Title>Conservatoire du littoral : Les périmètres autorisés</Title><Abstract>Les sites du conservatoire du littoral ont pour vocation la sauvegarde des espaces côtiers et lacustres. Leur accès au public est encouragé mais reste défini dans des limites compatibles avec la vulnérabilité de chaque site. 03-2022</Abstract><ows:Keywords><ows:Keyword>Littoral</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.193359375 -21.431132812</ows:LowerCorner><ows:UpperCorner>55.8984375 51.16890625</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:test_nl_bdtopo_la_ciotat=\"http://test_nl_bdtopo_la_ciotat\"><Name>test_nl_bdtopo_la_ciotat:commune</Name><Title>Contour communal</Title><Abstract>Contour communal de La Ciotat (Bouches-du-Rhône) issu de la BD Topo V3</Abstract><ows:Keywords><ows:Keyword>DATA NON OFFICIELLE</ows:Keyword><ows:Keyword>DEMO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>5.053164062 43.152705078</ows:LowerCorner><ows:UpperCorner>5.680722656 43.340776367</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:HAIES.BOCAGES=\"http://HAIES.BOCAGES\"><Name>HAIES.BOCAGES:haie</Name><Title>Couche nationale des haies issue du Dispositif de Suivi des Bocages</Title><Abstract>Des haies issues de la fusion du thème végétation de la BD TOPO et des SNA du RPG ont déjà été diffusées dans la cadre de la BD TOPO v3 : voir le descriptif de contenu de la BD TOPO v3 : https://bit.ly/3knUlkQ pages 169 et 170. Ces premières couches de haies départementales squelettisées ont été produites dans le cadre du programme CarHAB</Abstract><ows:Keywords><ows:Keyword>haie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15333395 -21.38972034</ows:LowerCorner><ows:UpperCorner>55.83675903 51.18890976</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ELEVATION.CONTOUR.LINE=\"http://ELEVATION.CONTOUR.LINE\"><Name>ELEVATION.CONTOUR.LINE:courbe</Name><Title>Courbes de niveau</Title><Abstract>Le produit « Courbes de niveau » est un modèle numérique de terrain sous forme de courbes de même altitude, appelées aussi « isoplèthes d’altitude », ou plus techniquement « isohypses ». Ces courbes permettent la description du relief français.</Abstract><ows:Keywords><ows:Keyword>courbes de niveau</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15340092 -21.3896732</ows:LowerCorner><ows:UpperCorner>55.83678733 51.12086835</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:HYDROGRAPHY.BCAE.LATEST=\"http://HYDROGRAPHY.BCAE.LATEST\"><Name>HYDROGRAPHY.BCAE.LATEST:bcae_cours_eau</Name><Title>Cours d'eau BCAE dernière édition</Title><Abstract>Le code rural et de la pêche maritime prévoit que les agriculteurs qui demandent des aides de la PAC implantent des bandes enherbées le long de certains cours d'eau au titre des bonnes conditions agricoles et environnementales. Cette carte est en vigueur du 1er janvier 2024 au 31 décembre 2024. Pour les départements non métropolitains, veuillez-vous référer aux arrêtés préfectoraux relatifs aux BCAE.</Abstract><ows:Keywords><ows:Keyword>BCAE</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.51063483 41.35555653</ows:LowerCorner><ows:UpperCorner>9.65203797 50.9519425</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:departement</Name><Title>Departement</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:doc_urba</Name><Title>Document d'urbanisme</Title><Abstract>Classe sémantique décrivant le document d'urbanisme</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:doc_urba_com</Name><Title>Document d'urbanisme</Title><Abstract>Classe sémantique décrivant le document d'urbanisme</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:document</Name><Title>Document d'urbanisme</Title><Abstract>Emprise du document d'urbanisme</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_scot=\"http://wfs_scot\"><Name>wfs_scot:doc_urba</Name><Title>Document d'urbanisme</Title><Abstract>Classe sémantique décrivant le Schéma de Cohérence Territorial</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.5234375 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.546875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_scot=\"http://wfs_scot\"><Name>wfs_scot:doc_urba_com</Name><Title>Document d'urbanisme</Title><Abstract>Relations entre le Schéma de Cohérence Territorial et les communes auxquelles il s'applique</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.5234375 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.546875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BAN.DATA.GOUV=\"http://BAN.DATA.GOUV\"><Name>BAN.DATA.GOUV:ban</Name><Title>Données Base Adresse Nationale</Title><Abstract>Données Base Adresse Nationale</Abstract><ows:Keywords><ows:Keyword>adresse</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-149.765625 -22.475</ows:LowerCorner><ows:UpperCorner>166.9921875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.HEATMAP=\"http://CADASTRALPARCELS.HEATMAP\"><Name>CADASTRALPARCELS.HEATMAP:parcelle_wld</Name><Title>Décalage de la représentation cadastrale</Title><Abstract>Cartographie des décalages entre les données BD Parcellaire et Parcellaire Express</Abstract><ows:Keywords><ows:Keyword>Parcellaire Express</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.14076796 -4.46233984</ows:LowerCorner><ows:UpperCorner>9.55990504 64.15154681</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:AOC-VITICOLES=\"http://AOC-VITICOLES\"><Name>AOC-VITICOLES:aire_parcellaire</Name><Title>Délimitation parcellaire AOC viticole</Title><Abstract>Selon les règlements européens n°110/2008 du 15 janvier 2008, n°1151/2012 du 21 novembre 2012 et n°1308/2013 de l’OCM , le cahier des charges des appellations définit l’aire géographique. Le terme de « délimitation parcellaire » désigne une aire qui repose sur les limites administratives du cadastre (les parcelles) et dont le maillage suffisamment fin permet de tenir compte de variations très localisées des éléments du milieu physique. Elle correspond à l'aire de production de la matière première. Elle est incluse dans l'aire géographique. Données produites par l'Institut National des Origines et la Qualité (INAO)</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-2.111875 41.31265625</ows:LowerCorner><ows:UpperCorner>9.589375 49.608125</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:DELMAR_BDD_WFS=\"http://DELMAR_BDD_WFS\"><Name>DELMAR_BDD_WFS:au_maritimeboundary_agreedmaritimeboundary</Name><Title>Délimitations maritimes établies par accord</Title><Abstract>Délimitations maritimes établies par un accord entre Etats ou issues d’une décision d’instance juridique internationale.</Abstract><ows:Keywords><ows:Keyword>Délimitations maritimes</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -54.0</ows:LowerCorner><ows:UpperCorner>180.0 52.6</ows:UpperCorner></ows:WGS84BoundingBox><MetadataURL xlink:href=\"https://services.data.shom.fr/geonetwork/srv/fre/catalog.search#/metadata/BDML_DELMAR.xml\"/></FeatureType><FeatureType xmlns:DELMAR_BDD_WFS=\"http://DELMAR_BDD_WFS\"><Name>DELMAR_BDD_WFS:au_maritimeboundary_nonagreedmaritimeboundary</Name><Title>Délimitations revendiquées unilatéralement par la France en l’absence d’accord</Title><Abstract>Délimitations revendiquées unilatéralement par la France en l’absence d’accord.</Abstract><ows:Keywords><ows:Keyword>Délimitations maritimes</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -54.0</ows:LowerCorner><ows:UpperCorner>180.0 52.6</ows:UpperCorner></ows:WGS84BoundingBox><MetadataURL xlink:href=\"https://services.data.shom.fr/geonetwork/srv/fre/catalog.search#/metadata/BDML_DELMAR.xml\"/></FeatureType><FeatureType xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\"><Name>ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST:departement</Name><Title>Départements</Title><Abstract>Départements</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80983861776941 -21.389630761010356</ows:LowerCorner><ows:UpperCorner>55.83665387473344 51.088989440786094</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\"><Name>ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST:epci</Name><Title>EPCI</Title><Abstract>EPCI</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80983861776941 -21.389630761010356</ows:LowerCorner><ows:UpperCorner>55.83665387473344 51.088989440786094</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:epci</Name><Title>EPCI</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:POI.CULTURE_LOISIRS=\"http://POI.CULTURE_LOISIRS\"><Name>POI.CULTURE_LOISIRS:pai_culture_et_loisirs</Name><Title>Etablissements de culture et de loisirs</Title><Abstract>Etablissement ou lieu spécialement aménagé pour une activité culturelle, touristique ou de loisirs.&lt;/br&gt; Source : IGN BD Topo 2017</Abstract><ows:Keywords><ows:Keyword>Histoire et patrimoine</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:SANTE_BDD_SYMBO_FXX_WM_20171227=\"http://SANTE_BDD_SYMBO_FXX_WM_20171227\"><Name>SANTE_BDD_SYMBO_FXX_WM_20171227:hopitaux</Name><Title>Etablissements de santé</Title><Abstract>Établissement thermal ou de type hospitalier. Sources : IGN novembre 2017, FINESS octobre 2017</Abstract><ows:Keywords><ows:Keyword>Santé</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.08385449 -21.37996146</ows:LowerCorner><ows:UpperCorner>55.71054065 51.07170898</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:UTILIYANDGOVERNMENTALSERVICES.IGN.POI.SANTE=\"http://UTILIYANDGOVERNMENTALSERVICES.IGN.POI.SANTE\"><Name>UTILIYANDGOVERNMENTALSERVICES.IGN.POI.SANTE:hopitaux</Name><Title>Etablissements de santé</Title><Abstract>Établissement thermal ou de type hospitalier. Sources : IGN novembre 2017, FINESS octobre 2017</Abstract><ows:Keywords><ows:Keyword>Santé</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.08385449 -21.37996146</ows:LowerCorner><ows:UpperCorner>55.71054065 51.07170898</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:COMMUNES.EPCISANSFISCALITEPROPRE=\"http://COMMUNES.EPCISANSFISCALITEPROPRE\"><Name>COMMUNES.EPCISANSFISCALITEPROPRE:intercomm_groupement</Name><Title>Etablissements publics de coopération intercommunale sans fiscalité propre</Title><Abstract>Les établissements publics de coopération intercommunale (EPCI) sont des regroupements de communes ayant pour objet l'élaboration de « projets communs de développement au sein de périmètres de solidarité ». Ils sont soumis à des règles communes, homogènes et comparables à celles de collectivités locales. Les EPCI sans fiscalité propre sont les Syndicats Intercommunaux à Vocation Unique (SIVU), les Syndicats Intercommunaux à Vocation Multiple (SIVOM), les Syndicats Mixtes fermés (SM fermés) et les Syndicats Mixtes ouverts (SM ouverts). Source des données : Ministère de l'Intérieur juillet 2015, IGN BD Topo 2015</Abstract><ows:Keywords><ows:Keyword>Etat et collectivités</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.14127657 41.33355569</ows:LowerCorner><ows:UpperCorner>9.56009361 51.08900123</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:habillage_txt</Name><Title>Etiquette ponctuelle de l’habillage du plan</Title><Abstract>Étiquette ponctuelle portée sur le document d'urbanisme pour l’habillage du plan</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:UTILIYANDGOVERNMENTALSERVICES.IGN.POI.GARES=\"http://UTILIYANDGOVERNMENTALSERVICES.IGN.POI.GARES\"><Name>UTILIYANDGOVERNMENTALSERVICES.IGN.POI.GARES:gares</Name><Title>Gares</Title><Abstract>Les gares permettent le débarquement et l'embarquement de passagers dans des trains ou des autocars. Les gares peuvent avoir plusieurs accès donnant dans différentes voiries. On inclut également les gares et points d'embarquement des remontées mécaniques de montagne.</Abstract><ows:Keywords><ows:Keyword>Transports</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.08590976 -21.37873339</ows:LowerCorner><ows:UpperCorner>55.71007054 51.0306278</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:GARES_BDD_FXX_WM_20171227=\"http://GARES_BDD_FXX_WM_20171227\"><Name>GARES_BDD_FXX_WM_20171227:gares</Name><Title>Gares</Title><Abstract>Les gares permettent le débarquement et l'embarquement de passagers dans des trains ou des autocars. Les gares peuvent avoir plusieurs accès donnant dans différentes voiries. On inclut également les gares et points d'embarquement des remontées mécaniques de montagne.</Abstract><ows:Keywords><ows:Keyword>Transports</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.08590976 -21.37873339</ows:LowerCorner><ows:UpperCorner>55.71007054 51.0306278</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE-MOSAIQUAGE\"><Name>ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE-MOSAIQUAGE:graphe_bdortho</Name><Title>Graphe de mosaiquage France Entière de la BDORTHO.</Title><Abstract>Graphe de mosaiquage France Entière de la BDORTHO.</Abstract><ows:Keywords><ows:Keyword>Graphe</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-178.18541496 -21.42730308</ows:LowerCorner><ows:UpperCorner>55.85384065 51.11183578</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ORTHOIMAGERY.ORTHO-SAT.SPOT.2014.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHO-SAT.SPOT.2014.GRAPHE-MOSAIQUAGE\"><Name>ORTHOIMAGERY.ORTHO-SAT.SPOT.2014.GRAPHE-MOSAIQUAGE:france_2014</Name><Title>Graphe de mosaiquage de la couche SPOT 6 - 2014</Title><Abstract>Graphe de mosaiquage de la couche SPOT 6 - 2014</Abstract><ows:Keywords><ows:Keyword>Images satellitaires</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.18839164 41.32320079</ows:LowerCorner><ows:UpperCorner>9.60438459 51.11164522</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ORTHOIMAGERY.ORTHO-SAT.SPOT.2017.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHO-SAT.SPOT.2017.GRAPHE-MOSAIQUAGE\"><Name>ORTHOIMAGERY.ORTHO-SAT.SPOT.2017.GRAPHE-MOSAIQUAGE:france_2017</Name><Title>Graphe de mosaiquage de la couche SPOT 6 - 2017</Title><Abstract>Graphe de mosaiquage de la couche SPOT 6 - 2017</Abstract><ows:Keywords><ows:Keyword>Images satellitaires</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.85105703 -21.40952982</ows:LowerCorner><ows:UpperCorner>55.85418348 51.11178865</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ORTHOIMAGERY.ORTHO-SAT.SPOT.2015.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHO-SAT.SPOT.2015.GRAPHE-MOSAIQUAGE\"><Name>ORTHOIMAGERY.ORTHO-SAT.SPOT.2015.GRAPHE-MOSAIQUAGE:france_2015</Name><Title>Graphe de mosaiquage de la couche SPOT 6-7 - 2015</Title><Abstract>Graphe de mosaiquage de la couche SPOT 6-7 - 2015</Abstract><ows:Keywords><ows:Keyword>Images satellitaires</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.19259617 41.31611385</ows:LowerCorner><ows:UpperCorner>9.64488496 51.11178838</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ORTHOIMAGERY.ORTHO-SAT.SPOT.2016.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHO-SAT.SPOT.2016.GRAPHE-MOSAIQUAGE\"><Name>ORTHOIMAGERY.ORTHO-SAT.SPOT.2016.GRAPHE-MOSAIQUAGE:france_2016</Name><Title>Graphe de mosaiquage de la couche SPOT 6-7 - 2016</Title><Abstract>Graphe de mosaiquage de la couche SPOT 6-7 - 2016</Abstract><ows:Keywords><ows:Keyword>Images satellitaires</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.19259653 41.32801547</ows:LowerCorner><ows:UpperCorner>9.61475877 51.11178851</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ORTHOIMAGERY.ORTHOPHOTOS.1950-1965.GRAPHE-MOSAIQUAGE=\"http://ORTHOIMAGERY.ORTHOPHOTOS.1950-1965.GRAPHE-MOSAIQUAGE\"><Name>ORTHOIMAGERY.ORTHOPHOTOS.1950-1965.GRAPHE-MOSAIQUAGE:graphe</Name><Title>Graphe de mosaiquage de la couche photographies aériennes historiques 1950-1965</Title><Abstract>Graphe de mosaiquage de la couche photographies aériennes historiques 1950-1965.</Abstract><ows:Keywords><ows:Keyword>BDORTHOHISTORIQUE</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.16065723 -21.39989736</ows:LowerCorner><ows:UpperCorner>55.84425655 51.08932742</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2000-2005=\"http://ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2000-2005\"><Name>ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2000-2005:graphe_bdortho</Name><Title>Graphe de mosaïquage BDORTHO 2000-2005</Title><Abstract>Graphe de mosaïquage BDORTHO 2000-2005</Abstract><ows:Keywords><ows:Keyword>Graphe</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-66.15805146 -21.39139475</ows:LowerCorner><ows:UpperCorner>55.85384065 51.10341491</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2006-2010=\"http://ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2006-2010\"><Name>ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2006-2010:graphe_bdortho</Name><Title>Graphe de mosaïquage BDORTHO 2006-2010 </Title><Abstract>graphe bdortho millesimees</Abstract><ows:Keywords><ows:Keyword>Graphe</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-66.49159691 -21.42730308</ows:LowerCorner><ows:UpperCorner>55.84456069 51.09371245</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2011-2015=\"http://ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2011-2015\"><Name>ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2011-2015:graphe_bdortho</Name><Title>Graphe de mosaïquage BDORTHO 2011-2015</Title><Abstract>Graphe de mosaïquage BDORTHO 2011-2015</Abstract><ows:Keywords><ows:Keyword>Graphe</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.16551154 -21.39990125</ows:LowerCorner><ows:UpperCorner>55.8442806 51.09371233</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2016-2020=\"http://ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2016-2020\"><Name>ORTHOIMAGERY.ORTHOPHOTOS.GRAPHE.2016-2020:graphe_bdortho</Name><Title>Graphe de mosaïquage BDORTHO 2016-2020</Title><Abstract>Graphe de mosaïquage BDORTHO 2016-2020</Abstract><ows:Keywords><ows:Keyword>Graphe</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.17011235 -21.3999015</ows:LowerCorner><ows:UpperCorner>55.8442806 51.11183578</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.GRAPHE=\"http://CADASTRALPARCELS.GRAPHE\"><Name>CADASTRALPARCELS.GRAPHE:graphe</Name><Title>Graphe de mosaïquage des parcelles cadastrales</Title><Abstract>Graphe de mosaïquage des parcelles cadastrales</Abstract><ows:Keywords><ows:Keyword>Parcelles cadastrales</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.809585 -21.38984989</ows:LowerCorner><ows:UpperCorner>55.8366799 51.08900031</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN25.GRAPHE-MOSAIQUAGE=\"http://GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN25.GRAPHE-MOSAIQUAGE\"><Name>GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN25.GRAPHE-MOSAIQUAGE:graphe_scan25</Name><Title>Graphe de mosaïquage du produit SCAN25</Title><Abstract>Le graphe de mosaïquage du produit SCAN25 fournit le zonage utilisé pour la mise à jour des données SCAN25 ainsi que différentes métadonnées. 07-2023</Abstract><ows:Keywords><ows:Keyword>Graphe</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-178.2421875 -21.597265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.16890625</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN50.1950.GRAPHE=\"http://GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN50.1950.GRAPHE\"><Name>GEOGRAPHICALGRIDSYSTEMS.MAPS.SCAN50.1950.GRAPHE:ta_france_cartes_50k_1950_date_wm</Name><Title>Graphe de raccord du SCAN50 Historique de 1950</Title><Abstract>Graphe de raccord du SCAN50 produit par l'IGN en 1950</Abstract><ows:Keywords><ows:Keyword>Graphe</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.40382678 41.22005172</ows:LowerCorner><ows:UpperCorner>9.71705594 51.12127705</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:espace_revendeurs=\"http://espace_revendeurs\"><Name>espace_revendeurs:grid</Name><Title>Grille</Title><Abstract>Grille</Abstract><ows:Keywords><ows:Keyword>Espace revendeurs</ows:Keyword><ows:Keyword>Grille</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-175.0 -75.0</ows:LowerCorner><ows:UpperCorner>175.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:espace_revendeurs_beta=\"http://espace_revendeurs_beta\"><Name>espace_revendeurs_beta:grid</Name><Title>Grille (Bêta)</Title><Abstract>Grille</Abstract><ows:Keywords><ows:Keyword>Espace revendeurs</ows:Keyword><ows:Keyword>Grille</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-175.0 -75.0</ows:LowerCorner><ows:UpperCorner>175.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_sup=\"http://wfs_sup\"><Name>wfs_sup:generateur_sup_l</Name><Title>Générateur de servitude d'utilité publique</Title><Abstract>Générateurs linéaires liés aux servitudes</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -49.86640625</ows:LowerCorner><ows:UpperCorner>78.046875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_sup=\"http://wfs_sup\"><Name>wfs_sup:generateur_sup_p</Name><Title>Générateur de servitude d'utilité publique</Title><Abstract>Générateurs ponctuels liés aux servitudes</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -49.86640625</ows:LowerCorner><ows:UpperCorner>78.046875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_sup=\"http://wfs_sup\"><Name>wfs_sup:generateur_sup_s</Name><Title>Générateur de servitude d'utilité publique</Title><Abstract>Générateurs surfaciques liés aux servitudes</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -49.86640625</ows:LowerCorner><ows:UpperCorner>78.046875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.GP=\"http://PROTECTEDAREAS.GP\"><Name>PROTECTEDAREAS.GP:gp</Name><Title>Géoparcs</Title><Abstract>Les géoparcs mondiaux UNESCO sont des espaces géographiques unifiés, où les sites et paysages de portée géologique internationale sont gérés selon un concept global de protection, d’éducation et de développement durable</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>1.45301356 43.6587189</ows:LowerCorner><ows:UpperCorner>6.86481915 46.40814591</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:habillage_lin</Name><Title>Habillages linéaires</Title><Abstract>Objet linéaire indicatif porté sur le document d'urbanisme pour l'habillage du plan</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:habillage_pct</Name><Title>Habillages ponctuels</Title><Abstract>Objet ponctuel indicatif porté sur le document d'urbanisme pour l'habillage du plan</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:habillage_surf</Name><Title>Habillages surfaciques</Title><Abstract>Objet surfacique indicatif porté sur le document d'urbanisme pour l'habillage du plan</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:STATISTICALUNITS.IRISGE=\"http://STATISTICALUNITS.IRISGE\"><Name>STATISTICALUNITS.IRISGE:iris_ge</Name><Title>IRIS Grande Echelle</Title><Abstract>Contours géométriques des IRIS de l'INSEE à grande échelle toute la France 2022</Abstract><ows:Keywords><ows:Keyword>Statistiques</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.1533205 -21.3896307</ows:LowerCorner><ows:UpperCorner>55.8366539 51.0889894</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:info_lin</Name><Title>Informations linéaires</Title><Abstract>Périmètre linéaire à reporter à titre d’information</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:info_pct</Name><Title>Informations ponctuelles</Title><Abstract>Périmètre ponctuel à reporter à titre d’information</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:info_surf</Name><Title>Informations surfaciques</Title><Abstract>Périmètre surfacique à reporter à titre d’information</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.INPG=\"http://PROTECTEDAREAS.INPG\"><Name>PROTECTEDAREAS.INPG:inpg</Name><Title>Inventaire National du Patrimoine Géologique (INPG)</Title><Abstract>L'Inventaire National du Patrimoine Géologique (INPG) est un programme initié en 2007 de connaissance géologique du territoire métropolitain et outre-mer, dans lequel chaque site géologique naturel est renseigné sur une application web dédiée (InvenTerre) de façon textuelle avec une évaluation patrimoniale et une cartographie associées.</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.79004303 -21.38412564</ows:LowerCorner><ows:UpperCorner>55.83694573 51.09254226</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:INPE=\"http://INPE\"><Name>INPE:inpe</Name><Title>Inventaire national des plans d'eau</Title><Abstract>Inventaire national des plans d'eau</Abstract><ows:Keywords><ows:Keyword>National</ows:Keyword><ows:Keyword>Plan d'eau</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:DELMAR_BDD_WFS=\"http://DELMAR_BDD_WFS\"><Name>DELMAR_BDD_WFS:au_baseline</Name><Title>Lignes de base droite</Title><Abstract>Lignes de base droite françaises.</Abstract><ows:Keywords><ows:Keyword>Délimitations maritimes</ows:Keyword><ows:Keyword>Lignes de bases droites</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -54.0</ows:LowerCorner><ows:UpperCorner>180.0 52.6</ows:UpperCorner></ows:WGS84BoundingBox><MetadataURL xlink:href=\"https://services.data.shom.fr/geonetwork/srv/fre/catalog.search#/metadata/BDML_DELMAR.xml\"/></FeatureType><FeatureType xmlns:DELMAR_BDD_WFS=\"http://DELMAR_BDD_WFS\"><Name>DELMAR_BDD_WFS:au_maritimeboundary_territorialsea</Name><Title>Limite de la mer territoriale</Title><Abstract>Limites de la mer territoriale française.</Abstract><ows:Keywords><ows:Keyword>Délimitations maritimes</ows:Keyword><ows:Keyword>Mer territoriale</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -54.0</ows:LowerCorner><ows:UpperCorner>180.0 52.6</ows:UpperCorner></ows:WGS84BoundingBox><MetadataURL xlink:href=\"https://services.data.shom.fr/geonetwork/srv/fre/catalog.search#/metadata/BDML_DELMAR.xml\"/></FeatureType><FeatureType xmlns:DELMAR_BDD_WFS=\"http://DELMAR_BDD_WFS\"><Name>DELMAR_BDD_WFS:au_maritimeboundary_contiguouszone</Name><Title>Limite de la zone contigüe</Title><Abstract>Limites de la zone contigue française.</Abstract><ows:Keywords><ows:Keyword>Zone contigue</ows:Keyword><ows:Keyword>Délimitations maritimes</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -54.0</ows:LowerCorner><ows:UpperCorner>180.0 52.6</ows:UpperCorner></ows:WGS84BoundingBox><MetadataURL xlink:href=\"https://services.data.shom.fr/geonetwork/srv/fre/catalog.search#/metadata/BDML_DELMAR.xml\"/></FeatureType><FeatureType xmlns:DELMAR_BDD_WFS=\"http://DELMAR_BDD_WFS\"><Name>DELMAR_BDD_WFS:au_maritimeboundary_continentalshelf</Name><Title>Limite du plateau continental</Title><Abstract>Limites du plateau continental française.</Abstract><ows:Keywords><ows:Keyword>Délimitations maritimes</ows:Keyword><ows:Keyword>Plateau continental</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -54.0</ows:LowerCorner><ows:UpperCorner>180.0 52.6</ows:UpperCorner></ows:WGS84BoundingBox><MetadataURL xlink:href=\"https://services.data.shom.fr/geonetwork/srv/fre/catalog.search#/metadata/BDML_DELMAR.xml\"/></FeatureType><FeatureType xmlns:DELMAR_BDD_WFS=\"http://DELMAR_BDD_WFS\"><Name>DELMAR_BDD_WFS:au_maritimeboundary_economicexclusivezone</Name><Title>Limite extérieure de la zone économique exclusive</Title><Abstract>Limites extérieures de la zone économique exclusive française.</Abstract><ows:Keywords><ows:Keyword>Délimitations maritimes</ows:Keyword><ows:Keyword>ZEE</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -54.0</ows:LowerCorner><ows:UpperCorner>180.0 52.6</ows:UpperCorner></ows:WGS84BoundingBox><MetadataURL xlink:href=\"https://services.data.shom.fr/geonetwork/srv/fre/catalog.search#/metadata/BDML_DELMAR.xml\"/></FeatureType><FeatureType xmlns:ADMINEXPRESS_COG_2018_CARTO=\"http://ADMINEXPRESS_COG_2018_CARTO\"><Name>ADMINEXPRESS_COG_2018_CARTO:arrondissement_departemental_carto</Name><Title>Limites administrative COG Carto 2018</Title><Abstract>Limites administrative 2018 Carto conforme au Code Officiel Géographique</Abstract><ows:Keywords><ows:Keyword>Unités adminstratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.809585 -21.38984989</ows:LowerCorner><ows:UpperCorner>55.8366799 51.08900031</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS_COG_2018_CARTO=\"http://ADMINEXPRESS_COG_2018_CARTO\"><Name>ADMINEXPRESS_COG_2018_CARTO:commune_carto</Name><Title>Limites administrative COG Carto 2018</Title><Abstract>Limites administrative 2018 Carto conforme au Code Officiel Géographique</Abstract><ows:Keywords><ows:Keyword>Unités adminstratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.809585 -21.38984989</ows:LowerCorner><ows:UpperCorner>55.8366799 51.08900031</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS_COG_2018_CARTO=\"http://ADMINEXPRESS_COG_2018_CARTO\"><Name>ADMINEXPRESS_COG_2018_CARTO:departement_carto</Name><Title>Limites administrative COG Carto 2018</Title><Abstract>Limites administrative 2018 Carto conforme au Code Officiel Géographique</Abstract><ows:Keywords><ows:Keyword>Unités adminstratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.809585 -21.38984989</ows:LowerCorner><ows:UpperCorner>55.8366799 51.08900031</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS_COG_2018_CARTO=\"http://ADMINEXPRESS_COG_2018_CARTO\"><Name>ADMINEXPRESS_COG_2018_CARTO:epci_carto</Name><Title>Limites administrative COG Carto 2018</Title><Abstract>Limites administrative 2018 Carto conforme au Code Officiel Géographique</Abstract><ows:Keywords><ows:Keyword>Unités adminstratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.809585 -21.38984989</ows:LowerCorner><ows:UpperCorner>55.8366799 51.08900031</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMINEXPRESS_COG_2018_CARTO=\"http://ADMINEXPRESS_COG_2018_CARTO\"><Name>ADMINEXPRESS_COG_2018_CARTO:region_carto</Name><Title>Limites administrative COG Carto 2018</Title><Abstract>Limites administrative 2018 Carto conforme au Code Officiel Géographique</Abstract><ows:Keywords><ows:Keyword>Unités adminstratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.809585 -21.38984989</ows:LowerCorner><ows:UpperCorner>55.8366799 51.08900031</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LOT.CHASSE=\"http://LOT.CHASSE\"><Name>LOT.CHASSE:lot_chasse</Name><Title>Lot de chasse</Title><Abstract>Lot de chasse</Abstract><ows:Keywords><ows:Keyword>Chasse</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ELEVATIONGRIDCOVERAGE.HIGHRES.QUALITY=\"http://ELEVATIONGRIDCOVERAGE.HIGHRES.QUALITY\"><Name>ELEVATIONGRIDCOVERAGE.HIGHRES.QUALITY:source_fra</Name><Title>Masque de source du RGE Alti</Title><Abstract>Informations sur la précision du RGEAlti.</Abstract><ows:Keywords><ows:Keyword>Altitude</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.18904211 -21.42727734</ows:LowerCorner><ows:UpperCorner>55.84453236 51.12965159</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:MESURES_COMPENSATOIRES=\"http://MESURES_COMPENSATOIRES\"><Name>MESURES_COMPENSATOIRES:emprises_commune</Name><Title>Mesures compensatoires 03-2023</Title><Abstract>Carte des mesures compensatoires des atteintes à la biodiversité. Une mesure compensatoire d’atteinte à la biodiversité n'intervient que sur l'impact résiduel d'un projet d'aménagement, lorsque toutes les mesures envisageables ont été mises en œuvre pour éviter puis réduire les impacts négatifs sur la biodiversité. Elle vise à offrir une contrepartie positive à un impact dommageable non réductible provoqué par un projet, de façon à maintenir la biodiversité dans un état équivalent ou meilleur à celui observé avant sa réalisation.</Abstract><ows:Keywords><ows:Keyword>Mesures compensatoires</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-53.77737151 -21.37632972</ows:LowerCorner><ows:UpperCorner>55.70531774 51.04258551</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:MESURES_COMPENSATOIRES=\"http://MESURES_COMPENSATOIRES\"><Name>MESURES_COMPENSATOIRES:emprises_lineaires</Name><Title>Mesures compensatoires 03-2023</Title><Abstract>Carte des mesures compensatoires des atteintes à la biodiversité. Une mesure compensatoire d’atteinte à la biodiversité n'intervient que sur l'impact résiduel d'un projet d'aménagement, lorsque toutes les mesures envisageables ont été mises en œuvre pour éviter puis réduire les impacts négatifs sur la biodiversité. Elle vise à offrir une contrepartie positive à un impact dommageable non réductible provoqué par un projet, de façon à maintenir la biodiversité dans un état équivalent ou meilleur à celui observé avant sa réalisation.</Abstract><ows:Keywords><ows:Keyword>Mesures compensatoires</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-53.77737151 -21.37632972</ows:LowerCorner><ows:UpperCorner>55.70531774 51.04258551</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:MESURES_COMPENSATOIRES=\"http://MESURES_COMPENSATOIRES\"><Name>MESURES_COMPENSATOIRES:emprises_polygones</Name><Title>Mesures compensatoires 03-2023</Title><Abstract>Carte des mesures compensatoires des atteintes à la biodiversité. Une mesure compensatoire d’atteinte à la biodiversité n'intervient que sur l'impact résiduel d'un projet d'aménagement, lorsque toutes les mesures envisageables ont été mises en œuvre pour éviter puis réduire les impacts négatifs sur la biodiversité. Elle vise à offrir une contrepartie positive à un impact dommageable non réductible provoqué par un projet, de façon à maintenir la biodiversité dans un état équivalent ou meilleur à celui observé avant sa réalisation.</Abstract><ows:Keywords><ows:Keyword>Mesures compensatoires</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-53.77737151 -21.37632972</ows:LowerCorner><ows:UpperCorner>55.70531774 51.04258551</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:MESURES_COMPENSATOIRES=\"http://MESURES_COMPENSATOIRES\"><Name>MESURES_COMPENSATOIRES:emprises_ponctuelles</Name><Title>Mesures compensatoires 03-2023</Title><Abstract>Carte des mesures compensatoires des atteintes à la biodiversité. Une mesure compensatoire d’atteinte à la biodiversité n'intervient que sur l'impact résiduel d'un projet d'aménagement, lorsque toutes les mesures envisageables ont été mises en œuvre pour éviter puis réduire les impacts négatifs sur la biodiversité. Elle vise à offrir une contrepartie positive à un impact dommageable non réductible provoqué par un projet, de façon à maintenir la biodiversité dans un état équivalent ou meilleur à celui observé avant sa réalisation.</Abstract><ows:Keywords><ows:Keyword>Mesures compensatoires</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-53.77737151 -21.37632972</ows:LowerCorner><ows:UpperCorner>55.70531774 51.04258551</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:OCS-BFC_2017_BDD_WLD_WM_WFS_23-07-2021=\"http://OCS-BFC_2017_BDD_WLD_WM_WFS_23-07-2021\"><Name>OCS-BFC_2017_BDD_WLD_WM_WFS_23-07-2021:communes</Name><Title>OCS BFC 2017</Title><Abstract>OCS Bourgogne Franche Comté 2017</Abstract><ows:Keywords><ows:Keyword>OCS</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.92330526 46.83498911</ows:LowerCorner><ows:UpperCorner>3.55177494 47.32222491</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:OCS-BFC_2017_BDD_WLD_WM_WFS_23-07-2021=\"http://OCS-BFC_2017_BDD_WLD_WM_WFS_23-07-2021\"><Name>OCS-BFC_2017_BDD_WLD_WM_WFS_23-07-2021:indicateur9_2017</Name><Title>OCS BFC 2017</Title><Abstract>OCS Bourgogne Franche Comté 2017</Abstract><ows:Keywords><ows:Keyword>OCS</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.92330526 46.83498911</ows:LowerCorner><ows:UpperCorner>3.55177494 47.32222491</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:OCS-BFC_2017_BDD_WLD_WM_WFS_23-07-2021=\"http://OCS-BFC_2017_BDD_WLD_WM_WFS_23-07-2021\"><Name>OCS-BFC_2017_BDD_WLD_WM_WFS_23-07-2021:ocsge_58_2017_man_20p</Name><Title>OCS BFC 2017</Title><Abstract>OCS Bourgogne Franche Comté 2017</Abstract><ows:Keywords><ows:Keyword>OCS</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>2.92330526 46.83498911</ows:LowerCorner><ows:UpperCorner>3.55177494 47.32222491</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_sup=\"http://wfs_sup\"><Name>wfs_sup:gestionnaire_sup</Name><Title>Organisme gestionnaire ou organisme ressource de la servitude</Title><Abstract>Gestionnaires de servitude d'utilité publique</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -49.86640625</ows:LowerCorner><ows:UpperCorner>78.046875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.PARCELLAIRE_EXPRESS=\"http://CADASTRALPARCELS.PARCELLAIRE_EXPRESS\"><Name>CADASTRALPARCELS.PARCELLAIRE_EXPRESS:arrondissement</Name><Title>PCI Vecteur : Arrondissements</Title><Abstract>Arrondissements avril 2023</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.PARCELLAIRE_EXPRESS=\"http://CADASTRALPARCELS.PARCELLAIRE_EXPRESS\"><Name>CADASTRALPARCELS.PARCELLAIRE_EXPRESS:borne_limite_propriete</Name><Title>PCI Vecteur : Bornes de limite de propriété</Title><Abstract>Bornes de limite de propriété avril 2023</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.PARCELLAIRE_EXPRESS=\"http://CADASTRALPARCELS.PARCELLAIRE_EXPRESS\"><Name>CADASTRALPARCELS.PARCELLAIRE_EXPRESS:batiment</Name><Title>PCI Vecteur : Bâtiments</Title><Abstract>Bâtiments avril 2023</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.PARCELLAIRE_EXPRESS=\"http://CADASTRALPARCELS.PARCELLAIRE_EXPRESS\"><Name>CADASTRALPARCELS.PARCELLAIRE_EXPRESS:commune</Name><Title>PCI Vecteur : Communes</Title><Abstract>Communes avril 2023</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.PARCELLAIRE_EXPRESS=\"http://CADASTRALPARCELS.PARCELLAIRE_EXPRESS\"><Name>CADASTRALPARCELS.PARCELLAIRE_EXPRESS:feuille</Name><Title>PCI Vecteur : Feuilles</Title><Abstract>Feuilles avril 2023</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.PARCELLAIRE_EXPRESS=\"http://CADASTRALPARCELS.PARCELLAIRE_EXPRESS\"><Name>CADASTRALPARCELS.PARCELLAIRE_EXPRESS:borne_parcelle</Name><Title>PCI Vecteur : Lien bornes parcelles</Title><Abstract>Lien bornes parcelles avril 2023</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.PARCELLAIRE_EXPRESS=\"http://CADASTRALPARCELS.PARCELLAIRE_EXPRESS\"><Name>CADASTRALPARCELS.PARCELLAIRE_EXPRESS:localisant</Name><Title>PCI Vecteur : Localisants</Title><Abstract>Localisants avril 2023</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.PARCELLAIRE_EXPRESS=\"http://CADASTRALPARCELS.PARCELLAIRE_EXPRESS\"><Name>CADASTRALPARCELS.PARCELLAIRE_EXPRESS:parcelle</Name><Title>PCI Vecteur : Parcelles</Title><Abstract>Parcelles avril 2023</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.PARCELLAIRE_EXPRESS=\"http://CADASTRALPARCELS.PARCELLAIRE_EXPRESS\"><Name>CADASTRALPARCELS.PARCELLAIRE_EXPRESS:subdivision_fiscale</Name><Title>PCI Vecteur : Subdivisions fiscales</Title><Abstract>Subdivisions fiscales avril 2023</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.PN=\"http://PROTECTEDAREAS.PN\"><Name>PROTECTEDAREAS.PN:pn</Name><Title>Parcs nationaux</Title><Abstract>Les parcs nationaux sont de vastes espaces protégés terrestres ou marins dont le patrimoine naturel est exceptionnel, et dont le but est à la fois de protéger des processus écologiques à large échelle et de fournir des possibilités de découverte de la nature. Mise à jour 09-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-62.05078125 -21.431132812</ows:LowerCorner><ows:UpperCorner>55.8984375 48.178515625</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.PNM=\"http://PROTECTEDAREAS.PNM\"><Name>PROTECTEDAREAS.PNM:pnm</Name><Title>Parcs naturels marins</Title><Abstract>Zones maritimes identifiées pour leur biodiversité ou par les activités humaines faisant l'objet de protection.</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-62.8103646 -14.53138889</ows:LowerCorner><ows:UpperCorner>46.67111111 50.81768056</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.PNR=\"http://PROTECTEDAREAS.PNR\"><Name>PROTECTEDAREAS.PNR:pnr</Name><Title>Parcs naturels régionaux</Title><Abstract>Les parcs naturels régionaux ont pour but de valoriser de vastes espaces de fort intérêt culturel et naturel, et de veiller au développement durable de ces territoires dont le caractère rural est souvent très affirmé. Mise à jour 05-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.34765625 3.654921875</ows:LowerCorner><ows:UpperCorner>9.4921875 51.16890625</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LABELS.TOURISTIQUES=\"http://LABELS.TOURISTIQUES\"><Name>LABELS.TOURISTIQUES:pavillon_bleu</Name><Title>Pavillon bleu</Title><Abstract>Pavillon bleu</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-151.875 -22.475</ows:LowerCorner><ows:UpperCorner>166.640625 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:pays_ecoregions=\"http://pays_ecoregions\"><Name>pays_ecoregions:pays</Name><Title>Pays du monde</Title><Abstract>Pays du monde</Abstract><ows:Keywords><ows:Keyword>Tutoriel</ows:Keyword><ows:Keyword>Données mondiales</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-175.0 -75.0</ows:LowerCorner><ows:UpperCorner>175.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:jm_pays_ecoregions=\"http://jm_pays_ecoregions\"><Name>jm_pays_ecoregions:pays</Name><Title>Pays du monde</Title><Abstract>Pays du monde</Abstract><ows:Keywords><ows:Keyword>Tutoriel</ows:Keyword><ows:Keyword>Données mondiales</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-175.0 -75.0</ows:LowerCorner><ows:UpperCorner>175.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_scot=\"http://wfs_scot\"><Name>wfs_scot:perimetre_scot</Name><Title>Perimetre du Schéma de cohérence territorial</Title><Abstract>Périmètre publié du Schéma de Cohérence Territorial</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.5234375 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.546875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:DGAC-PEB_BDD_FXX_WM=\"http://DGAC-PEB_BDD_FXX_WM\"><Name>DGAC-PEB_BDD_FXX_WM:fxx_peb_wm</Name><Title>Plan d'exposition au bruit (PEB)</Title><Abstract>Les plans d'exposition aux bruits identifient trois ou quatre types de zone de bruit diversement exposés au bruit engendré par les aéronefs (A, B, C et/ou D et définis à partir des prévisions de développement de l'activité aérienne, de l'extension prévisible des infrastructures et des procédures de circulation aérienne.Pour en savoir plus Sources : Ministère de l'Ecologie, du Développement durable et de l'Energie Date des données</Abstract><ows:Keywords><ows:Keyword>Ville et urbanisme</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.598904 -21.335064</ows:LowerCorner><ows:UpperCorner>55.582677 50.700964</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:DGAC-PEB-POI_BDD_WLD_WM=\"http://DGAC-PEB-POI_BDD_WLD_WM\"><Name>DGAC-PEB-POI_BDD_WLD_WM:aerodrome_avec_peb_wm</Name><Title>Plan d'exposition au bruit, documents d'approbation (PEB)</Title><Abstract>Les plans d'exposition aux bruits identifient trois ou quatre types de zone de bruit diversement exposés au bruit engendré par les aéronefs (A, B, C et/ou D et définis à partir des prévisions de développement de l'activité aérienne, de l'extension prévisible des infrastructures et des procédures de circulation aérienne. Pour en savoir plus Sources : Ministère de l'Ecologie, du Développement durable et de l'Energie Date des données</Abstract><ows:Keywords><ows:Keyword>Ville et urbanisme</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.525833 -21.321536</ows:LowerCorner><ows:UpperCorner>55.516342 50.687222</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:DGAC-PGS_BDD_FXX_WM=\"http://DGAC-PGS_BDD_FXX_WM\"><Name>DGAC-PGS_BDD_FXX_WM:fxx_pgs_wm</Name><Title>Plan de gêne sonore (PGS)</Title><Abstract>Les plans de gêne sonore identifient trois type de zones de bruit (I, II, III) établies sur la base du trafic estimé, des procédures de circulation aérienne applicables et des infrastructures qui seront en service dans l'année suivant la date de publication de l'arrêté approuvant le PGS. Pour en savoir plus Sources : Ministère de l'Ecologie, du Développement durable et de l'Energie</Abstract><ows:Keywords><ows:Keyword>Ville et urbanisme</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-1.645795 43.365423</ows:LowerCorner><ows:UpperCorner>7.551737 49.489555</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:DGAC-PGS-POI_BDD_FXX_WM=\"http://DGAC-PGS-POI_BDD_FXX_WM\"><Name>DGAC-PGS-POI_BDD_FXX_WM:aerodrome_avec_pgs_wm</Name><Title>Plan de gêne sonore, documents d'approbation (PGS)</Title><Abstract>Arrêté préfectoral d'approbation, pour chaque aérodrome, du plan de gêne sonore. Pour en savoir plus Sources : Ministère de l'Ecologie, du Développement durable et de l'Energie</Abstract><ows:Keywords><ows:Keyword>Ville et urbanisme</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-1.607808 43.436634</ows:LowerCorner><ows:UpperCorner>7.529222 49.454422</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:TRANSPORTS.AIRNOISE.DOCS=\"http://TRANSPORTS.AIRNOISE.DOCS\"><Name>TRANSPORTS.AIRNOISE.DOCS:dgac_psa_poi_wm</Name><Title>Plan de servitudes aéronautiques, documents d'approbation (PSA)</Title><Abstract>Arrêté ministériel ou décret en Conseil d'Etat approuvant les servitudes aéronautiques aux abords de l'aérodrome. Les donn&amp;eacute;es sont fournies &amp;agrave; titre informatif et n'ont aucune valeur r&amp;eacute;glementaire. Seul le document papier officiel consultable en mairie ou en pr&amp;eacute;fecture est opposable. Pour en savoir plus Sources : Ministère de l'Ecologie, du Développement durable et de l'Energie Date des données</Abstract><ows:Keywords><ows:Keyword>Ville et urbanisme</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-149.611389 -22.588611</ows:LowerCorner><ows:UpperCorner>167.455278 50.960933</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PRSF_BDD_GLP_2023=\"http://PRSF_BDD_GLP_2023\"><Name>PRSF_BDD_GLP_2023:prs_glp</Name><Title>Points de Rencontre de Secours en Forêt (PRSF)</Title><Abstract>Les Points de Rencontre de Secours en Forêt (PRSF) sont supposées connus des services de secours. Ils permettent de faciliter la localisation d’un blessé par les services de secours.</Abstract><ows:Keywords><ows:Keyword>forêt</ows:Keyword><ows:Keyword>secours</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::32620</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80877874 15.84342129</ows:LowerCorner><ows:UpperCorner>-61.00764963 16.50991853</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.PRSF=\"http://PROTECTEDAREAS.PRSF\"><Name>PROTECTEDAREAS.PRSF:prs_fr</Name><Title>Points de Rencontre de Secours en Forêt (PRSF)</Title><Abstract>Les Points de Rencontre de Secours en Forêt (PRSF) sont supposées connus des services de secours. Ils permettent de faciliter la localisation d’un blessé par les services de secours.</Abstract><ows:Keywords><ows:Keyword>forêt</ows:Keyword><ows:Keyword>secours</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-4.90241181 41.74721942</ows:LowerCorner><ows:UpperCorner>9.38950578 50.73142152</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PRSF_BDD_REU_2023=\"http://PRSF_BDD_REU_2023\"><Name>PRSF_BDD_REU_2023:prs_reu</Name><Title>Points de Rencontre de Secours en Forêt (PRSF)</Title><Abstract>Les Points de Rencontre de Secours en Forêt (PRSF) sont supposées connus des services de secours. Ils permettent de faciliter la localisation d’un blessé par les services de secours.</Abstract><ows:Keywords><ows:Keyword>forêt</ows:Keyword><ows:Keyword>secours</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2975</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>55.28242418 -21.37413806</ows:LowerCorner><ows:UpperCorner>55.82905815 -20.88254768</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PRSF_BDD_GUF_2023=\"http://PRSF_BDD_GUF_2023\"><Name>PRSF_BDD_GUF_2023:prs_guf</Name><Title>Points de Rencontre de Secours en Forêt (PRSF)</Title><Abstract>Les Points de Rencontre de Secours en Forêt (PRSF) sont supposées connus des services de secours. Ils permettent de faciliter la localisation d’un blessé par les services de secours.</Abstract><ows:Keywords><ows:Keyword>forêt</ows:Keyword><ows:Keyword>secours</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2972</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-54.38154367 3.727489</ows:LowerCorner><ows:UpperCorner>-51.84944924 5.63054804</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:test_nl_bdtopo_la_ciotat=\"http://test_nl_bdtopo_la_ciotat\"><Name>test_nl_bdtopo_la_ciotat:point_du_reseau</Name><Title>Points du réseau routier</Title><Abstract>Points du réseau routier (sélection sur La Ciotat - Bouches-du-Rhône) issus de la BD Topo V3</Abstract><ows:Keywords><ows:Keyword>DATA NON OFFICIELLE</ows:Keyword><ows:Keyword>DEMO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>5.053164062 43.152705078</ows:LowerCorner><ows:UpperCorner>5.680722656 43.340776367</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:GEODESIE=\"http://GEODESIE\"><Name>GEODESIE:data_geod</Name><Title>Points pour le serveur de données</Title><Abstract>Points pour le serveur de données</Abstract><ows:Keywords><ows:Keyword>Points</ows:Keyword><ows:Keyword>Géodésie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-175.0 -75.0</ows:LowerCorner><ows:UpperCorner>175.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:POTENTIEL.SOLAIRE.SOL=\"http://POTENTIEL.SOLAIRE.SOL\"><Name>POTENTIEL.SOLAIRE.SOL:pv_sol</Name><Title>Potentiel solaire sol</Title><Abstract>Zones potentiellements propices à l'installation de solaire sol</Abstract><ows:Keywords><ows:Keyword>Solaire</ows:Keyword><ows:Keyword>Enr</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:POTENTIEL.SOLAIRE.BATIMENT=\"http://POTENTIEL.SOLAIRE.BATIMENT\"><Name>POTENTIEL.SOLAIRE.BATIMENT:bati</Name><Title>Potentiel solaire sur toiture (méthode simplifiée)</Title><Abstract>Potentiel solaire sur toiture (méthode simplifiée)</Abstract><ows:Keywords><ows:Keyword>Solaire</ows:Keyword><ows:Keyword>Enr</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:prescription_lin</Name><Title>Prescriptions linéaires</Title><Abstract>Prescriptions linéaires se superposant au zonage</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:prescription_pct</Name><Title>Prescriptions ponctuelles</Title><Abstract>Prescriptions ponctuelles se superposant au zonage</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:prescription_surf</Name><Title>Prescriptions surfaciques</Title><Abstract>Prescriptions surfaciques se superposant au zonage</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:espace_revendeurs=\"http://espace_revendeurs\"><Name>espace_revendeurs:product</Name><Title>Produits</Title><Abstract>Produits</Abstract><ows:Keywords><ows:Keyword>Espace revendeurs</ows:Keyword><ows:Keyword>test</ows:Keyword><ows:Keyword>Produits</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-175.0 -75.0</ows:LowerCorner><ows:UpperCorner>175.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:espace_revendeurs_beta=\"http://espace_revendeurs_beta\"><Name>espace_revendeurs_beta:product</Name><Title>Produits (Bêta)</Title><Abstract>Produits</Abstract><ows:Keywords><ows:Keyword>Espace revendeurs</ows:Keyword><ows:Keyword>Produits</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-175.0 -75.0</ows:LowerCorner><ows:UpperCorner>175.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PRAIRIES.SENSIBLES.BCAE=\"http://PRAIRIES.SENSIBLES.BCAE\"><Name>PRAIRIES.SENSIBLES.BCAE:prairies_sensibles</Name><Title>Préservation des prairies et pâturages permanents en zone Natura 2000</Title><Abstract>Préservation des prairies et pâturages permanents en zone Natura 2000 - Couche pour la nouvelle PAC produite par l’Observatoire du développement rural (ODR) en lien avec l’INRAE.</Abstract><ows:Keywords><ows:Keyword>bcae</ows:Keyword><ows:Keyword>prairie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.12736132 41.34982303</ows:LowerCorner><ows:UpperCorner>9.64817082 50.82288748</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CADASTRALPARCELS.QUALREFBDP=\"http://CADASTRALPARCELS.QUALREFBDP\"><Name>CADASTRALPARCELS.QUALREFBDP:divcadmtd</Name><Title>Qualité du géoréférencement de la BD Parcellaire</Title><Abstract>Métadonnées complémentaires des divisions cadastrales. Davantage d’informations dans le document disponible https://data.geopf.fr/annexes/ressources/fiches/bdparcellaire/Metadonnees_BDPARCELLAIRE.pdf</Abstract><ows:Keywords><ows:Keyword>BDParcellaire</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15313141 -21.38974726</ows:LowerCorner><ows:UpperCorner>55.83668587 51.0888974</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:AREAMANAGEMENT.QP.VECTOR=\"http://AREAMANAGEMENT.QP.VECTOR\"><Name>AREAMANAGEMENT.QP.VECTOR:qp_decretmodif_2015_epsg3857_wm</Name><Title>Quartiers Prioritaires de la politique de la ville</Title><Abstract>Les quartiers prioritaires de la politique de la ville sont issus de la loi de programmation pour la ville et cohésion urbaine n° 2014-173 du 21 février 2014. Sources : Commissariat Général à l'Egalité des Territoires.</Abstract><ows:Keywords><ows:Keyword>Politique de la ville</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-149.90462172 -21.38644287</ows:LowerCorner><ows:UpperCorner>55.74675056 51.03563906</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:CGET_QP_BDD_WLD_WM_20160412=\"http://CGET_QP_BDD_WLD_WM_20160412\"><Name>CGET_QP_BDD_WLD_WM_20160412:qp_decretmodif_2015_epsg3857_wm</Name><Title>Quartiers Prioritaires de la politique de la ville</Title><Abstract>Les quartiers prioritaires de la politique de la ville sont issus de la loi de programmation pour la ville et cohésion urbaine n° 2014-173 du 21 février 2014. Sources : Commissariat Général à l'Egalité des Territoires.</Abstract><ows:Keywords><ows:Keyword>Politique de la ville</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-149.90462172 -21.38644287</ows:LowerCorner><ows:UpperCorner>55.74675056 51.03563906</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2010=\"http://RPG.2010\"><Name>RPG.2010:rpg_2010</Name><Title>Registre parcellaire graphique (RPG) 2010</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2010</Abstract><ows:Keywords><ows:Keyword>Agriculture</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.08582386 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83266635 51.07514669</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2013=\"http://RPG.2013\"><Name>RPG.2013:rpg_2013</Name><Title>Registre parcellaire graphique (RPG) 2013</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2013</Abstract><ows:Keywords><ows:Keyword>Agriculture</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.09061791 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83266635 51.07514669</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2014=\"http://RPG.2014\"><Name>RPG.2014:rpg_2014</Name><Title>Registre parcellaire graphique (RPG) 2014</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2014</Abstract><ows:Keywords><ows:Keyword>Agriculture</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.09061791 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83259967 51.07512792</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2015=\"http://RPG.2015\"><Name>RPG.2015:parcelles_graphiques</Name><Title>Registre parcellaire graphique (RPG) 2015</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2015</Abstract><ows:Keywords><ows:Keyword>Agriculture</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.09061791 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83259967 51.07510064</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2016=\"http://RPG.2016\"><Name>RPG.2016:parcelles_graphiques</Name><Title>Registre parcellaire graphique (RPG) 2016</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2016</Abstract><ows:Keywords><ows:Keyword>Agriculture</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.09061791 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83259967 51.07510064</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2017=\"http://RPG.2017\"><Name>RPG.2017:parcelles_graphiques</Name><Title>Registre parcellaire graphique (RPG) 2017</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2017</Abstract><ows:Keywords><ows:Keyword>Agriculture</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.09061791 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83259967 51.07510064</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2018=\"http://RPG.2018\"><Name>RPG.2018:parcelles_graphiques</Name><Title>Registre parcellaire graphique (RPG) 2018</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2018</Abstract><ows:Keywords><ows:Keyword>Usage des sols</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.08613261 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83259967 51.07510064</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2019=\"http://RPG.2019\"><Name>RPG.2019:parcelles_graphiques</Name><Title>Registre parcellaire graphique (RPG) 2019</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2019</Abstract><ows:Keywords><ows:Keyword>Usages des sols</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.07282825 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83259967 51.07510064</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2020=\"http://RPG.2020\"><Name>RPG.2020:parcelles_graphiques</Name><Title>Registre parcellaire graphique (RPG) 2020</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2020.</Abstract><ows:Keywords><ows:Keyword>Usages des sols</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.07078975 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83259967 51.07510062</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2021=\"http://RPG.2021\"><Name>RPG.2021:parcelles_graphiques</Name><Title>Registre parcellaire graphique (RPG) 2021</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2021</Abstract><ows:Keywords><ows:Keyword>Usages des sols</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.07078975 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83259967 51.07510062</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2022=\"http://RPG.2022\"><Name>RPG.2022:codes_cultures</Name><Title>Registre parcellaire graphique (RPG) 2022 : Codes des cultures</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2022</Abstract><ows:Keywords><ows:Keyword>Usages des sols</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.07078975 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83259967 51.07510062</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2022=\"http://RPG.2022\"><Name>RPG.2022:parcelles_graphiques</Name><Title>Registre parcellaire graphique (RPG) 2022 : Parcelles graphiques</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2022</Abstract><ows:Keywords><ows:Keyword>Usages des sols</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.07078975 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83259967 51.07510062</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.LATEST=\"http://RPG.LATEST\"><Name>RPG.LATEST:parcelles_graphiques</Name><Title>Registre parcellaire graphique (RPG) Latest</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants Latest</Abstract><ows:Keywords><ows:Keyword>Usages des sols</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.07078975 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83259967 51.07510062</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2011=\"http://RPG.2011\"><Name>RPG.2011:rpg_2011</Name><Title>Registre parcellaire graphique 2011</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2011.</Abstract><ows:Keywords><ows:Keyword>Usage des sols</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.08582386 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83266635 51.07514669</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:RPG.2012=\"http://RPG.2012\"><Name>RPG.2012:rpg_2012</Name><Title>Registre parcellaire graphique 2012</Title><Abstract>Registre parcellaire graphique : zones de cultures déclarées par les exploitants en 2012.</Abstract><ows:Keywords><ows:Keyword>Agriculture</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.09061791 -21.38541709</ows:LowerCorner><ows:UpperCorner>55.83266635 51.07514669</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_sup=\"http://wfs_sup\"><Name>wfs_sup:servitude_acte_sup</Name><Title>Relation entre ACTE_SUP et SERVITUDE</Title><Abstract>Relation entre les SUP et les actes les instituant</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -49.86640625</ows:LowerCorner><ows:UpperCorner>78.046875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:TRANSPORTS.DRONES.RESTRICTIONS=\"http://TRANSPORTS.DRONES.RESTRICTIONS\"><Name>TRANSPORTS.DRONES.RESTRICTIONS:carte_restriction_drones_lf</Name><Title>Restrictions UAS catégorie Ouverte et Aéromodélisme </Title><Abstract>{quote}Zones soumises à interdictions ou à restrictions pour l’usage, à titre de loisir, d’aéronefs télépilotés (ou drones), sur le territoire métropolitain, à jour au 07-2020. Elle intègre partiellement les interdictions s'appuyant sur des données non publiées à l'AIP et ne couvre pas les interdictions temporaires. Cette carte est basée sur l’arrêté « espace » du 30 mars 2017. La représentation des zones soumises à interdictions ou à restrictions n’engage pas la responsabilité des producteurs de la donnée. Le contour des agglomérations est fourni à titre purement indicatif. Consultez les interdictions temporaires sur https://www.sia.aviation-civile.gouv.fr/.{quote}</Abstract><ows:Keywords><ows:Keyword>Drone</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-7.99999703 40.84341536</ows:LowerCorner><ows:UpperCorner>10.70000198 51.09333213</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LIMITES_ADMINISTRATIVES_EXPRESS.LATEST=\"http://LIMITES_ADMINISTRATIVES_EXPRESS.LATEST\"><Name>LIMITES_ADMINISTRATIVES_EXPRESS.LATEST:region</Name><Title>Région</Title><Abstract>Limites administrative mises à jour en continu</Abstract><ows:Keywords><ows:Keyword>Unités administratives</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST=\"http://ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST\"><Name>ADMIN-EXPRESS_WGS84G_FRA_WFS_LATEST:region</Name><Title>Régions</Title><Abstract>Régions</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.80983861776941 -21.389630761010356</ows:LowerCorner><ows:UpperCorner>55.83665387473344 51.088989440786094</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:pays_ecoregions=\"http://pays_ecoregions\"><Name>pays_ecoregions:regions_ecologiques</Name><Title>Régions écologiques</Title><Abstract>Grandes régions naturelles mondiales</Abstract><ows:Keywords><ows:Keyword>Tutoriel</ows:Keyword><ows:Keyword>Données mondiales</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-175.0 -75.0</ows:LowerCorner><ows:UpperCorner>175.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:jm_pays_ecoregions=\"http://jm_pays_ecoregions\"><Name>jm_pays_ecoregions:regions_ecologiques</Name><Title>Régions écologiques</Title><Abstract>Grandes régions naturelles mondiales</Abstract><ows:Keywords><ows:Keyword>Tutoriel</ows:Keyword><ows:Keyword>Données mondiales</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-175.0 -75.0</ows:LowerCorner><ows:UpperCorner>175.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:REPARTITION.POTENTIEL.METHANISATION.2050=\"http://REPARTITION.POTENTIEL.METHANISATION.2050\"><Name>REPARTITION.POTENTIEL.METHANISATION.2050:potentiel_methanisation_2050</Name><Title>Répartition des potentiels de méthanisation à horizon 2050 par canton</Title><Abstract>Répartition des potentiels de méthanisation à horizon 2050 par canton</Abstract><ows:Keywords><ows:Keyword>Enr</ows:Keyword><ows:Keyword>Méthanisation</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.13901729 42.33348863</ows:LowerCorner><ows:UpperCorner>8.23029497 51.0893967</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:test_nl_bdtopo_la_ciotat=\"http://test_nl_bdtopo_la_ciotat\"><Name>test_nl_bdtopo_la_ciotat:troncon_de_route</Name><Title>Réseau routier, autoroutier et voirie</Title><Abstract>Réseau routier, autoroutier et voirie (sélection sur La Ciotat - Bouches-du-Rhône) issus de la BD Topo V3</Abstract><ows:Keywords><ows:Keyword>DATA NON OFFICIELLE</ows:Keyword><ows:Keyword>DEMO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>5.053164062 43.152705078</ows:LowerCorner><ows:UpperCorner>5.680722656 43.340776367</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.RB=\"http://PROTECTEDAREAS.RB\"><Name>PROTECTEDAREAS.RB:rb</Name><Title>Réserves Biologiques</Title><Abstract>Une réserve biologique est un espace protégé en milieu forestier ou en milieu associé à la forêt (landes, mares, tourbières, dunes). Ce statut s'applique aux forêts gérées par l'Office National des Forêts et a pour but la protection d'habitats remarquables ou représentatifs.</Abstract><ows:Keywords><ows:Keyword>Biodiversité</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.51809317 -21.37682085</ows:LowerCorner><ows:UpperCorner>55.80534186 50.76219068</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.RIPN=\"http://PROTECTEDAREAS.RIPN\"><Name>PROTECTEDAREAS.RIPN:ripn</Name><Title>Réserves Intégrales de Parcs Nationaux</Title><Abstract>Au sein d'un cœur de parc national, il peut être institué une « réserve intégrale » afin d'assurer, dans un but scientifique, une protection plus grande de certains éléments de la faune et de la flore. Mise à jour 05-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>4.93859859 42.98700604</ows:LowerCorner><ows:UpperCorner>6.81356258 48.03288778</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.RNC=\"http://PROTECTEDAREAS.RNC\"><Name>PROTECTEDAREAS.RNC:rnc</Name><Title>Réserves Naturelles de Corse</Title><Abstract>Les réserves naturelles sont des espaces protégés terrestres ou marins dont le patrimoine naturel est exceptionnel, tant sur le plan de la biodiversité que parfois sur celui de la géodiversité. &lt;/br&gt;&lt;a href=\"https://data.geopf.fr/annexes/ressources/fiches/mnhn/actualite_donnees_mnhn.pdf\" alt=\"Date des données\" target=\"_blank\"&gt;Date des données&lt;/a&gt;</Abstract><ows:Keywords><ows:Keyword>Biodiversité</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>8.53417374 41.2918034</ows:LowerCorner><ows:UpperCorner>9.51855167 43.02786727</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.BIOS=\"http://PROTECTEDAREAS.BIOS\"><Name>PROTECTEDAREAS.BIOS:bios</Name><Title>Réserves de biosphère</Title><Abstract>Réserves naturelles reconnues par le Programme sur l'Homme et la Biosphère créé par l'Unesco. Mise à jour 09-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-62.8103646 14.0822864</ows:LowerCorner><ows:UpperCorner>8.91380512 50.85549715</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.RNCF=\"http://PROTECTEDAREAS.RNCF\"><Name>PROTECTEDAREAS.RNCF:rncfs</Name><Title>Réserves nationales de chasse et de faune sauvage</Title><Abstract>Les réserves nationales de chasse et de faune sauvage sont des espaces protégés terrestres ou marins dont la gestion est principalement assurée par l'Office National de la Chasse et de la Faune Sauvage. 09-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-2.911376953 42.592299805</ows:LowerCorner><ows:UpperCorner>8.239746094 48.967646484</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.RNN=\"http://PROTECTEDAREAS.RNN\"><Name>PROTECTEDAREAS.RNN:rnn</Name><Title>Réserves naturelles nationales</Title><Abstract>Les réserves naturelles sont des espaces protégés terrestres ou marins dont le patrimoine naturel est exceptionnel, tant sur le plan de la biodiversité que parfois sur celui de la géodiversité. Mise à jour 09-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -53.82703125</ows:LowerCorner><ows:UpperCorner>82.265625 51.16890625</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDSITES.MNHN.RESERVES-REGIONALES=\"http://PROTECTEDSITES.MNHN.RESERVES-REGIONALES\"><Name>PROTECTEDSITES.MNHN.RESERVES-REGIONALES:rnr</Name><Title>Réserves naturelles régionales</Title><Abstract>Les réserves naturelles régionales sont gérées prioritairement à des fins de conservation de la nature. Elles sont placées sous la responsabilité exclusive des conseils régionaux.09-2022</Abstract><ows:Keywords><ows:Keyword>Biodiversité</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-4.6198922 42.44788121</ows:LowerCorner><ows:UpperCorner>7.68631242 51.02328693</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_scot=\"http://wfs_scot\"><Name>wfs_scot:scot</Name><Title>Schéma de cohérence territorial</Title><Abstract>Etat du Schéma de Cohérence Territorial</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.5234375 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.546875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:secteur_cc</Name><Title>Secteurs de la carte communale</Title><Abstract>Secteurs de carte communale</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_sup=\"http://wfs_sup\"><Name>wfs_sup:servitude</Name><Title>Servitude d'utilité publique</Title><Abstract>Liste des servitudes d'utilité publique</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -49.86640625</ows:LowerCorner><ows:UpperCorner>78.046875 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.ZPS=\"http://PROTECTEDAREAS.ZPS\"><Name>PROTECTEDAREAS.ZPS:zps</Name><Title>Sites NATURA 2000 au titre de la Directive Oiseaux</Title><Abstract>Le réseau Natura 2000 s'inscrit au coeur de la politique de conservation de la nature de l'Union européenne et est un élément clé de l'objectif visant à enrayer l'érosion de la biodiversité. 09-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-10.1953125 41.2009375</ows:LowerCorner><ows:UpperCorner>9.84375 51.501171875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.SIC=\"http://PROTECTEDAREAS.SIC\"><Name>PROTECTEDAREAS.SIC:sic</Name><Title>Sites Natura 2000 au titre de la Directive Habitats</Title><Abstract>Le réseau Natura 2000 s'inscrit au coeur de la politique de conservation de la nature de l'Union européenne et est un élément clé de l'objectif visant à enrayer l'érosion de la biodiversité.01-02-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-10.1953125 41.2009375</ows:LowerCorner><ows:UpperCorner>9.84375 51.501171875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.UNESCO=\"http://PROTECTEDAREAS.UNESCO\"><Name>PROTECTEDAREAS.UNESCO:unesco</Name><Title>Sites inscrits au patrimoine mondial de l’UNESCO (biens naturels ou mixtes)</Title><Abstract>Un bien naturel ou mixte (naturel et culturel) inscrit au patrimoine mondial de l'UNESCO est un espace qui, du fait de sa valeur patrimoniale exceptionnelle, est considéré comme héritage commun de l'humanité.</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-1.95319892 -21.36768458</ows:LowerCorner><ows:UpperCorner>55.81417555 48.83651619</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES-INT=\"http://VIGICRUES-INT\"><Name>VIGICRUES-INT:stations</Name><Title>Stations Vigicrues</Title><Abstract>Référentiel des stations hydrométriques du réseau Vigicrues</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES=\"http://VIGICRUES\"><Name>VIGICRUES:stations</Name><Title>Stations Vigicrues</Title><Abstract>Référentiel des stations hydrométriques du réseau Vigicrues</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES_STATIONS_BDD_WLD_WM_2023-v1=\"http://VIGICRUES_STATIONS_BDD_WLD_WM_2023-v1\"><Name>VIGICRUES_STATIONS_BDD_WLD_WM_2023-v1:referentiel</Name><Title>Stations Vigicrues</Title><Abstract>Référentiel des stations du réseau Vigicrues</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES-QUA=\"http://VIGICRUES-QUA\"><Name>VIGICRUES-QUA:stations</Name><Title>Stations Vigicrues</Title><Abstract>Référentiel des stations hydrométriques du réseau Vigicrues</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.2734375 41.087109375</ows:LowerCorner><ows:UpperCorner>9.84375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LABELS.TOURISTIQUES=\"http://LABELS.TOURISTIQUES\"><Name>LABELS.TOURISTIQUES:stations_classees</Name><Title>Stations classées</Title><Abstract>Stations classées</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-151.875 -22.475</ows:LowerCorner><ows:UpperCorner>166.640625 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:fr_qa_stations=\"http://fr_qa_stations\"><Name>fr_qa_stations:stations_qualite_air</Name><Title>Stations qualité de l'air</Title><Abstract>Les informations sur les stations de surveillance de la qualité de l'air des AASQA</Abstract><ows:Keywords><ows:Keyword>Surveillance</ows:Keyword><ows:Keyword>Qualité de l'air</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-175.0 -75.0</ows:LowerCorner><ows:UpperCorner>175.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LABELS.TOURISTIQUES=\"http://LABELS.TOURISTIQUES\"><Name>LABELS.TOURISTIQUES:stations_vertes</Name><Title>Stations vertes</Title><Abstract>Stations vertes</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-151.875 -22.475</ows:LowerCorner><ows:UpperCorner>166.640625 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:STOCK_CARBONE_REG_2015=\"http://STOCK_CARBONE_REG_2015\"><Name>STOCK_CARBONE_REG_2015:stock_carbone_regions</Name><Title>Stock de carbone moyen par région en tonnes par hectare en 2015</Title><Abstract>Stock de carbone moyen par région en tonnes par hectare en 2015</Abstract><ows:Keywords><ows:Keyword>Carbone</ows:Keyword><ows:Keyword>Observatoire</ows:Keyword><ows:Keyword>Régions</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-6.0 41.0</ows:LowerCorner><ows:UpperCorner>12.0 51.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:test_nl_meae_representation_diplo_fr_wld=\"http://test_nl_meae_representation_diplo_fr_wld\"><Name>test_nl_meae_representation_diplo_fr_wld:test_nl_meae_ambassades_et_consulats</Name><Title>TEST NL - MEAE - Représentations diplomatiques Françaises dans le Monde</Title><Abstract>Localisation des représentations diplomatiques françaises à l'étranger. Donnée issue de data.gouv sans caractère officiel</Abstract><ows:Keywords><ows:Keyword>DATA NON OFFICIELLE</ows:Keyword><ows:Keyword>DEMO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-123.123779297 -41.294387207</ows:LowerCorner><ows:UpperCorner>178.428955078 64.148032227</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.MNHN.CONSERVATOIRES=\"http://PROTECTEDAREAS.MNHN.CONSERVATOIRES\"><Name>PROTECTEDAREAS.MNHN.CONSERVATOIRES:cen</Name><Title>Terrains des conservatoires d'espaces naturels</Title><Abstract>Les conservatoires d'espaces naturels organisent la maîtrise foncière de terrains en vue d'assurer la protection des espèces qui y résident. 05-2022</Abstract><ows:Keywords><ows:Keyword>Biodiversité</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-2.37011551 41.59376493</ows:LowerCorner><ows:UpperCorner>9.53678527 50.90041727</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES-INT=\"http://VIGICRUES-INT\"><Name>VIGICRUES-INT:territoires</Name><Title>Territoires Vigicrues</Title><Abstract>Référentiel des territoires du réseau Vigicrues.</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES=\"http://VIGICRUES\"><Name>VIGICRUES:territoires</Name><Title>Territoires Vigicrues</Title><Abstract>Référentiel des territoires du réseau Vigicrues.</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES-QUA=\"http://VIGICRUES-QUA\"><Name>VIGICRUES-QUA:territoires</Name><Title>Territoires Vigicrues</Title><Abstract>Référentiel des territoires du réseau Vigicrues.</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.2734375 41.087109375</ows:LowerCorner><ows:UpperCorner>9.84375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES_TERRITOIRES_BDD_WLD_WM_2023-v1=\"http://VIGICRUES_TERRITOIRES_BDD_WLD_WM_2023-v1\"><Name>VIGICRUES_TERRITOIRES_BDD_WLD_WM_2023-v1:referentiel</Name><Title>Territoires Vigicrues</Title><Abstract>Référentiel des territoires du réseau Vigicrues</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:test_zae=\"http://test_zae\"><Name>test_zae:tes_zae</Name><Title>Test alim Zae</Title><Abstract>Test alim Zae</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -90.0</ows:LowerCorner><ows:UpperCorner>180.0 90.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:TRACES.RANDO.HIVERNALE=\"http://TRACES.RANDO.HIVERNALE\"><Name>TRACES.RANDO.HIVERNALE:traces_rando_hivernale</Name><Title>Trace de randonnée hivernale (à ski, à raquette)</Title><Abstract>Trace de randonnée hivernale (à ski, à raquette)</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>5.43859375 44.199804688</ows:LowerCorner><ows:UpperCorner>7.09890625 46.314335938</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:SECUROUT.TE=\"http://SECUROUT.TE\"><Name>SECUROUT.TE:n_te_franchissement_p</Name><Title>Transports exceptionnels Franchissements</Title><Abstract>Transports exceptionnels (tronçons, franchissements et prescriptions) au format COVADIS</Abstract><ows:Keywords><ows:Keyword>transport</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-4.8 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:SECUROUT.TE=\"http://SECUROUT.TE\"><Name>SECUROUT.TE:n_te_rel_franpres</Name><Title>Transports exceptionnels Lien franchissements - prescriptions</Title><Abstract>Transports exceptionnels (tronçons, franchissements et prescriptions) au format COVADIS</Abstract><ows:Keywords><ows:Keyword>transport</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-4.8 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:SECUROUT.TE=\"http://SECUROUT.TE\"><Name>SECUROUT.TE:n_te_prescription</Name><Title>Transports exceptionnels Prescriptions</Title><Abstract>Transports exceptionnels (tronçons, franchissements et prescriptions) au format COVADIS</Abstract><ows:Keywords><ows:Keyword>transport</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-4.8 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:SECUROUT.TE=\"http://SECUROUT.TE\"><Name>SECUROUT.TE:n_te_troncon_l</Name><Title>Transports exceptionnels Tronçons</Title><Abstract>Transports exceptionnels (tronçons, franchissements et prescriptions) au format COVADIS</Abstract><ows:Keywords><ows:Keyword>transport</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-4.8 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:SECUROUT.TE=\"http://SECUROUT.TE\"><Name>SECUROUT.TE:n_te_rel_tronpres</Name><Title>Transports exceptionnels lien tronçon - prescription</Title><Abstract>Transports exceptionnels (tronçons, franchissements et prescriptions) au format COVADIS</Abstract><ows:Keywords><ows:Keyword>transport</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-4.8 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES_TRONCONS_BDD_WLD_WM_2023-v1=\"http://VIGICRUES_TRONCONS_BDD_WLD_WM_2023-v1\"><Name>VIGICRUES_TRONCONS_BDD_WLD_WM_2023-v1:referentiel</Name><Title>Tronçons Vigicrues</Title><Abstract>Référentiel des tronçons du réseau Vigicrues</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES-INT=\"http://VIGICRUES-INT\"><Name>VIGICRUES-INT:troncons</Name><Title>Tronçons Vigicrues</Title><Abstract>Référentiel des tronçons du réseau Vigicrues</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES=\"http://VIGICRUES\"><Name>VIGICRUES:troncons</Name><Title>Tronçons Vigicrues</Title><Abstract>Référentiel des tronçons du réseau Vigicrues</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.4325 41.15</ows:LowerCorner><ows:UpperCorner>9.7475 51.2346875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:VIGICRUES-QUA=\"http://VIGICRUES-QUA\"><Name>VIGICRUES-QUA:troncons</Name><Title>Tronçons Vigicrues</Title><Abstract>Référentiel des tronçons du réseau Vigicrues</Abstract><ows:Keywords><ows:Keyword>Vigicrues</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.2734375 41.087109375</ows:LowerCorner><ows:UpperCorner>9.84375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:LABELS.TOURISTIQUES=\"http://LABELS.TOURISTIQUES\"><Name>LABELS.TOURISTIQUES:villages_etape</Name><Title>Villages étape</Title><Abstract>Villages étape</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-151.875 -22.475</ows:LowerCorner><ows:UpperCorner>166.640625 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:DREAL.ZONAGE_PINEL=\"http://DREAL.ZONAGE_PINEL\"><Name>DREAL.ZONAGE_PINEL:carreaux</Name><Title>Zonage du dispositif Pinel en Bretagne 2020-2021</Title><Abstract>La réduction d'impôt « Pinel » (code général des impôts) s'applique à l’investissement locatif réalisé dans les zones où la tension entre l'offre et la demande de logements est la plus forte.  La loi n°2019-1479 du 28 décembre 2019 de finances pour 2020, prévoit à titre expérimental, un dispositif dérogatoire au droit commun pour la Bretagne. Ainsi, les communes ou parties de communes éligibles à la réduction d'impôt « Pinel » sont fixées par arrêté du préfet de région. Cet arrêté est pris après avis du président du conseil régional et du comité régional de l'habitat et de l'hébergement. Cet article prévoit également que le préfet de région fixe,  par arrêté, les plafonds de loyer  et de ressources du locataire pour chaque commune ou partie de commune éligible et par type de logement.  L’une des particularités de cette expérimentation réside dans l’éligibilité du dispositif qui peut être limitée à une partie seulement du  territoire communal. Lorsqu’une commune n’est éligible que pour une partie de son territoire, deux approches sont distinguées, à savoir à la maille de  l’IRIS (correspondant à un quartier) ou à la maille du carreau de 200 mètres sur 200 mètres.</Abstract><ows:Keywords><ows:Keyword>zonage</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -85.0</ows:LowerCorner><ows:UpperCorner>180.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:DREAL.ZONAGE_PINEL=\"http://DREAL.ZONAGE_PINEL\"><Name>DREAL.ZONAGE_PINEL:communes</Name><Title>Zonage du dispositif Pinel en Bretagne 2020-2021</Title><Abstract>La réduction d'impôt « Pinel » (code général des impôts) s'applique à l’investissement locatif réalisé dans les zones où la tension entre l'offre et la demande de logements est la plus forte.  La loi n°2019-1479 du 28 décembre 2019 de finances pour 2020, prévoit à titre expérimental, un dispositif dérogatoire au droit commun pour la Bretagne. Ainsi, les communes ou parties de communes éligibles à la réduction d'impôt « Pinel » sont fixées par arrêté du préfet de région. Cet arrêté est pris après avis du président du conseil régional et du comité régional de l'habitat et de l'hébergement. Cet article prévoit également que le préfet de région fixe,  par arrêté, les plafonds de loyer  et de ressources du locataire pour chaque commune ou partie de commune éligible et par type de logement.  L’une des particularités de cette expérimentation réside dans l’éligibilité du dispositif qui peut être limitée à une partie seulement du  territoire communal. Lorsqu’une commune n’est éligible que pour une partie de son territoire, deux approches sont distinguées, à savoir à la maille de  l’IRIS (correspondant à un quartier) ou à la maille du carreau de 200 mètres sur 200 mètres.</Abstract><ows:Keywords><ows:Keyword>zonage</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -85.0</ows:LowerCorner><ows:UpperCorner>180.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:DREAL.ZONAGE_PINEL=\"http://DREAL.ZONAGE_PINEL\"><Name>DREAL.ZONAGE_PINEL:iris</Name><Title>Zonage du dispositif Pinel en Bretagne 2020-2021</Title><Abstract>La réduction d'impôt « Pinel » (code général des impôts) s'applique à l’investissement locatif réalisé dans les zones où la tension entre l'offre et la demande de logements est la plus forte.  La loi n°2019-1479 du 28 décembre 2019 de finances pour 2020, prévoit à titre expérimental, un dispositif dérogatoire au droit commun pour la Bretagne. Ainsi, les communes ou parties de communes éligibles à la réduction d'impôt « Pinel » sont fixées par arrêté du préfet de région. Cet arrêté est pris après avis du président du conseil régional et du comité régional de l'habitat et de l'hébergement. Cet article prévoit également que le préfet de région fixe,  par arrêté, les plafonds de loyer  et de ressources du locataire pour chaque commune ou partie de commune éligible et par type de logement.  L’une des particularités de cette expérimentation réside dans l’éligibilité du dispositif qui peut être limitée à une partie seulement du  territoire communal. Lorsqu’une commune n’est éligible que pour une partie de son territoire, deux approches sont distinguées, à savoir à la maille de  l’IRIS (correspondant à un quartier) ou à la maille du carreau de 200 mètres sur 200 mètres.</Abstract><ows:Keywords><ows:Keyword>zonage</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-180.0 -85.0</ows:LowerCorner><ows:UpperCorner>180.0 85.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:wfs_du=\"http://wfs_du\"><Name>wfs_du:zone_urba</Name><Title>Zonage du document d'urbanisme</Title><Abstract>Zonage du document d'urbanisme</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.28125 -21.421484375</ows:LowerCorner><ows:UpperCorner>55.8984375 51.27109375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:DEBROUSSAILLEMENT=\"http://DEBROUSSAILLEMENT\"><Name>DEBROUSSAILLEMENT:debroussaillement</Name><Title>Zonage informatif des obligations légales de débroussaillement</Title><Abstract>Zonage informatif des obligations légales de débroussaillement</Abstract><ows:Keywords><ows:Keyword>débroussaillement</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-3.85125 41.31265625</ows:LowerCorner><ows:UpperCorner>9.7475 49.44546875</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:AREAMANAGEMENT.ZFU.VECTOR=\"http://AREAMANAGEMENT.ZFU.VECTOR\"><Name>AREAMANAGEMENT.ZFU.VECTOR:zfu</Name><Title>Zones Franches Urbaines</Title><Abstract>Zones Franches Urbaines</Abstract><ows:Keywords><ows:Keyword>Politique de la ville</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.04717125 -21.3338923</ows:LowerCorner><ows:UpperCorner>55.7557572 51.03907189</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:AREAMANAGEMENT.ZUS.VECTOR=\"http://AREAMANAGEMENT.ZUS.VECTOR\"><Name>AREAMANAGEMENT.ZUS.VECTOR:zus</Name><Title>Zones Urbaines Sensibles</Title><Abstract>Zones Urbaines Sensibles</Abstract><ows:Keywords><ows:Keyword>Politiques de la ville</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.04717125 -21.3338923</ows:LowerCorner><ows:UpperCorner>55.7557572 51.03907189</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.ZPR=\"http://PROTECTEDAREAS.ZPR\"><Name>PROTECTEDAREAS.ZPR:zpr</Name><Title>Zones de protection renforcée </Title><Abstract>L'arrêté préfectoral fixant la liste départementale de sites d'intérêt géologique est un outil règlementaire qui vise à protéger, par des mesures générales, les sites géologiques qui sont mentionnés en son sein. Il s'agit d'un des deux outils mis en place par le décret du 28 décembre 2015 codifié aux articles R.411-17-1 et 17-2 du code de l'environnement et précisé par la Note du 1er décembre 2016 relative à la protection des sites d'intérêt géologique</Abstract><ows:Keywords><ows:Keyword>protection</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-2.70339452 -51.59472222</ows:LowerCorner><ows:UpperCorner>81.5276315 48.52637697</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.ZNIEFF2=\"http://PROTECTEDAREAS.ZNIEFF2\"><Name>PROTECTEDAREAS.ZNIEFF2:znieff2</Name><Title>Zones fonctionnelles de nature remarquable (ZNIEFF2)</Title><Abstract>Inventaire des espaces fonctionnels indispensables à la nature remarquable.09-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.50882415 -21.38975484</ows:LowerCorner><ows:UpperCorner>55.83621545 51.06460175</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.RAMSAR=\"http://PROTECTEDAREAS.RAMSAR\"><Name>PROTECTEDAREAS.RAMSAR:ramsar</Name><Title>Zones humides d'importance internationale</Title><Abstract>Un site Ramsar est un espace désigné en application de la Convention relative aux zones humides d'importance internationale, particulièrement comme habitats des oiseaux d'eau, dont le traité a été signé en 1971 sur les bords de la mer Caspienne (Iran). Mise à jour 16-11-2021</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -49.83984375</ows:LowerCorner><ows:UpperCorner>77.87109375 51.002773438</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:ORTHOIMAGERY.ORTHOPHOS.RESTRICTEDAREAS=\"http://ORTHOIMAGERY.ORTHOPHOS.RESTRICTEDAREAS\"><Name>ORTHOIMAGERY.ORTHOPHOS.RESTRICTEDAREAS:arrete</Name><Title>Zones interdites à la captation aérienne des données (ZICAD)</Title><Abstract>Zones interdites à la captation aérienne des données (ZICAD) fixées par voie d'arrêté (arrêté du 02-01-2023 fixant la liste des zones interdites à la prise de vue aérienne par appareil photographique, cinématographique ou tout autre capteur). Édition octobre 203</Abstract><ows:Keywords><ows:Keyword>ZIPVA</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-151.5234375 -22.562792969</ows:LowerCorner><ows:UpperCorner>166.46484375 51.095507812</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.ZNIEFF1.SEA=\"http://PROTECTEDAREAS.ZNIEFF1.SEA\"><Name>PROTECTEDAREAS.ZNIEFF1.SEA:znieff1_mer</Name><Title>Zones naturelles d’intérêt écologique faunistique et floristique (ZNIEFF) marine type I</Title><Abstract>Espaces marin homogènes d’un point de vue écologique abritant au moins une espèce ou un habitat rare ou menacé, d’intérêt local ou régional, national ou communautaire. Espaces marin d’intérêt fonctionnel pour le fonctionnement écologique local. 09-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-61.875 -21.597265625</ows:LowerCorner><ows:UpperCorner>55.8984375 51.16890625</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.ZNIEFF2.SEA=\"http://PROTECTEDAREAS.ZNIEFF2.SEA\"><Name>PROTECTEDAREAS.ZNIEFF2.SEA:znieff2_mer</Name><Title>Zones naturelles d’intérêt écologique faunistique et floristique (ZNIEFF) marine type II</Title><Abstract>Espaces marin homogènes d’un point de vue écologique abritant au moins une espèce ou un habitat rare ou menacé, d’intérêt local ou régional, national ou communautaire. Espaces marin d’intérêt fonctionnel pour le fonctionnement écologique local.</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-54.052734375 -21.431132812</ows:LowerCorner><ows:UpperCorner>55.8984375 50.338242188</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.ZNIEFF1=\"http://PROTECTEDAREAS.ZNIEFF1\"><Name>PROTECTEDAREAS.ZNIEFF1:znieff1</Name><Title>Zones écologiques de nature remarquable (ZNIEFF1)</Title><Abstract>Inventaire des espaces naturels abritant la nature remarquable. 09-2022</Abstract><ows:Keywords><ows:Keyword>Ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.05589199 -21.38750685</ows:LowerCorner><ows:UpperCorner>55.83672006 51.09084342</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:aerodrome</Name><Title>aerodrome</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:arrondissement</Name><Title>arrondissement</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:arrondissement_municipal</Name><Title>arrondissement_municipal</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:bassin_versant_topographique</Name><Title>bassin_versant_topographique</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:cimetiere</Name><Title>cimetiere</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:collectivite_territoriale</Name><Title>collectivite_territoriale</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:commune</Name><Title>commune</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:commune_associee_ou_deleguee</Name><Title>commune_associee_ou_deleguee</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:construction_lineaire</Name><Title>construction_lineaire</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:construction_ponctuelle</Name><Title>construction_ponctuelle</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:construction_surfacique</Name><Title>construction_surfacique</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:cours_d_eau</Name><Title>cours_d_eau</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:cartes=\"http://cartes\"><Name>cartes:dataset</Name><Title>dataset</Title><Abstract>Cartes anciennes numérisées (Cartothèque IGN).</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.625 41.2009375</ows:LowerCorner><ows:UpperCorner>9.84375 51.8334375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:test_mig_rlt=\"http://test_mig_rlt\"><Name>test_mig_rlt:dataset</Name><Title>dataset</Title><Abstract>abstract</Abstract><ows:Keywords><ows:Keyword>labelito</ows:Keyword><ows:Keyword>labelita</ows:Keyword><ows:Keyword>label</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-89.0 -89.0</ows:LowerCorner><ows:UpperCorner>89.0 89.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:pva=\"http://pva\"><Name>pva:dataset</Name><Title>dataset</Title><Abstract>Ensemble des missions de prises de vue aériennes IGN scannées ou numériques</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-178.2421875 -49.83984375</ows:LowerCorner><ows:UpperCorner>168.3984375 51.16890625</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:departement</Name><Title>departement</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:detail_hydrographique</Name><Title>detail_hydrographique</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:detail_orographique</Name><Title>detail_orographique</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:epci</Name><Title>epci</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:equipement_de_transport</Name><Title>equipement_de_transport</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:jpe_test_open_io=\"http://jpe_test_open_io\"><Name>jpe_test_open_io:formation_vegetale</Name><Title>formation_vegetale</Title><Abstract>abstract_formation_vegetale</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::2154</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-179.0 -89.0</ows:LowerCorner><ows:UpperCorner>179.0 89.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:cartes=\"http://cartes\"><Name>cartes:image</Name><Title>image</Title><Abstract>Cartes anciennes numérisées (Cartothèque IGN).</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-5.625 41.2009375</ows:LowerCorner><ows:UpperCorner>9.84375 51.8334375</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:test_mig_rlt=\"http://test_mig_rlt\"><Name>test_mig_rlt:image</Name><Title>image</Title><Abstract>abstract</Abstract><ows:Keywords><ows:Keyword>labelito</ows:Keyword><ows:Keyword>labelita</ows:Keyword><ows:Keyword>label</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-89.0 -89.0</ows:LowerCorner><ows:UpperCorner>89.0 89.0</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:pva=\"http://pva\"><Name>pva:image</Name><Title>image</Title><Abstract>Ensemble des images des missions de prises de vue aériennes IGN</Abstract><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-178.2421875 -49.83984375</ows:LowerCorner><ows:UpperCorner>168.3984375 51.16890625</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:lieu_dit_non_habite</Name><Title>lieu_dit_non_habite</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:ligne_electrique</Name><Title>ligne_electrique</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:limite_terre_mer</Name><Title>limite_terre_mer</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:noeud_hydrographique</Name><Title>noeud_hydrographique</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:occupation_du_sol</Name><Title>occupation_du_sol</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:parc_ou_reserve</Name><Title>parc_ou_reserve</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:piste_d_aerodrome</Name><Title>piste_d_aerodrome</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:plan_d_eau</Name><Title>plan_d_eau</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:PROTECTEDAREAS.MNHN.RN.PERIMETER=\"http://PROTECTEDAREAS.MNHN.RN.PERIMETER\"><Name>PROTECTEDAREAS.MNHN.RN.PERIMETER:pprnn</Name><Title>périmètres de protection de réserves naturelles - PPRNN</Title><Abstract>Un périmètre de protection peut être institué en périphérie d’une réserve naturelle. Il concerne des espaces qui n’ont pas été classés en réserve et qui constituent une zone « tampon » autour de l’espace classé. Ils améliorent les échanges écologiques entre la réserve et sa périphérie. Mise à jour 09-2022</Abstract><ows:Keywords><ows:Keyword>ecologie</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::3857</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-60.83711192 14.40765258</ows:LowerCorner><ows:UpperCorner>6.65777824 50.26251827</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:region</Name><Title>region</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:reservoir</Name><Title>reservoir</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:rond_point</Name><Title>rond_point</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:route_numerotee_ou_nommee</Name><Title>route_numerotee_ou_nommee</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:surface_hydrographique</Name><Title>surface_hydrographique</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:transport_par_cable</Name><Title>transport_par_cable</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:troncon_de_route</Name><Title>troncon_de_route</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:troncon_hydrographique</Name><Title>troncon_hydrographique</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:voie_ferree_nommee</Name><Title>voie_ferree_nommee</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:zone_d_activite_ou_d_interet</Name><Title>zone_d_activite_ou_d_interet</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType><FeatureType xmlns:BDCARTO_V5=\"http://BDCARTO_V5\"><Name>BDCARTO_V5:zone_d_habitation</Name><Title>zone_d_habitation</Title><Abstract>BD CARTO® V5</Abstract><ows:Keywords><ows:Keyword>BDCARTO</ows:Keyword></ows:Keywords><DefaultCRS>urn:ogc:def:crs:EPSG::4326</DefaultCRS><ows:WGS84BoundingBox><ows:LowerCorner>-63.15371169 -21.38982666</ows:LowerCorner><ows:UpperCorner>55.83677582 51.31504801</ows:UpperCorner></ows:WGS84BoundingBox></FeatureType></FeatureTypeList></wfs:WFS_Capabilities>"), 
    request = structure(list(url = "https://data.geopf.fr/wfs/ows?service=wfs&version=2.0.0&request=GetCapabilities&sections=FeatureTypeList", 
        method = NULL, headers = list(), body = NULL, fields = list(), 
        options = list(), policies = list()), class = "httr2_request"), 
    cache = new.env(parent = emptyenv())), class = "httr2_response")
