% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epetition_tibble.R
\name{epetition_tibble}
\alias{epetition_tibble}
\alias{hansard_epetition_tibble}
\title{Bulk Epetitions}
\usage{
epetition_tibble(min_signatures = 1, max_signatures = NULL, status = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case")

hansard_epetition_tibble(min_signatures = 1, max_signatures = NULL,
  status = NULL, start_date = "1900-01-01", end_date = Sys.Date(),
  extra_args = NULL, tidy = TRUE, tidy_style = "snake_case")
}
\arguments{
\item{min_signatures}{The minimum number of signatures required for inclusion in the tibble. Defaults to 1.}

\item{max_signatures}{The maximum number of signatures required for inclusion in the tibble. If NULL, there no maximum number of signatures. Defaults to NULL.}

\item{status}{The status of the petition, either 'open' or 'closed'. If NULL, returns all petitions both open and closed. Defaults to NULL.}

\item{start_date}{The earliest date to include in the tibble. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with details on electronic petitions submitted to parliament.
}
\description{
Get data on all epetitions submitted to parliament, with the label, sponsor, number of signatures, date created and epetition ID. For greater detail on indidivual epetitions, see \code{\link{epetition}}.
}
\examples{
\dontrun{

x <- epetition_tibble()

y <- epetition_tibble(max_signatures=500)

z <- epetition_tibble(start_date="2016-12-01", end_date="2017-04-25")

}
}
\seealso{
\code{\link{epetition}}
}
\keyword{ePetitions}
