% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/research_briefings.R
\name{research_briefings}
\alias{research_briefings}
\title{research_briefings}
\usage{
research_briefings(resType = c("all", "topics", "types", "byTopic",
  "subTopic", "topicSubTopic"))
}
\arguments{
\item{resType}{The type of data you want, allows the arguments 'all', 'topics', 'types',
# 'byTopic','subTopic' and 'topicSubTopic'}

\item{all}{Imports a data frame with all available Parliamentary Research Briefings.}

\item{topics}{Imports a data frame with all Parliamentary Research Briefings topics.}

\item{types}{Imports a data frame with all Parliamentary Research Briefings types.}

\item{byTopic}{Requests a topic, and imports a data frame with all available Parliamentary Research Briefings on that topic}

\item{subTopic}{Requests a topic, and imports a data frame with all of the possible sub-topics for that topic.}

\item{topicSubTopic}{Requests a topic and a subtopic, and imports a data frame with all available Parliamentary Research Briefings on that subtopic}
}
\description{
Imports data on  Parliamentary Research Briefings
}
\examples{
\dontrun{
x <- research_briefings('all')

x <- research_briefings('topics')

x <- research_briefings('types')

x <- research_briefings('byTopic')

x <- research_briefings('subTopic')

x <- research_briefings('topicSubTopic')
}
}
\keyword{Briefings}
\keyword{Parliamentary}
\keyword{Research}

