% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_halk.R
\name{make_halk}
\alias{make_halk}
\title{Create a hierarchical age-length key (HALK)}
\usage{
make_halk(data, levels = NULL, age_col = "age", size_col = "length", ...)
}
\arguments{
\item{data}{A data.frame with age and size samples}

\item{levels}{Character vector specifying the levels for HALK creation}

\item{age_col}{Optional. String of the column name in \code{data} housing
age data}

\item{size_col}{Optional. String of the column name in \code{data} housing
size data}

\item{...}{Additional arguments passed to \code{\link{make_alk}}}
}
\value{
A \code{\link[tibble]{tibble}} with columns for each level and
a column called alk that houses the age-length key for that particular level
}
\description{
This function creates a hierarchically nested age-length key that can be
used to estimate age of an organism based on proportion of sampled organisms
in each age group.
}
\examples{
make_halk(spp_data, levels = "spp")
}
