% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.haldensify}
\alias{plot.haldensify}
\title{Plot Method for HAL Conditional Density Estimates}
\usage{
\method{plot}{haldensify}(x, ..., type = c("risk", "density"))
}
\arguments{
\item{x}{Object of class \code{haldensify}, containing conditional density
estimates, as produced by \code{\link{haldensify}}.}

\item{...}{Additional arguments to be passed \code{plot}, currently ignored.}

\item{type}{A \code{character} indicating the type of plot to be produced.
Options include visualizing the empirical risks of the conditional density
estimators across a grid of values of the regularization parameter and a
plot of the estimated conditional density (based on the estimator selected
by cross-validation). The latter has yet to be implemented.}
}
\value{
Object of class \code{ggplot} containing a plot of the desired
 \code{type}.
}
\description{
Plot Method for HAL Conditional Density Estimates
}
\examples{
# simulate data: W ~ U[-4, 4] and A|W ~ N(mu = W, sd = 0.5)
n_train <- 50
w <- runif(n_train, -4, 4)
a <- rnorm(n_train, w, 0.5)
# learn relationship A|W using HAL-based density estimation procedure
haldensify_fit <- haldensify(
  A = a, W = w, n_bins = 3,
  lambda_seq = exp(seq(-1, -10, length = 50)),
  # the following arguments are passed to hal9001::fit_hal()
  max_degree = 3, reduce_basis = 0.1
)
plot(haldensify_fit)
}
