% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hankel.R
\name{resample_hankel}
\alias{resample_hankel}
\title{Resample bootstrap samples in Hankel effmass}
\usage{
resample_hankel(hankel_effmass, distance = 5)
}
\arguments{
\item{hankel_effmass}{Hankel effective mass from \code{hankel2effmass}.}

\item{distance}{Numeric, threshold for marking outliers.}
}
\value{
The Hankel effmass object is returned with the same fields, the numbers
have been changed.

Additionally there are the followi1ng fields:
\itemize{
\item \code{cov_full} contains the full covariance matrix as determined from all the
data. This will be skewed by the outliers.
\item \code{finite_count} gives the number of non-outliers per time slice.
\item \code{complete_count} gives the numbers of complete cases if all outliers are
taken out. This number is often zero because the late time slices contain
lots of outliers due to the noise.
\item \code{cov_3sigma_pairwise} is the covariance matrix using only the non-outliers
and removing NAs in a pairwise fashion, using the maximum of the data. This
is the covariance matrix that is used for the resampling.
}

In case that no time slices had a finite error estimate, this function
returns just \code{NA}.
}
\description{
The bootstrap distribution in the Hankel effective mass can be quite broad
due to outliers and long tails. These screw with proper error estimation.
Therefore it can be useful to trim these tails. Just trimming a bootstrap
distribution would lead to less samples, therefore we do a parametric
resampling.
}
\details{
The central values are also inferred from the distribution because they
often are outliers themselves. The new central value is the middle between
the upper and lower quantile, making the resulting distribution symmetric.

Half the distance between the quantiles is taken to be the error, therefore
the quantiles are chosen at 16 and 84 percent to match the standard
deviation. All points that are more than “distance” errors away from the new
central value are taken to be outliers.
}
