% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.nlsfit.R
\name{parametric.bootstrap}
\alias{parametric.bootstrap}
\title{Parametric bootstrap}
\usage{
parametric.bootstrap(boot.R, x, dx, seed)
}
\arguments{
\item{boot.R}{numeric. Number of bootstrap samples to generate.}

\item{x}{numeric vector. Actual values for the data.}

\item{dx}{numeric vector of the same length as \code{x} or missing. Errors of the
values.}

\item{seed}{integer. Seed to use for the random number generation. If it is
missing, the seed will not be set to any particular value. If there was a
default value, all results would be exactly correlated. So if you want
reproducability by fixing the seeds, make sure you choose different seeds
for independent variables.}
}
\value{
A matrix with as many columns as there are variables in \code{x} and as many rows
as \code{boot.R}.
}
\description{
Parametric bootstrap
}
\examples{
x <- 1:3
dx <- 1:3 * 0.1
parametric.bootstrap(5, x, dx)
}
\seealso{
Other NLS fit functions: 
\code{\link{bootstrap.nlsfit}()},
\code{\link{parametric.bootstrap.cov}()},
\code{\link{parametric.nlsfit.cov}()},
\code{\link{parametric.nlsfit}()},
\code{\link{plot.bootstrapfit}()},
\code{\link{print.bootstrapfit}()},
\code{\link{simple.nlsfit}()},
\code{\link{summary.bootstrapfit}()}
}
\concept{NLS fit functions}
