% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvc_readutils.R
\name{correlators_key_meson_3pt}
\alias{correlators_key_meson_3pt}
\title{Generate HDF5 key for CVC 'correlators' meson 3pt function with a local or derivative insertion

The key for a meson three-point function has the form:

/sud+-g-u-g/t10/dt12/gf5/pfx0pfy0pfz0/gc0/Ddim0_dir0/Ddim1_dir1/D\link{...}/gi5/pix0piy0piz0

where, from left to right:
\itemize{
\item 'u' is the flavour of the "backward" propagator
\item 'd' is the flavour of the "sequential" propagator
\item '+' indicates that 'sud' is daggered
\item 'g' indicates a gamma insertion
\item 'u' is the flavour of the foward propagator
\item 'g' indicates a Dirac structure at the source
\item 'tXX' is the source time slice
\item 'dtYY' is the source-sink separation
\item 'gfN' gamma structure at the sink in CVC indexing
\item 'pfxXpfyYpfzZ' is the sink momentum in CVC convention (sink and source phases are both e^{ipx})
\item 'gcN' gamma structure at the current insertion point in CVC indexing
\item 'DdimJ_dirK' covariant displacement applied in dimension 'J', direction 'K'
where it should be noted that this is. in operator notation, i.e., the right-most
displacement is the one applied first.
\item \link{...}
\item 'giN' gamma structure at the souce in CVC indexing
\item 'pixXpiyYpizZ' at the source in CVC convention
}}
\usage{
correlators_key_meson_3pt(fwd_flav, bwd_flav, seq_flav, src_ts, dt, snk_gamma,
  cur_gamma, cur_displ_dim = NA, cur_displ_dir = NA, src_gamma, src_p,
  snk_p)
}
\arguments{
\item{fwd_flav}{String, "forward" quark flavour identifier.}

\item{bwd_flav}{String, "backward" quark flavour identifier.}

\item{seq_flav}{String, "sequential" quark flavour identifier.}

\item{src_ts}{Integer, source time slice.}

\item{dt}{Integer, source-sink separation.}

\item{snk_gamma}{Integer, CVC convention gamma matrix identifier at the source.}

\item{cur_gamma}{Integer, CVC convention gamma matrix identified at the insertion.}

\item{cur_displ_dim}{Integer vector of dimensions (0,1,2,3 <-> t,x,y,z) in which
covariant displacements have been applied. This vector will be
parsed in reverse order, such that the first element here
is the first displacement applied to the spinor in the calculation
and the right-most element in the key.
Length must be matched to 'cur_displ_dir'.
Defaults to 'NA' for no displacements.}

\item{cur_displ_dir}{Integer vector of directions (forward, backward) <-> (0,1) in
which the covariant displacements have been applied. Parsing
as for 'cur_displ_dim'. Length must be matched to 'cur_displ_dim'.
Defaults to 'NA' for no displacements.}

\item{src_gamma}{Integer, CVC convention gamma matrix identified at the sink.}

\item{src_p}{Integer vector of length 3. (x,y,z) components of the source momentum
vector in lattice units.}

\item{snk_p}{Integer vector of length 3. (x,y,z) components of the sink momentum
vector in lattice units.}
}
\value{
A character vector with the HDF5 key.
}
\description{
Generate HDF5 key for CVC 'correlators' meson 3pt function with a local or derivative insertion

The key for a meson three-point function has the form:

/sud+-g-u-g/t10/dt12/gf5/pfx0pfy0pfz0/gc0/Ddim0_dir0/Ddim1_dir1/D\link{...}/gi5/pix0piy0piz0

where, from left to right:
\itemize{
\item 'u' is the flavour of the "backward" propagator
\item 'd' is the flavour of the "sequential" propagator
\item '+' indicates that 'sud' is daggered
\item 'g' indicates a gamma insertion
\item 'u' is the flavour of the foward propagator
\item 'g' indicates a Dirac structure at the source
\item 'tXX' is the source time slice
\item 'dtYY' is the source-sink separation
\item 'gfN' gamma structure at the sink in CVC indexing
\item 'pfxXpfyYpfzZ' is the sink momentum in CVC convention (sink and source phases are both e^{ipx})
\item 'gcN' gamma structure at the current insertion point in CVC indexing
\item 'DdimJ_dirK' covariant displacement applied in dimension 'J', direction 'K'
where it should be noted that this is. in operator notation, i.e., the right-most
displacement is the one applied first.
\item \link{...}
\item 'giN' gamma structure at the souce in CVC indexing
\item 'pixXpiyYpizZ' at the source in CVC convention
}
}
