% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_sd.R
\name{fd_sd}
\alias{fd_sd}
\title{Calculate fractal Dimension using the standard deviation method}
\usage{
fd_sd(
  data,
  lvec,
  regmethod = "mean",
  keep_data = FALSE,
  plot = FALSE,
  parallel = FALSE,
  ncores = (parallel::detectCores() - 1)
)
}
\arguments{
\item{data}{Digital elevation model of class RasterLayer.}

\item{lvec}{Vector of scales to use for calculation.}

\item{regmethod}{Method to use for linear regression between scale (lvec) and height range. One of \code{raw} (all data), \code{mean} (default) \code{median} or \code{ends} (minimum and maximum scale only)}

\item{keep_data}{Logical. Keep the data used for fd calculation? Defaults to FALSE.}

\item{plot}{Logical. Show plot of scales relative to data?}

\item{parallel}{Logical. Use parallel processing? Note: parallel must be installed.}

\item{ncores}{Number of cores to use when parallel = TRUE.}
}
\value{
A value for fractal dimension, typically between 2 and 3 or a list if keep_data = TRUE.
}
\description{
Calculate fractal Dimension using the standard deviation method
}
\details{
Calculates fractal dimension using the standard deviation method,
an analogue of the variation method, but using the standard deviation in height per grid cell instead of the full height range.
If \code{lvec} is not specified, a default based on resolution and extent will be used.
A rule of thumb is that \code{lvec} should range at least an order of magnitude.
However, large ranges also average-out fractal dimension of a surface that might have
phase transitions, and therefore a thorough exploration of height ranges is suggested using the \code{plot}.
\code{regmethod} specifies whether data is summarized by taking the mean or median of height ranges across scales or all data is used.
\code{regmethod} "raw" is not recommended because the regression will give much more weight to the lower scales that include more points and likely underestimate D.
}
\examples{
\donttest{
dem <- habtools::dem_crop(horseshoe, x0 = -469, y0 = 1267, L = 2, plot = TRUE)
fd_sd(dem, lvec = c(0.125, 0.25, 0.5, 1, 2))
}
}
