% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DataSpace.R
\docType{class}
\name{DataSpace}
\alias{DataSpace}
\alias{DataSpace-class}
\alias{h5close,DataSpace-method}
\alias{selectDataSpace}
\alias{selectDataSpace,DataSet,ANY,ANY,missing-method}
\alias{selectDataSpace,DataSet,missing,missing,matrix-method}
\alias{selectDataSpace,DataSet,missing,missing,missing-method}
\title{The DataSpace Class}
\usage{
\S4method{h5close}{DataSpace}(.Object)

selectDataSpace(.Object, offset = rep(NA_integer_, length(.Object@dim)),
  count = rep(NA_integer_, length(.Object@dim)), elem)

\S4method{selectDataSpace}{DataSet,missing,missing,missing}(.Object)

\S4method{selectDataSpace}{DataSet,ANY,ANY,missing}(.Object, offset, count)

\S4method{selectDataSpace}{DataSet,missing,missing,matrix}(.Object, elem)
}
\arguments{
\item{.Object}{DataSet; S4 object of class \code{DataSet}
(\code{DataSpace} for \code{h5close}).}

\item{offset}{numeric; Offset to be selected from Hyperslab.}

\item{count}{numeric; Count to be selected from Hyperslab.}

\item{elem}{matrix; Matrix specifying element selection coordinates.
Columns specify rank, rows specify different points.}

\item{...}{additional arguments passed to \code{\link{c}}.}
}
\description{
The DataSpace class used to select data elements from \code{\link{DataSet}}
objects. DataSpace objects can be generated using the S4--method
\code{selectDataSpace} from DataSets objects in 3 ways:
\enumerate{
  \item{Without any parameters: Select all elements in \code{\link{DataSet}}}.
  \item{With \code{offset} and \code{count}: Select contiguous sub--region
  (hyperslab) from \code{\link{DataSet}}.}
  \item{With parameter \code{elem}: Select sub-elements specified by matrix
    holding selected indices. This selection type can become slow for many
    data points.}
}
}

