% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.match}
\alias{\%in\%}
\alias{h2o.match}
\alias{match.Frame}
\title{Value Matching in H2O}
\usage{
h2o.match(x, table, nomatch = 0, incomparables = NULL)

match.Frame(x, table, nomatch = 0, incomparables = NULL)

x \%in\% table
}
\arguments{
\item{x}{a categorical vector from an H2O Frame object with
values to be matched.}

\item{table}{an R object to match \code{x} against.}

\item{nomatch}{the value to be returned in the case when no match is found.}

\item{incomparables}{a vector of calues that cannot be matched. Any value in
\code{x} matching a value in this vector is assigned the
\code{nomatch} value.}
}
\description{
\code{match} and \code{\%in\%} return values similar to the base R generic
functions.
}
\examples{
\donttest{
h2o.init()
hex <- as.h2o(iris)
h2o.match(hex[,5], c("setosa", "versicolor"))
}
}
\seealso{
\code{\link[base]{match}} for base R implementation.
}

