% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.grid}
\alias{h2o.grid}
\title{H2O Grid Support}
\usage{
h2o.grid(algorithm, grid_id, ..., hyper_params = list(),
  is_supervised = NULL, do_hyper_params_check = FALSE)
}
\arguments{
\item{algorithm}{name of algorithm to use in grid search (gbm, randomForest, kmeans, glm, deeplearning, naivebayes, pca)}

\item{grid_id}{optional id for resulting grid search, if it is not specified then it is autogenerated}

\item{...}{arguments describing parameters to use with algorithm (i.e., x, y, training_frame).
Look at the specific algorithm - h2o.gbm, h2o.glm, h2o.kmeans, h2o.deepLearning}

\item{hyper_params}{list of hyper parameters (i.e., \code{list(ntrees=c(1,2), max_depth=c(5,7))})}

\item{is_supervised}{if specified then override default heuristing which decide if given algorithm
name and parameters specify super/unsupervised algorithm.}

\item{do_hyper_params_check}{perform client check for specified hyper parameters. It can be time expensive for
large hyper space}
}
\description{
Provides a set of functions to launch a grid search and get
its results.
}
\details{
Launch grid search with given algorithm and parameters.
}
\examples{
\donttest{
library(h2o)
library(jsonlite)
h2o.init()
iris.hex <- as.h2o(iris)
grid <- h2o.grid("gbm", x = c(1:4), y = 5, training_frame = iris.hex,
                 hyper_params = list(ntrees = c(1,2,3)))
# Get grid summary
summary(grid)
# Fetch grid models
model_ids <- grid@model_ids
models <- lapply(model_ids, function(id) { h2o.getModel(id)})
}
}

